/*
 * Decompiled with CFR 0.152.
 */
package kid.graphics;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import kid.robot.RobotData;
import robocode.Robot;

public class RGraphics
extends Graphics2D {
    private Graphics2D graphics;
    private RobotData robot;
    private String commandString;

    public RGraphics(Graphics2D graphics, Robot myRobot) {
        this.init(graphics, myRobot, new String());
    }

    public RGraphics(Graphics2D graphics, Robot myRobot, String commandString) {
        this.init(graphics, myRobot, commandString);
    }

    private void init(Graphics2D graphics, Robot myRobot, String commandString) {
        this.graphics = graphics;
        this.robot = new RobotData(myRobot);
        this.commandString = commandString;
    }

    public String getCommandString() {
        return this.commandString;
    }

    public long getTime() {
        return this.robot.getTime();
    }

    public RobotData getRobot() {
        return this.robot;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.graphics.drawLine(x1, y1, x2, y2);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.graphics.drawOval(x, y, width, height);
    }

    public void drawOval(double x, double y, double width, double height) {
        this.drawOval((int)x, (int)y, (int)width, (int)height);
    }

    public void drawOvalCenter(int x, int y, int width, int height) {
        this.drawOval((double)x - (double)width / 2.0, (double)y - (double)height / 2.0, (double)width, (double)height);
    }

    public void drawOvalCenter(double x, double y, double width, double height) {
        this.drawOvalCenter((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.graphics.fillOval(x, y, width, height);
    }

    public void fillOval(double x, double y, double width, double height) {
        this.fillOval((int)x, (int)y, (int)width, (int)height);
    }

    public void fillOvalCenter(int x, int y, int width, int height) {
        this.fillOval((double)x - (double)width / 2.0, (double)y - (double)height / 2.0, (double)width, (double)height);
    }

    public void fillOvalCenter(double x, double y, double width, double height) {
        this.fillOvalCenter((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.graphics.fillRect(x, y, width, height);
    }

    public void fillRect(double x, double y, double width, double height) {
        this.fillRect((int)x, (int)y, (int)width, (int)height);
    }

    public void fillRectCenter(int x, int y, int width, int height) {
        this.fillRect((double)x - (double)width / 2.0, (double)y - (double)height / 2.0, (double)width, (double)height);
    }

    public void fillRectCenter(double x, double y, double width, double height) {
        this.fillRectCenter((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void drawArc(int x, int y, int circleWidth, int circleHeight, int startAngle, int arcAngle) {
        this.graphics.drawArc(x, y, circleWidth, circleHeight, startAngle, arcAngle);
    }

    public void drawArc(double x, double y, double circleWidth, double circleHeight, double startAngle, double arcAngle) {
        this.drawArc((int)x, (int)y, (int)circleWidth, (int)circleHeight, (int)startAngle, (int)arcAngle);
    }

    public void drawArcCenter(int x, int y, int circleWidth, int circleHeight, int startAngle, int arcAngle) {
        this.drawArc((double)x - (double)circleWidth / 2.0, (double)y - (double)circleHeight / 2.0, (double)circleWidth, (double)circleHeight, (double)startAngle, (double)arcAngle);
    }

    public void drawArcCenter(double x, double y, double circleWidth, double circleHeight, double startAngle, double arcAngle) {
        this.drawArcCenter((int)x, (int)y, (int)circleWidth, (int)circleHeight, (int)startAngle, (int)arcAngle);
    }

    @Override
    public Color getColor() {
        return this.graphics.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.graphics.setColor(c);
    }

    @Override
    public Font getFont() {
        return this.graphics.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.graphics.setFont(font);
    }

    public void drawString(String s, double x, double y) {
        this.drawString(s, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        this.graphics.drawString(str, x, y);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.graphics.drawString(str, x, y);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.graphics.drawRect(x, y, width, height);
    }

    public void drawRect(double x, double y, double width, double height) {
        this.drawRect((int)x, (int)y, (int)width, (int)height);
    }

    public void drawRectCenter(int x, int y, int width, int height) {
        this.drawRect((double)x - (double)width / 2.0, (double)y - (double)height / 2.0, (double)width, (double)height);
    }

    public void drawRectCenter(double x, double y, double width, double height) {
        this.drawRectCenter((int)x, (int)y, (int)width, (int)height);
    }

    @Override
    public void dispose() {
        this.graphics.dispose();
    }

    @Override
    public void setPaintMode() {
        this.graphics.setPaintMode();
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        this.graphics.clearRect(x, y, width, height);
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.graphics.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.graphics.setClip(x, y, width, height);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.graphics.copyArea(x, y, width, height, dx, dy);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void fillArc(int x, int y, int circleWidth, int circleHeight, int startAngle, int arcAngle) {
        this.graphics.fillArc(x, y, circleWidth, circleHeight, startAngle, arcAngle);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.graphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.graphics.drawPolyline(xPoints, yPoints, nPoints);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.graphics.fillPolygon(xPoints, yPoints, nPoints);
    }

    @Override
    public void setXORMode(Color c1) {
        this.graphics.setXORMode(c1);
    }

    @Override
    public Graphics create() {
        return this.graphics.create();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.graphics.getClipBounds();
    }

    @Override
    public Shape getClip() {
        return this.graphics.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.graphics.setClip(clip);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.graphics.getFontMetrics(f);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.graphics.drawImage(img, x, y, width, height, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.graphics.drawImage(img, x, y, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.graphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.graphics.drawImage(img, x, y, width, height, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.graphics.drawImage(img, x, y, bgcolor, observer);
    }

    @Override
    public void rotate(double theta) {
        this.graphics.rotate(theta);
    }

    @Override
    public void scale(double sx, double sy) {
        this.graphics.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.graphics.shear(shx, shy);
    }

    @Override
    public void translate(double tx, double ty) {
        this.graphics.translate(tx, ty);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.graphics.rotate(theta, x, y);
    }

    @Override
    public void translate(int x, int y) {
        this.graphics.translate(x, y);
    }

    @Override
    public Color getBackground() {
        return this.graphics.getBackground();
    }

    @Override
    public void setBackground(Color color) {
        this.graphics.setBackground(color);
    }

    @Override
    public Composite getComposite() {
        return this.graphics.getComposite();
    }

    @Override
    public void setComposite(Composite comp) {
        this.graphics.setComposite(comp);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphics.getDeviceConfiguration();
    }

    @Override
    public Paint getPaint() {
        return this.graphics.getPaint();
    }

    @Override
    public void setPaint(Paint paint) {
        this.graphics.setPaint(paint);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.graphics.getRenderingHints();
    }

    @Override
    public void clip(Shape s) {
        this.graphics.clip(s);
    }

    @Override
    public void draw(Shape s) {
        this.graphics.draw(s);
    }

    public void draw(Shape[] shapes) {
        Shape[] shapeArray = shapes;
        int n = shapes.length;
        int n2 = 0;
        while (n2 < n) {
            Shape s = shapeArray[n2];
            this.draw(s);
            ++n2;
        }
    }

    @Override
    public void fill(Shape s) {
        this.graphics.fill(s);
    }

    @Override
    public Stroke getStroke() {
        return this.graphics.getStroke();
    }

    @Override
    public void setStroke(Stroke s) {
        this.graphics.setStroke(s);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.graphics.getFontRenderContext();
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.graphics.drawGlyphVector(g, x, y);
    }

    @Override
    public AffineTransform getTransform() {
        return this.graphics.getTransform();
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.graphics.setTransform(Tx);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.graphics.transform(Tx);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.graphics.drawString(iterator, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.graphics.drawString(iterator, x, y);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.graphics.addRenderingHints(hints);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.graphics.setRenderingHints(hints);
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.graphics.hit(rect, s, onStroke);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.graphics.drawRenderedImage(img, xform);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.graphics.drawRenderableImage(img, xform);
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.graphics.drawImage(img, op, x, y);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.graphics.getRenderingHint(hintKey);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.graphics.setRenderingHint(hintKey, hintValue);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.graphics.drawImage(img, xform, obs);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.graphics.drawPolygon(xPoints, yPoints, nPoints);
    }
}

