/*
 * Decompiled with CFR 0.152.
 */
package kid.utils;

import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.List;
import kid.info.RobotInfo;
import kid.robot.RobotData;
import kid.virtual.VirtualWave;
import robocode.Bullet;
import robocode.Robot;
import robocode.Rules;

public class Utils {
    public static final double ONE_THIRD = 0.3333333333333333;
    public static final double TWO_THIRDS = 0.6666666666666666;
    public static final double CIRCLE = 360.0;
    public static final double HALF_CIRCLE = 180.0;
    public static final double QUARTER_CIRCLE = 90.0;
    public static final double EIGHTIETH_CIRCLE = 45.0;

    private Utils() {
    }

    public static final double toRadians(double a) {
        return Math.PI * a / 180.0;
    }

    public static final double fromRadians(double a) {
        return 180.0 * a / Math.PI;
    }

    public static final double absMin(double a, double b) {
        return Math.abs(a) <= Math.abs(b) ? a : b;
    }

    public static final double absMax(double a, double b) {
        return Math.abs(a) >= Math.abs(b) ? a : b;
    }

    public static final double absolute(double n) {
        while (n < 0.0) {
            n += 360.0;
        }
        while (n >= 360.0) {
            n -= 360.0;
        }
        return n;
    }

    public static final double sin(double n) {
        return Math.sin(Utils.toRadians(n));
    }

    public static final double cos(double n) {
        return Math.cos(Utils.toRadians(n));
    }

    public static final double tan(double n) {
        return Math.tan(Utils.toRadians(n));
    }

    public static final double asin(double n) {
        return Utils.fromRadians(Math.asin(n));
    }

    public static final double acos(double n) {
        return Utils.fromRadians(Math.acos(n));
    }

    public static final double atan(double n) {
        return Utils.fromRadians(Math.atan(n));
    }

    public static final double atan2(double x, double y) {
        return Utils.fromRadians(Math.atan2(x, y));
    }

    public static final double avg(double[] values) {
        if (values == null) {
            return 0.0;
        }
        double value = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double item = dArray[n2];
            value += item;
            ++n2;
        }
        return value / (double)values.length;
    }

    public static final double avg(double[] values, double[] weight) {
        if (values == null || weight == null || values.length != weight.length) {
            return 0.0;
        }
        double total = 0.0;
        double totalWeight = 0.0;
        int index = 0;
        while (index < values.length) {
            total += values[index] + weight[index];
            totalWeight += weight[index];
            ++index;
        }
        return total / totalWeight;
    }

    public static final double sqrt(double n) {
        double sqrt = Math.sqrt(n);
        return sqrt;
    }

    public static final double sqr(double n) {
        return n * n;
    }

    public static final double cube(double n) {
        return n * n * n;
    }

    public static final double angle(double deltaX, double deltaY) {
        return Utils.atan2(deltaX, deltaY);
    }

    public static final double angle(double x1, double y1, double x2, double y2) {
        return Utils.angle(x2 - x1, y2 - y1);
    }

    public static final double angle(RobotData r1, RobotData r2) {
        return Utils.angle(r1.getX(), r1.getY(), r2.getX(), r2.getY());
    }

    public static final double angle(Point2D p1, Point2D p2) {
        return Utils.angle(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static final double getAngleOffset(double x, double y, RobotData robot, double guessFactor, double firePower) {
        double d = Utils.getDirection(robot.getHeading(), robot.getVelocity(), Utils.angle(x, y, robot.getX(), robot.getY()));
        return d * guessFactor * Utils.getMaxEscapeAngle(firePower);
    }

    public static final double getAngleOffset(Robot myRobot, RobotData robot, double guessFactor, double firePower) {
        return Utils.getAngleOffset(myRobot.getX(), myRobot.getY(), robot, guessFactor, firePower);
    }

    public static final int getDirection(double robotHeading, double robotVelocity, double angleToRobot) {
        return Utils.sign(Utils.sin(robotHeading - angleToRobot) * robotVelocity);
    }

    public static final double getMaxEscapeAngle(double firePower) {
        return Utils.asin(8.0 / Rules.getBulletSpeed((double)firePower));
    }

    public static final double distSq(double deltaX, double deltaY) {
        return Utils.sqr(deltaX) + Utils.sqr(deltaY);
    }

    public static final double distSq(double x1, double y1, double x2, double y2) {
        return Utils.distSq(x1 - x2, y1 - y2);
    }

    public static final double distSq(Point2D p, double x, double y) {
        return Utils.distSq(p.getX(), p.getY(), x, y);
    }

    public static final double distSq(Point2D p1, Point2D p2) {
        return Utils.distSq(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static final double dist(double deltaX, double deltaY) {
        return Utils.sqrt(Utils.distSq(deltaX, deltaY));
    }

    public static final double dist(double x1, double y1, double x2, double y2) {
        return Utils.sqrt(Utils.distSq(x1, y1, x2, y2));
    }

    public static final double dist(Point2D p1, Point2D p2) {
        return Utils.sqrt(Utils.distSq(p1, p2));
    }

    public static final double getGuessFactor(int index, int listlength) {
        return ((double)index - ((double)listlength - 1.0) / 2.0) / (double)((listlength - 1) / 2);
    }

    public static final double getGuessFactor(VirtualWave wave, RobotData start, RobotData finish) {
        return Utils.getGuessFactor(wave, start, finish.getX(), finish.getY());
    }

    public static final double getGuessFactor(VirtualWave wave, RobotData start, Robot finish) {
        return Utils.getGuessFactor(wave, start, finish.getX(), finish.getY());
    }

    public static final double getGuessFactor(VirtualWave wave, RobotData start, Bullet bullet) {
        double angleToStart = wave.getHeading();
        double direction = Utils.getDirection(start.getHeading(), start.getVelocity(), angleToStart);
        double angleOffset = Utils.relative(bullet.getHeading() - wave.getHeading());
        return Utils.limit(-1.0, angleOffset / wave.getMaxEscapeAngle(), 1.0) * direction;
    }

    public static final double getGuessFactor(VirtualWave wave, RobotData start, double xFianl, double yFinal) {
        double angleToStart = wave.getHeading();
        double direction = Utils.getDirection(start.getHeading(), start.getVelocity(), angleToStart);
        double angleToFinish = Utils.angle(wave.getStartX(), wave.getStartY(), xFianl, yFinal);
        double angleOffset = Utils.relative(angleToFinish - wave.getHeading());
        return Utils.limit(-1.0, angleOffset / wave.getMaxEscapeAngle(), 1.0) * direction;
    }

    public static final int getIndex(double guessfactor, int listlength) {
        return Utils.round(((double)listlength - 1.0) / 2.0 * (guessfactor + 1.0));
    }

    public static final Point2D getPoint(Point2D origin, double distance, double angle) {
        return Utils.getPoint(origin.getX(), origin.getY(), distance, angle);
    }

    public static final Point2D getPoint(double x, double y, double distance, double angle) {
        return new Point2D.Double(Utils.getX(x, distance, angle), Utils.getY(y, distance, angle));
    }

    public static final double getX(double x, double distance, double angle) {
        return x + Utils.getDeltaX(distance, angle);
    }

    public static final double getDeltaX(double distance, double angle) {
        return distance * Utils.sin(angle);
    }

    public static final double getY(double y, double distance, double angle) {
        return y + Utils.getDeltaY(distance, angle);
    }

    public static final double getDeltaY(double distance, double angle) {
        return distance * Utils.cos(angle);
    }

    public static final double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static final double oppositeRelative(double angle) {
        return Utils.relative(angle + 180.0);
    }

    public static final double random(double n1, double n2) {
        return Math.abs(n1 - n2) * Math.random() + Math.min(n1, n2);
    }

    public static final double oppositeAbsolute(double angle) {
        return Utils.absolute(angle + 180.0);
    }

    public static final double relative(double n) {
        if (!Double.isInfinite(n) && !Double.isNaN(n)) {
            while (n <= -180.0) {
                n += 360.0;
            }
            while (n > 180.0) {
                n -= 360.0;
            }
        }
        return n;
    }

    public static final double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public static final int round(double n) {
        return (int)(n + 0.5);
    }

    public static final double round(double n, double p) {
        return (double)Utils.round(n / p) * p;
    }

    public static final int roundUp(double n) {
        return (double)((int)n) == n ? (int)n : (int)(n + 1.0);
    }

    public static final int sign(double n) {
        return n < 0.0 ? -1 : 1;
    }

    public static final double weightedAvg(double value_1, double weight_1, double value_2, double weight_2) {
        return (value_1 * weight_1 + value_2 * weight_2) / (weight_1 + weight_2);
    }

    public static final char getPattern(double deltaHeading, double velocity) {
        int charVelocity = (int)((velocity + 8.0) * 15.0 / 16.0);
        int charDeltaHeading = (int)((deltaHeading + RobotInfo.MAX_TURN_RATE) * 127.0 / (2.0 * RobotInfo.MAX_TURN_RATE));
        return (char)(charVelocity << 7 | charDeltaHeading);
    }

    public static final double getHeading(char pattern) {
        int dHeading = 0x7F & pattern;
        return (double)dHeading * (2.0 * RobotInfo.MAX_TURN_RATE) / 127.0 - RobotInfo.MAX_TURN_RATE;
    }

    public static final double getVelocity(char pattern) {
        int dHeading = 0xF & pattern >> 7;
        return (double)dHeading * 16.0 / 15.0 - 8.0;
    }

    public static final <E extends VirtualWave> E findWaveMatch(List<E> waves, Bullet bullet, long time) {
        VirtualWave wave = null;
        int i = 0;
        while (i < waves.size() && wave == null) {
            double waveDist;
            VirtualWave w = (VirtualWave)waves.get(i);
            double bulletDist = Utils.dist(w.getStartX(), w.getStartY(), bullet.getX(), bullet.getY());
            if ((Math.abs(bulletDist - (waveDist = w.getDist(time) - (bullet.isActive() ? 0.0 : bullet.getVelocity()))) < 1.0 || Math.abs(bulletDist - waveDist - bullet.getVelocity()) < 1.0) && Math.abs(w.getFirePower() - bullet.getPower()) < 0.2) {
                wave = w;
            }
            ++i;
        }
        return (E)wave;
    }

    public static final double maxEscapeAngle(double bulletVelocity) {
        return Utils.asin(8.0 / bulletVelocity);
    }

    public static final boolean between(double a, double n, double b) {
        return n >= a && n <= b && a >= b;
    }

    public static final boolean contains(Object[] list, int position) {
        return position >= 0 && position < list.length;
    }

    public static final boolean contains(Collection<?> list, int position) {
        return position >= 0 && position < list.size();
    }

    public static final <E> int index(E[] array, E obj) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(obj) || array[i] == obj) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

