/*
 * Decompiled with CFR 0.152.
 */
package kid.virtual;

import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import kid.graphics.Colors;
import kid.graphics.RGraphics;
import kid.robot.RobotData;
import kid.utils.Utils;
import kid.virtual.VirtualObject;
import robocode.RobocodeFileOutputStream;
import robocode.Robot;
import robocode.Rules;

public class VirtualWave
extends VirtualObject {
    private static final long serialVersionUID = 3030661579076677220L;
    protected double startX;
    protected double startY;
    protected double heading;
    protected double firePower;
    protected double velocity;
    protected double maxEscapeAngle;
    protected long creationTime;

    public VirtualWave() {
        this.init(-100.0, -100.0, 180.0, 0.0, -1L);
    }

    public VirtualWave(double startX, double startY, double heading, double firePower, long creationTime) {
        this.init(startX, startY, heading, firePower, creationTime);
    }

    protected VirtualWave(VirtualWave wave) {
        this.init(wave.getStartX(), wave.getStartX(), wave.getHeading(), wave.getFirePower(), wave.getCreationTime());
    }

    private void init(double startX, double startY, double heading, double firePower, long creationTime) {
        this.startX = startX;
        this.startY = startY;
        this.heading = heading;
        this.firePower = firePower;
        this.velocity = Rules.getBulletSpeed((double)this.firePower);
        this.maxEscapeAngle = Utils.maxEscapeAngle(this.velocity);
        this.creationTime = creationTime;
    }

    public double getMaxEscapeAngle() {
        return this.maxEscapeAngle;
    }

    public double getStartX() {
        return this.startX;
    }

    public double getStartY() {
        return this.startY;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getFirePower() {
        return this.firePower;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public boolean active(long time) {
        return !(this.getStartX() < 0.0 || this.getStartY() < 0.0 || this.getDist(time) > 7500.0);
    }

    public double getDist(long time) {
        return this.getVelocity() * (double)(time - this.getCreationTime());
    }

    public double getDistSq(long time) {
        return Utils.sqr(this.getDist(time));
    }

    public double getDistToImpact(double x, double y, long time) {
        double dist = Utils.dist(this.getStartX(), this.getStartY(), x, y);
        return dist -= this.getDist(time);
    }

    public long getTimeToImpact(double x, double y, long time) {
        double dist = this.getDistToImpact(x, y, time);
        return (long)(dist / this.getVelocity());
    }

    public boolean testHit(RobotData robot, long time) {
        return this.testHit(robot.getX(), robot.getY(), time);
    }

    public boolean testHit(Robot robot) {
        return this.testHit(robot.getX(), robot.getY(), robot.getTime());
    }

    public boolean testHit(Rectangle2D rectangle, long time) {
        return this.testHit(rectangle.getCenterX(), rectangle.getCenterY(), time);
    }

    public boolean testHit(double x, double y, long time) {
        return Utils.distSq(this.getStartX(), this.getStartY(), x, y) <= Utils.sqr(this.getDist(time));
    }

    @Override
    public void print(PrintStream console) {
        console.println("VirtualWave: (" + this.getStartX() + ", " + this.getStartY() + ") " + this.getHeading());
    }

    @Override
    public void print(RobocodeFileOutputStream output) {
    }

    @Override
    public void draw(RGraphics grid) {
        double dist = this.getDist(grid.getTime());
        if (dist < 7500.0) {
            grid.setColor(Colors.SILVER);
            grid.drawArcCenter(this.getStartX(), this.getStartY(), 2.0 * dist, 2.0 * dist, this.getHeading() - this.getMaxEscapeAngle(), 2.0 * this.getMaxEscapeAngle());
            grid.fillOvalCenter(this.getStartX(), this.getStartY(), 5.0, 5.0);
            grid.drawLine(this.getStartX(), this.getStartY(), Utils.getX(this.getStartX(), dist, this.getHeading() - this.getMaxEscapeAngle()), Utils.getY(this.getStartY(), dist, this.getHeading() - this.getMaxEscapeAngle()));
            grid.drawLine(this.getStartX(), this.getStartY(), Utils.getX(this.getStartX(), dist, this.getHeading() + this.getMaxEscapeAngle()), Utils.getY(this.getStartY(), dist, this.getHeading() + this.getMaxEscapeAngle()));
        }
    }

    public Object clone() {
        return new VirtualWave(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualWave) {
            VirtualWave wave = (VirtualWave)obj;
            return wave.getStartX() == this.getStartX() && wave.getStartY() == this.getStartY() && wave.getHeading() == this.getHeading() && wave.getCreationTime() == this.getCreationTime();
        }
        return false;
    }

    public String toString() {
        return new String();
    }

    public void finalize() {
        this.startX = 0.0;
        this.startY = 0.0;
        this.heading = 0.0;
        this.firePower = 0.0;
        this.velocity = 0.0;
        this.maxEscapeAngle = 0.0;
        this.creationTime = 0L;
    }
}

