/*
 * Decompiled with CFR 0.152.
 */
package rtk;

import java.util.ArrayList;
import java.util.Collection;

public class ArrayListCapped<E>
extends ArrayList<E> {
    private static final long serialVersionUID = -2859706767484187604L;
    private int cap = -1;

    public ArrayListCapped(int cap) {
        this.cap = cap;
    }

    @Override
    public boolean add(E e) {
        if (this.size() >= this.cap && this.cap > 0) {
            this.remove(0);
        }
        return super.add(e);
    }

    @Override
    public void add(int i, E e) {
        if (this.size() >= this.cap && this.cap > 0) {
            this.remove(0);
        }
        super.add(i, e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.cap >= c.size()) {
            while (this.size() + c.size() >= this.cap && this.cap > 0) {
                this.remove(0);
            }
            return super.addAll(c);
        }
        throw new IllegalArgumentException("Collection size (" + c.size() + ") bigger than cap size (" + this.cap + ").");
    }

    @Override
    public boolean addAll(int i, Collection<? extends E> c) {
        if (this.cap >= c.size()) {
            while (this.size() + c.size() >= this.cap && this.cap > 0) {
                this.remove(0);
            }
            return super.addAll(i, c);
        }
        throw new IllegalArgumentException("Collection size (" + c.size() + ") bigger than cap size (" + this.cap + ").");
    }
}

