/*
 * Decompiled with CFR 0.152.
 */
package scheronimus;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import scheronimus.TargetingStrategy.LinearCircularTargeting;
import scheronimus.TargetingStrategy.TargetingStrategy;
import scheronimus.Util.Statistic;

public class AntiRebel
extends AdvancedRobot {
    private Statistic matchStat = new Statistic();
    public static int BINS = 47;
    public static double[] _surfStats = new double[BINS];
    public Point2D.Double _myLocation;
    public Point2D.Double _enemyLocation;
    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;
    private static Statistic globalStats = new Statistic();
    public static double _oppEnergy = 100.0;
    public static Rectangle2D.Double _fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    public static double WALL_STICK = 160.0;
    private static TargetingStrategy targetingStrategy = new LinearCircularTargeting();

    public void run() {
        this._enemyWaves = new ArrayList();
        this._surfDirections = new ArrayList();
        this._surfAbsBearings = new ArrayList();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this._myLocation = new Point2D.Double(this.getX(), this.getY());
        double lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
        this._surfDirections.add(0, new Integer(lateralVelocity >= 0.0 ? 1 : -1));
        this._surfAbsBearings.add(0, new Double(absBearing + Math.PI));
        double bulletPower = _oppEnergy - e.getEnergy();
        if (bulletPower < 3.01 && bulletPower > 0.09 && this._surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = this.getTime() - 1L;
            ew.bulletVelocity = AntiRebel.bulletVelocity(bulletPower);
            ew.distanceTraveled = AntiRebel.bulletVelocity(bulletPower);
            ew.direction = (Integer)this._surfDirections.get(2);
            ew.directAngle = (Double)this._surfAbsBearings.get(2);
            ew.fireLocation = (Point2D.Double)this._enemyLocation.clone();
            this._enemyWaves.add(ew);
        }
        _oppEnergy = e.getEnergy();
        this._enemyLocation = AntiRebel.project(this._myLocation, absBearing, e.getDistance());
        this.updateWaves();
        this.doSurfing();
        double bulletPower2 = this.setFireAccordingStats();
        double gunTurn = targetingStrategy.getTargetBearing(this, e, bulletPower2);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnGunRightRadians(gunTurn);
        if (this.getEnergy() > 3.0) {
            this.setFire(bulletPower2);
        } else if (this.getEnergy() > 0.1) {
            this.setFire(0.1);
        }
    }

    public double getAccuracy(Statistic stats) {
        if (stats.bulletHit + stats.bulletMissed == 0.0) {
            return 0.0;
        }
        return stats.bulletHit / (stats.bulletHit + stats.bulletMissed);
    }

    public double setFireAccordingStats() {
        if (this.matchStat.bulletHit > this.matchStat.hitByBullet) {
            return 3.0;
        }
        if (this.getAccuracy(this.matchStat) > 0.7) {
            return 3.0;
        }
        if (this.getEnergy() > 60.0 || this.getEnergy() < 90.0) {
            return 2.0;
        }
        return 3.0;
    }

    public void updateWaves() {
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this._myLocation.distance(ew.fireLocation) + 50.0) {
                this._enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < this._enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
            double distance = this._myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = AntiRebel.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / AntiRebel.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)AntiRebel.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = AntiRebel.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < BINS) {
            int n = x;
            _surfStats[n] = _surfStats[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.matchStat.hitByBullet += 1.0;
        if (!this._enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this._enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this._enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this._myLocation.distance(ew.fireLocation)) < 50.0 && Math.abs(AntiRebel.bulletVelocity(e.getBullet().getPower()) - ew.bulletVelocity) < 0.001) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this._enemyWaves.remove(this._enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this._myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, AntiRebel.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + AntiRebel.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = AntiRebel.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = AntiRebel.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = AntiRebel.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return _surfStats[index];
    }

    public void doSurfing() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = AntiRebel.absoluteBearing(surfWave.fireLocation, this._myLocation);
        goAngle = dangerLeft < dangerRight ? this.wallSmoothing(this._myLocation, goAngle - 1.5707963267948966, -1) : this.wallSmoothing(this._myLocation, goAngle + 1.5707963267948966, 1);
        AntiRebel.setBackAsFront(this, goAngle);
    }

    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(AntiRebel.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.red);
        int i = 0;
        while (i < this._enemyWaves.size()) {
            EnemyWave w = (EnemyWave)this._enemyWaves.get(i);
            int radius = (int)w.distanceTraveled;
            Point2D.Double center = w.fireLocation;
            if ((double)(radius - 40) < center.distance(this._myLocation)) {
                g.drawOval((int)(center.x - (double)radius), (int)(center.y - (double)radius), radius * 2, radius * 2);
            }
            ++i;
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        this.matchStat.bulletHit += 1.0;
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.matchStat.bulletMissed += 1.0;
    }

    public void onRoundEnded(RoundEndedEvent event) {
        this.out.println("The round has ended");
        AntiRebel.globalStats.bulletHit += this.matchStat.bulletHit;
        AntiRebel.globalStats.bulletMissed += this.matchStat.bulletMissed;
        AntiRebel.globalStats.hitByBullet += this.matchStat.hitByBullet;
        AntiRebel.globalStats.bulletFired += this.matchStat.bulletFired;
    }

    public void onBattleEnded(BattleEndedEvent event) {
        this.out.println("Acuracy : " + this.getAccuracy(globalStats));
        this.out.println("BulettFired : " + AntiRebel.globalStats.bulletFired);
    }

    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction;
    }
}

