/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.Garm;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Vector;
import robocode.TeamRobot;

public class DrawingBot
extends TeamRobot {
    public static Vector<Renderable> renderables;

    public DrawingBot() {
        renderables = new Vector();
    }

    protected void step() {
        if (!Garm.DEBUG_GRAFICS) {
            renderables.clear();
        }
    }

    public void onPaint(Graphics2D g) {
        for (Renderable r : renderables) {
            r.render(g);
        }
        renderables.clear();
    }

    public static void drawLine(double x1, double y1, double x2, double y2, Color color) {
        renderables.add(new Renderable.Line(new Point2D.Double(x1, y1), new Point2D.Double(x2, y2), color));
    }

    public static void drawLine(Point2D.Double p1, Point2D.Double p2, Color color) {
        renderables.add(new Renderable.Line(p1, p2, color));
    }

    public static void drawCircle(Point2D.Double center, double radius, Color color) {
        renderables.add(new Renderable.Circle(center, radius, color));
    }

    public static void drawPoint(Point2D.Double p1, Color color) {
        renderables.add(new Renderable.Dot(p1, 3.0, color));
    }

    public static void drawBigPoint(Point2D.Double p1, Color color) {
        renderables.add(new Renderable.Dot(p1, 5.0, color));
    }

    public static void drawText(String text, double x, double y, Color color) {
        renderables.add(new Renderable.Text(text, x, y, color));
    }

    private static abstract class Renderable {
        private Renderable() {
        }

        public abstract void render(Graphics2D var1);

        private static class Circle
        extends Renderable {
            Point2D.Double center;
            double radius;
            Color color;

            public Circle(Point2D.Double center, double radius, Color color) {
                this.center = center;
                this.radius = radius;
                this.color = color;
            }

            public void render(Graphics2D g) {
                g.setColor(this.color);
                g.drawOval((int)Math.round(this.center.x - this.radius), (int)Math.round(this.center.y - this.radius), (int)Math.round(2.0 * this.radius), (int)Math.round(2.0 * this.radius));
            }
        }

        private static class Dot
        extends Renderable {
            Point2D.Double point;
            double radius;
            Color color;

            public Dot(Point2D.Double point, double radius, Color color) {
                this.point = point;
                this.radius = radius;
                this.color = color;
            }

            public void render(Graphics2D g) {
                g.setColor(this.color);
                g.fillOval((int)Math.round(this.point.x - this.radius), (int)Math.round(this.point.y - this.radius), (int)Math.round(2.0 * this.radius), (int)Math.round(2.0 * this.radius));
            }
        }

        private static class Line
        extends Renderable {
            Point2D.Double p1;
            Point2D.Double p2;
            Color color;
            double radius;

            public Line(Point2D.Double p1, Point2D.Double p2, Color color) {
                this.p1 = p1;
                this.p2 = p2;
                this.color = color;
            }

            public void render(Graphics2D g) {
                g.setColor(this.color);
                g.drawLine((int)Math.round(this.p1.x), (int)Math.round(this.p1.y), (int)Math.round(this.p2.x), (int)Math.round(this.p2.y));
            }
        }

        private static class Text
        extends Renderable {
            String text;
            double x;
            double y;
            Color color;
            double radius;

            public Text(String text, double x, double y, Color color) {
                this.text = text;
                this.x = x;
                this.y = y;
                this.color = color;
            }

            public void render(Graphics2D g) {
                g.setColor(this.color);
                g.drawString(this.text, (float)this.x, (float)this.y);
            }
        }
    }
}

