/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.util.HashMap;
import java.util.Map;
import mue.FireSnapshot;
import mue.GunBase;
import mue.Position;
import mue.RobotData;
import mue.Util;
import robocode.AdvancedRobot;

class AntiSurfGun
extends GunBase {
    protected static final int GUESS_BUCKETS = 17;
    protected static final int[] DISTANCE_BUCKETS = new int[]{200, 400, 600};
    protected static final int[] VELOCITY_BUCKETS = new int[]{1, 3, 5, 7};
    protected static final double[] WALL_BUCKETS = new double[]{0.2, 0.5, 0.8, 1.2};
    protected static final double[] REVERSE_WALL_BUCKETS = new double[]{-0.35, -0.8};
    protected static final int CONSTANTSPEED = 0;
    protected static final int ACCELERATION = 1;
    protected static final int DECELERATION = 2;
    protected static final float ROLLING_FACTOR = 0.25f;
    protected static final float VIRTUAL_ROLLING_FACTOR = 0.083333336f;
    protected static Map targetDatas = null;

    public AntiSurfGun(AdvancedRobot advancedRobot) {
        super(advancedRobot, "AntiSurfGun");
        if (targetDatas == null) {
            targetDatas = new HashMap(10);
        }
    }

    protected double getFireAngle(Position position, RobotData robotData, double d, long l) {
        Position position2 = robotData.guessPosition();
        double d2 = Util.direction(position.getX(), position.getY(), position2.getX(), position2.getY());
        TargetData targetData = (TargetData)targetDatas.get(robotData.getName());
        if (targetData == null) {
            return d2;
        }
        double d3 = targetData.getGuessFactor(position.getX(), position.getY(), position2.getX(), position2.getY(), robotData.getVelocity(), robotData.getOrbitDirection(), robotData.getTimeSinceLastAcceleration(), robotData.getTimeSinceLastDeceleration(), d);
        double d4 = Util.distance(position.getX(), position.getY(), position2.getX(), position2.getY());
        d3 *= Math.toDegrees(Math.asin(8.0 * Math.ceil(d4 / (20.0 - 3.0 * d)) / d4));
        if (robotData.getOrbitDirection() == -1) {
            d3 *= -1.0;
        }
        return d2 + d3;
    }

    public void onScanWave(String string, FireSnapshot fireSnapshot, double d, double d2, boolean bl) {
        TargetData targetData;
        double d3 = Util.direction(fireSnapshot.getOriginX(), fireSnapshot.getOriginY(), d, d2);
        double d4 = Math.toDegrees(Math.atan(20.0 / fireSnapshot.getDistance()));
        double d5 = fireSnapshot.getGuessFactor(d3 - d4);
        double d6 = fireSnapshot.getGuessFactor(d3 + d4);
        if (d6 < d5) {
            double d7 = d5;
            d5 = d6;
            d6 = d7;
        }
        if ((targetData = (TargetData)targetDatas.get(string)) == null) {
            targetData = new TargetData(this.getBattleFieldWidth(), this.getBattleFieldHeight());
            targetDatas.put(string, targetData);
        }
        targetData.adapt(fireSnapshot.getOriginX(), fireSnapshot.getOriginY(), fireSnapshot.getTargetX(), fireSnapshot.getTargetY(), fireSnapshot.getVelocity(), fireSnapshot.getOrbitDirection(), fireSnapshot.getTimeSinceLastAcceleration(), fireSnapshot.getTimeSinceLastDeceleration(), fireSnapshot.getPower(), d5, d6, bl);
    }

    protected static final class TargetData {
        private float[][][][][][] guessFactors = new float[DISTANCE_BUCKETS.length + 1][VELOCITY_BUCKETS.length + 1][3][WALL_BUCKETS.length + 1][REVERSE_WALL_BUCKETS.length + 1][35];
        private double battleFieldWidth;
        private double battleFieldHeight;

        public TargetData(double d, double d2) {
            this.battleFieldWidth = d;
            this.battleFieldHeight = d2;
        }

        private boolean isInsideField(double d, double d2) {
            return d >= 18.0 && d <= this.battleFieldWidth - 18.0 && d2 >= 18.0 && d2 <= this.battleFieldHeight - 18.0;
        }

        private float[] getSegment(double d, double d2, double d3, double d4, double d5, int n, int n2, int n3, double d6) {
            double d7;
            double d8;
            int n4 = (int)Math.round(Util.distance(d, d2, d3, d4));
            int n5 = Math.abs((int)Math.round(d5));
            int n6 = Util.findSegmentationIndex(DISTANCE_BUCKETS, n4);
            int n7 = Util.findSegmentationIndex(VELOCITY_BUCKETS, n5);
            int n8 = 0;
            if (n2 < 2 && n2 < n3) {
                n8 = 1;
            }
            if (n3 < 2 && n2 > n3) {
                n8 = 2;
            }
            double d9 = Util.directionRadians(d, d2, d3, d4);
            double d10 = Math.asin(8.0 / (20.0 - 3.0 * d6));
            if (n == -1) {
                d10 *= -1.0;
            }
            int n9 = 0;
            while (n9 < WALL_BUCKETS.length) {
                d8 = d + Math.sin(d9 + d10 * WALL_BUCKETS[n9]) * (double)n4;
                if (!this.isInsideField(d8, d7 = d2 + Math.cos(d9 + d10 * WALL_BUCKETS[n9]) * (double)n4)) break;
                ++n9;
            }
            int n10 = 0;
            while (n10 < REVERSE_WALL_BUCKETS.length) {
                d8 = d + Math.sin(d9 + d10 * REVERSE_WALL_BUCKETS[n10]) * (double)n4;
                if (!this.isInsideField(d8, d7 = d2 + Math.cos(d9 + d10 * REVERSE_WALL_BUCKETS[n10]) * (double)n4)) break;
                ++n10;
            }
            return this.guessFactors[n6][n7][n8][n9][n10];
        }

        public double getGuessFactor(double d, double d2, double d3, double d4, double d5, int n, int n2, int n3, double d6) {
            float[] fArray = this.getSegment(d, d2, d3, d4, d5, n, n2, n3, d6);
            int n4 = 17;
            int n5 = 34;
            while (n5 >= 0) {
                if (fArray[n5] > fArray[n4]) {
                    n4 = n5;
                }
                --n5;
            }
            return (double)(n4 - 17) / 17.0;
        }

        public void adapt(double d, double d2, double d3, double d4, double d5, int n, int n2, int n3, double d6, double d7, double d8, boolean bl) {
            int n4 = Util.confine((int)Math.round(d7 * 17.0 + 17.0), 0, 34);
            int n5 = Util.confine((int)Math.round(d8 * 17.0 + 17.0), 0, 34);
            float[] fArray = this.getSegment(d, d2, d3, d4, d5, n, n2, n3, d6);
            float f = bl ? 0.25f : 0.083333336f;
            int n6 = 0;
            while (n6 <= 34) {
                int n7 = n6++;
                fArray[n7] = fArray[n7] * (1.0f - f);
            }
            if (n4 == n5) {
                int n8 = n4;
                fArray[n8] = fArray[n8] + f;
            } else {
                float f2 = 1.5876f / (float)((n5 - n4) * (n5 - n4));
                float f3 = (float)(n4 + n5) / 2.0f;
                int n9 = n5;
                while (n9 >= n4) {
                    int n10 = n9;
                    fArray[n10] = fArray[n10] + f * (1.0f - f2 * ((float)n9 - f3) * ((float)n9 - f3));
                    --n9;
                }
            }
        }
    }
}

