/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.util.Random;
import mue.MovementBase;
import mue.Position;
import mue.RobotBase;
import mue.RobotData;
import mue.Util;

class EvadeMovement
extends MovementBase {
    private String opponent = null;
    private Random random = new Random();
    private int ticks = 0;
    private boolean ahead = true;
    private Position oldPosition = null;
    private boolean directionChoice = this.random.nextBoolean();

    public EvadeMovement(RobotBase robotBase) {
        super(robotBase);
    }

    public void setOpponent(String string) {
        if (this.opponent != null && !this.opponent.equals(string) || this.opponent == null && string != null) {
            this.reset();
        }
        this.opponent = string;
    }

    public String getOpponent() {
        return this.opponent;
    }

    public void reset() {
        this.ticks = 0;
        this.ahead = true;
        this.oldPosition = null;
        this.directionChoice = this.random.nextBoolean();
    }

    public boolean move() {
        if (this.opponent == null) {
            return false;
        }
        RobotData robotData = this.getKnowledge().getRobotData(this.opponent);
        if (robotData == null) {
            this.opponent = null;
            return false;
        }
        if (this.ticks == 0) {
            double d = this.directionTo(robotData);
            double d2 = this.distanceToWall(d + 110.0);
            double d3 = this.distanceToWall(d - 110.0);
            this.directionChoice = d2 > 170.0 && d3 > 170.0 ? !this.directionChoice : d2 > d3;
            d = this.directionChoice ? (d += 110.0) : (d -= 110.0);
            double d4 = Util.relativeAngle(this.getHeading(), d);
            double d5 = Util.relativeAngle(this.getHeading(), d + 180.0);
            if (Math.abs(d4) < Math.abs(d5)) {
                this.ahead = true;
                this.setTurn(d);
            } else {
                this.ahead = false;
                this.setTurn(d + 180.0);
            }
            this.ticks = 10;
        }
        if (this.oldPosition != null && this.distanceTo(this.oldPosition.getX(), this.oldPosition.getY()) < 0.5) {
            boolean bl = this.ahead = !this.ahead;
        }
        if (this.ahead) {
            this.setAhead(21.0);
        } else {
            this.setBack(21.0);
        }
        this.oldPosition = new Position(this.getX(), this.getY());
        --this.ticks;
        return true;
    }
}

