/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.awt.Color;
import mue.AntiSurfGun;
import mue.BulletData;
import mue.BulletFiredCondition;
import mue.CircularMovement;
import mue.DirectGun;
import mue.EvadeMovement;
import mue.GuessFactorGun;
import mue.Gun;
import mue.GunArray;
import mue.Movement;
import mue.RobotBase;
import mue.RobotData;
import mue.ScanWave;
import mue.StatisticWave;
import mue.Util;
import mue.WaypointMovement;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.WinEvent;

public final class Hyperion
extends RobotBase {
    protected static final double CIRCULAR_DISTANCE = 350.0;
    protected static final double MIN_CIRCULAR_DISTANCE = 180.0;
    protected static final double MIN_WAYPOINT_DISTANCE = 300.0;
    protected static final double MAX_WAYPOINT_DISTANCE = 400.0;
    protected static final double EVADE_DISTANCE = 100.0;
    protected static final double DISTANCE_OFFSET = 20.0;
    protected static final double FULL_POWER_DISTANCE = 150.0;
    protected static final double LOW_ENERGY = 15.0;
    protected static final double VERY_LOW_ENERGY = 7.0;
    protected static final float ROLLING_FACTOR = 0.02f;
    protected static double damage = 0.0;
    protected static double energy = 0.0;
    protected static double enemyDamage = 0.0;
    protected static double enemyEnergy = 0.0;
    protected static int shots = 0;
    protected static int enemyShots = 0;
    protected static double battleScore = 0.0;
    protected static double enemyBattleScore = 0.0;
    protected static int encounteredBullets = 0;
    protected static int undetectedEncounteredBullets = 0;
    protected static long wallHits = 0L;
    protected static int circleRounds = 3;
    protected boolean hitWhileCircling;
    protected DirectGun directGun;
    protected GuessFactorGun guessFactorGun;
    protected AntiSurfGun antiSurfGun;
    protected GunArray gunArray;
    protected Gun gun;
    protected EvadeMovement evadeMovement;
    protected WaypointMovement waypointMovement;
    protected CircularMovement circularMovement;
    protected Movement currentMovement;
    protected StatisticWave wave;
    protected ScanWave scanWave;
    protected double score;
    protected double enemyScore;

    protected void init() {
        super.init();
        Color color = new Color(150, 0, 70);
        Color color2 = new Color(80, 80, 80);
        Color color3 = new Color(200, 200, 200);
        this.setColors(color, color2, color3);
        this.directGun = new DirectGun((AdvancedRobot)this);
        this.guessFactorGun = new GuessFactorGun((AdvancedRobot)this);
        this.antiSurfGun = new AntiSurfGun((AdvancedRobot)this);
        this.gunArray = new GunArray((AdvancedRobot)this, !this.isSilent(), false);
        this.gunArray.addGun(this.guessFactorGun, 1.0f, 0.02f, 0.02f);
        this.gunArray.addGun(this.antiSurfGun, 0.0f, 0.02f, 0.02f);
        this.evadeMovement = new EvadeMovement(this);
        this.waypointMovement = new WaypointMovement(this);
        this.circularMovement = new CircularMovement(this);
        this.circularMovement.setDistance(350.0);
        this.waypointMovement.setMinDistance(300.0);
        this.waypointMovement.setMaxDistance(400.0);
        this.currentMovement = null;
        this.score = 0.0;
        this.enemyScore = 0.0;
        this.addCustomEvent(new BulletFiredCondition(this.getKnowledge(), 0L));
        this.wave = null;
        this.scanWave = null;
        this.hitWhileCircling = circleRounds == 0;
    }

    protected void action() {
        RobotData robotData = null;
        while (true) {
            if (this.getKnowledge().numberOfEnemies() > 0) {
                robotData = this.getKnowledge().getNearestEnemy();
            }
            this.doRadar(robotData);
            this.doMovement(robotData);
            this.gunArray.doGun(robotData);
            this.execute();
        }
    }

    protected void doRadar(RobotData robotData) {
        if (robotData == null || !robotData.isAlive()) {
            this.setTurnRadarLeft(75.0);
        } else {
            double d = Util.direction(this.getX(), this.getY(), robotData.getX(), robotData.getY());
            d = Util.relativeAngle(this.getRadarHeading(), d);
            if (d > 0.0) {
                this.setTurnRadarRight(d + 10.0);
            } else {
                this.setTurnRadarRight(d - 10.0);
            }
        }
    }

    protected void doMovement(RobotData robotData) {
        Movement movement = this.currentMovement;
        this.currentMovement = null;
        if (robotData == null) {
            return;
        }
        if (robotData.getDistance() < 100.0 || movement == this.evadeMovement && robotData.getDistance() < 120.0) {
            this.evadeMovement.setOpponent(robotData.getName());
            this.currentMovement = this.evadeMovement;
        } else if (!this.hitWhileCircling && (robotData.getDistance() > 200.0 || movement == this.circularMovement && robotData.getDistance() > 180.0)) {
            this.circularMovement.setOpponent(robotData.getName());
            this.currentMovement = this.circularMovement;
        } else {
            this.waypointMovement.setOpponent(robotData.getName());
            this.currentMovement = this.waypointMovement;
        }
        if (movement != this.currentMovement) {
            this.currentMovement.reset();
        }
        if (!this.currentMovement.move()) {
            this.println("warning: selected movement not configured correctly!");
            this.currentMovement = null;
        }
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        super.onHitByBullet(hitByBulletEvent);
        if (!this.hitWhileCircling) {
            ++encounteredBullets;
            BulletData bulletData = this.getKnowledge().getBullet(hitByBulletEvent.getBullet(), hitByBulletEvent.getTime());
            if (bulletData == null) {
                ++undetectedEncounteredBullets;
            } else if ((double)(hitByBulletEvent.getTime() - bulletData.getTime()) * bulletData.getSpeed() > 180.0) {
                this.hitWhileCircling = true;
                if (this.circularMovement.isMovingStraightSince(bulletData.getTime())) {
                    --circleRounds;
                }
            }
        }
        double d = hitByBulletEvent.getPower() * 4.0;
        if (hitByBulletEvent.getPower() > 1.0) {
            d += (hitByBulletEvent.getPower() - 1.0) * 2.0;
        }
        this.enemyScore += d;
        enemyDamage += d;
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        super.onBulletHit(bulletHitEvent);
        double d = bulletHitEvent.getBullet().getPower() * 4.0;
        if (bulletHitEvent.getBullet().getPower() > 1.0) {
            d += (bulletHitEvent.getBullet().getPower() - 1.0) * 2.0;
        }
        damage += d;
        this.score += d;
        this.gunArray.onBulletHit(bulletHitEvent.getBullet(), bulletHitEvent.getName());
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        super.onHitRobot(hitRobotEvent);
        if (hitRobotEvent.isMyFault()) {
            this.score += 1.2;
        } else {
            this.enemyScore += 1.2;
        }
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        super.onHitWall(hitWallEvent);
        ++wallHits;
    }

    public void onCustomEvent(CustomEvent customEvent) {
        if (customEvent.getCondition() instanceof BulletFiredCondition) {
            BulletData bulletData = ((BulletFiredCondition)customEvent.getCondition()).getBulletData();
            enemyEnergy += bulletData.getPower();
            ++enemyShots;
        }
    }

    public void onWin(WinEvent winEvent) {
        this.score = this.score * 1.2 + 60.0;
        super.onWin(winEvent);
    }

    public void onDeath(DeathEvent deathEvent) {
        this.enemyScore *= 1.2;
        if (this.getOthers() > 0) {
            this.enemyScore += 60.0;
        }
        super.onDeath(deathEvent);
    }

    protected void onEndOfRound() {
        super.onEndOfRound();
        enemyBattleScore += this.enemyScore;
        battleScore += this.score;
        if (!this.hitWhileCircling) {
            ++circleRounds;
        }
    }

    protected void onEndOfBattle() {
        super.onEndOfBattle();
        double d = 0.0;
        if (energy > 0.0) {
            d = damage / energy;
        }
        this.println("damage ratio: " + d + " (" + Math.round(damage) + " / " + Math.round(energy) + ")");
        d = 0.0;
        if (enemyEnergy > 0.0) {
            d = enemyDamage / enemyEnergy;
        }
        this.println("enemy damage ratio: " + d + " (" + Math.round(enemyDamage) + " / " + Math.round(enemyEnergy) + ")");
        d = 0.0;
        if (shots > 0) {
            d = energy / (double)shots;
        }
        this.println("average fire power: " + d + " (using " + shots + " shots)");
        d = 0.0;
        if (enemyShots > 0) {
            d = enemyEnergy / (double)enemyShots;
        }
        this.println("enemy average fire power: " + d + " (using " + enemyShots + " shots)");
        this.println("");
        this.println(this.gunArray.evaluate());
        d = 0.0;
        if (enemyBattleScore + battleScore > 0.0) {
            d = Math.floor(battleScore * 1000000.0 / (enemyBattleScore + battleScore)) / 10000.0;
        }
        this.println("score: " + d + "% (" + Math.round(battleScore) + " / " + Math.round(enemyBattleScore) + ")");
        this.println("");
        d = 0.0;
        if (encounteredBullets > 0) {
            d = (double)undetectedEncounteredBullets / (double)encounteredBullets;
        }
        this.println("undetected bullets encountered: " + d + " (" + undetectedEncounteredBullets + " / " + encounteredBullets + ")");
        this.println("circle rounds: " + circleRounds);
        this.println("wallHits: " + wallHits);
    }
}

