/*
 * Decompiled with CFR 0.152.
 */
package sqTank.libsvm;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import robocode.RobocodeFileOutputStream;
import robocode.TeamRobot;
import sqTank.libsvm.Point;
import sqTank.libsvm.svm;
import sqTank.libsvm.svm_model;
import sqTank.libsvm.svm_node;
import sqTank.libsvm.svm_parameter;
import sqTank.libsvm.svm_problem;

public class SVMHelper {
    public static ArrayList point_list = new ArrayList(2000);
    byte current_value = 1;
    public TeamRobot bot;
    public static String args = "-t 2 -c 100 -s 3 -p 0.01 -g 100";
    public static svm_model[] models;
    public static svm_parameter param;
    public int xSize;
    public int ySize;
    public int trainSize;
    public boolean loadModel = false;
    public boolean loadFail = false;
    boolean flag = false;

    public SVMHelper() {
        this.xSize = 83;
        this.ySize = 2;
        this.init();
    }

    public SVMHelper(int xSize, int ySize, TeamRobot robot) {
        this.xSize = xSize;
        this.ySize = ySize;
        this.bot = robot;
        this.init();
    }

    public void init() {
        Point.xSize = this.xSize;
        Point.ySize = this.ySize;
        models = new svm_model[this.ySize];
        param = new svm_parameter();
        SVMHelper.param.svm_type = 0;
        SVMHelper.param.kernel_type = 2;
        SVMHelper.param.degree = 3;
        SVMHelper.param.gamma = 0.0;
        SVMHelper.param.coef0 = 0.0;
        SVMHelper.param.nu = 0.5;
        SVMHelper.param.cache_size = 400.0;
        SVMHelper.param.C = 1.0;
        SVMHelper.param.eps = 0.001;
        SVMHelper.param.p = 0.1;
        SVMHelper.param.shrinking = 1;
        SVMHelper.param.probability = 0;
        SVMHelper.param.nr_weight = 0;
        SVMHelper.param.weight_label = new int[0];
        SVMHelper.param.weight = new double[0];
        StringTokenizer st = new StringTokenizer(args);
        String[] argv = new String[st.countTokens()];
        int i = 0;
        while (i < argv.length) {
            argv[i] = st.nextToken();
            ++i;
        }
        i = 0;
        while (i < argv.length) {
            if (argv[i].charAt(0) != '-') break;
            if (++i >= argv.length) {
                System.err.print("unknown option\n");
                break;
            }
            switch (argv[i - 1].charAt(1)) {
                case 's': {
                    SVMHelper.param.svm_type = SVMHelper.atoi(argv[i]);
                    break;
                }
                case 't': {
                    SVMHelper.param.kernel_type = SVMHelper.atoi(argv[i]);
                    break;
                }
                case 'd': {
                    SVMHelper.param.degree = SVMHelper.atoi(argv[i]);
                    break;
                }
                case 'g': {
                    SVMHelper.param.gamma = SVMHelper.atof(argv[i]);
                    break;
                }
                case 'r': {
                    SVMHelper.param.coef0 = SVMHelper.atof(argv[i]);
                    break;
                }
                case 'n': {
                    SVMHelper.param.nu = SVMHelper.atof(argv[i]);
                    break;
                }
                case 'm': {
                    SVMHelper.param.cache_size = SVMHelper.atof(argv[i]);
                    break;
                }
                case 'c': {
                    SVMHelper.param.C = SVMHelper.atof(argv[i]);
                    break;
                }
                case 'e': {
                    SVMHelper.param.eps = SVMHelper.atof(argv[i]);
                    break;
                }
                case 'p': {
                    SVMHelper.param.p = SVMHelper.atof(argv[i]);
                    break;
                }
                case 'h': {
                    SVMHelper.param.shrinking = SVMHelper.atoi(argv[i]);
                    break;
                }
                case 'b': {
                    SVMHelper.param.probability = SVMHelper.atoi(argv[i]);
                    break;
                }
                case 'w': {
                    ++SVMHelper.param.nr_weight;
                    Object[] old = SVMHelper.param.weight_label;
                    SVMHelper.param.weight_label = new int[SVMHelper.param.nr_weight];
                    System.arraycopy(old, 0, SVMHelper.param.weight_label, 0, SVMHelper.param.nr_weight - 1);
                    old = SVMHelper.param.weight;
                    SVMHelper.param.weight = new double[SVMHelper.param.nr_weight];
                    System.arraycopy(old, 0, SVMHelper.param.weight, 0, SVMHelper.param.nr_weight - 1);
                    SVMHelper.param.weight_label[SVMHelper.param.nr_weight - 1] = SVMHelper.atoi(argv[i - 1].substring(2));
                    SVMHelper.param.weight[SVMHelper.param.nr_weight - 1] = SVMHelper.atof(argv[i]);
                    break;
                }
                default: {
                    System.err.print("unknown option\n");
                }
            }
            ++i;
        }
        if (SVMHelper.param.kernel_type != 4 && (SVMHelper.param.svm_type == 3 || SVMHelper.param.svm_type == 4) && SVMHelper.param.gamma == 0.0) {
            SVMHelper.param.gamma = 1.0;
        }
    }

    public void train(double[] input, double[] output) {
        Point point = new Point(input, output);
        point_list.add(point);
        this.train();
    }

    public void train() {
        if (point_list.size() < 20) {
            return;
        }
        int i = 0;
        while (i < this.ySize) {
            this.train(i);
            ++i;
        }
    }

    private void train(int pth) {
        svm_problem prob = new svm_problem();
        prob.l = point_list.size();
        prob.y = new double[prob.l];
        prob.x = new svm_node[prob.l][this.xSize];
        int i = 0;
        while (i < prob.l) {
            Point p = (Point)point_list.get(i);
            int j = 0;
            while (j < this.xSize) {
                prob.x[i][j] = new svm_node();
                prob.x[i][j].index = j;
                prob.x[i][j].value = p.x[j];
                ++j;
            }
            prob.y[i] = p.y[pth];
            ++i;
        }
        SVMHelper.models[pth] = svm.svm_train(prob, param);
    }

    public double[] getOutput(double[] input) {
        double[] retval = new double[this.ySize];
        int i = 0;
        while (i < this.ySize) {
            retval[i] = this.getOutput(input, i);
            ++i;
        }
        return retval;
    }

    private double getOutput(double[] input, int pth) {
        return this.predict(input, pth);
    }

    private double predict(double[] input, int pth) {
        if (!this.loadModel) {
            return 0.0;
        }
        double retval = 0.0;
        svm_node[] x = new svm_node[input.length];
        int i = 0;
        while (i < x.length) {
            x[i] = new svm_node();
            x[i].index = i;
            x[i].value = input[i];
            ++i;
        }
        if (models[pth] == null) {
            System.out.println(String.valueOf(pth) + "is null");
        }
        retval = svm.svm_predict(models[pth], x);
        return retval;
    }

    private static double atof(String s) {
        return Double.valueOf(s);
    }

    private static int atoi(String s) {
        return Integer.parseInt(s);
    }

    public void addPointListWithOutScale(double[] input, double[] output) {
        Point point = new Point(input, output);
        point_list.add(point);
    }

    public void addPointList(double[] input, double[] output) {
        input[1] = input[1] * 10.0;
        Point point = new Point(input, output);
        point_list.add(point);
    }

    private void small(int size) {
        ArrayList retList = new ArrayList();
        int i = point_list.size() - 1;
        while (i >= point_list.size() - size) {
            retList.add(point_list.get(i));
            --i;
        }
        point_list = retList;
    }

    public void saveSVMModel(String enemyName) {
        try {
            if (point_list.size() > 500) {
                System.out.println("We have big train Set hahah \n\n\n haha ");
                this.small(500);
            }
            if (point_list.size() < 20) {
                System.out.println("point_list size too small must bigger than 10 ");
                return;
            }
            System.out.println("*************************************************************** save Model ");
            this.train();
            String fileName = String.valueOf(enemyName) + ".model.zip";
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)new RobocodeFileOutputStream(this.bot.getDataFile(fileName)));
            oos.writeObject(models);
            oos.close();
            System.out.print("******************************************************");
            System.out.print("******************************************************");
            System.out.print("******************************************************");
            System.out.print("******************************************************");
            System.out.print("******************************************************");
            System.out.print("******************************************************");
            System.out.println("save");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSVMModel(String enemyName) {
        try {
            if (this.loadFail) {
                return;
            }
            if (this.loadModel) {
                return;
            }
            String fileName = String.valueOf(enemyName) + ".model.zip";
            ObjectInputStream oos = new ObjectInputStream(new FileInputStream(this.bot.getDataFile(fileName)));
            models = (svm_model[])oos.readObject();
            oos.close();
            this.loadModel = true;
            this.loadFail = false;
            System.out.println("**************************************************** loadModel  " + fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
            point_list = new ArrayList();
            this.loadModel = false;
            this.loadFail = true;
        }
    }

    public void savePointList(String enemyName) {
        try {
            String fileName = String.valueOf(enemyName) + ".point_list_obj.zip";
            System.out.println("************************************** point_list.size()  " + point_list.size());
            ZipOutputStream zipoutputstream = new ZipOutputStream((OutputStream)new RobocodeFileOutputStream(this.bot.getDataFile(fileName)));
            zipoutputstream.setLevel(9);
            zipoutputstream.putNextEntry(new ZipEntry("point_list_obj"));
            ObjectOutputStream oos = new ObjectOutputStream(zipoutputstream);
            oos.writeObject(point_list);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadPointList(String enemyName) {
        try {
            if (this.flag) {
                return;
            }
            String fileName = String.valueOf(enemyName) + ".point_list_obj.zip";
            ZipInputStream is = new ZipInputStream(new FileInputStream(this.bot.getDataFile(fileName)));
            is.getNextEntry();
            ObjectInputStream oos = new ObjectInputStream(is);
            point_list = (ArrayList)oos.readObject();
            oos.close();
            this.flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            point_list = new ArrayList();
        }
    }
}

