/*
 * Decompiled with CFR 0.152.
 */
package cbot.agile.gun;

import cbot.agile.CU;
import cbot.agile.Nibbler;
import cbot.agile.Point;
import cbot.agile.Pray;
import cbot.agile.gun.GunStrategy;
import cbot.agile.gun.Pattern;

public class PatternMatcherGunStrategy
extends GunStrategy {
    public double getBulletAngel(Nibbler robot, Pray pray, double firePower) {
        Pattern track = pray.getPattern();
        Point roboCord = robot.getCordinate();
        Point prayCord = pray.getCordinate();
        double orgAngle = roboCord.getAngle(prayCord);
        double heading = pray.getHeading();
        double bulletVelocity = CU.getBulletVelocity(firePower);
        int index = track.getMatch();
        if (index < 1) {
            return 0.0;
        }
        long totTime = 0L;
        while (index < track.size() - 1) {
            long l;
            double BTTime = pray.getDistance() / bulletVelocity;
            ++totTime;
            if (BTTime - (double)l < 0.5) break;
            double distance = track.getVelocity(index);
            heading = CU.normalRelativeAngle(heading + track.getHeadingDelta(index));
            ++index;
            prayCord.move(distance, Math.toRadians(heading));
        }
        return roboCord.getAngle(Point.putPointInValidArea(prayCord)) - orgAngle;
    }

    public boolean match(Pray pray) {
        return pray.getPattern().ready();
    }

    public String getGunSign() {
        return "~";
    }

    public PatternMatcherGunStrategy(Nibbler robot) {
        super(robot);
    }
}

