/*
 * Decompiled with CFR 0.152.
 */
package xander.core.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import robocode.AdvancedRobot;
import robocode.RobocodeFileOutputStream;
import robocode.RobocodeFileWriter;
import xander.core.Configuration;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.io.BattleStats;
import xander.core.log.Log;
import xander.core.log.Logger;

public class FileIO {
    private static final Log log = Logger.getLog(FileIO.class);
    private static final String BATTLE_STATS_SUFFIX = "_BattleStats";
    private static final String BATTLE_STATS_EXT = ".dat";
    private static BattleStats battleStats;

    private static String getFileName(String fileNameSuffix, String extension) {
        RobotProxy robotProxy = Resources.getRobotProxy();
        String fileName = String.valueOf(robotProxy.getName().split(" ")[0]) + fileNameSuffix;
        if (extension != null && extension.length() > 0) {
            fileName = extension.startsWith(".") ? String.valueOf(fileName) + extension : String.valueOf(fileName) + "." + extension;
        }
        return fileName;
    }

    public static BattleStats getBattleStats(Configuration configuration) {
        if (battleStats == null) {
            FileIO.loadBattleStats(configuration);
        }
        return battleStats;
    }

    public static void loadBattleStats(Configuration configuration) {
        block19: {
            String battleStatsFileName = FileIO.getFileName(BATTLE_STATS_SUFFIX, BATTLE_STATS_EXT);
            String battleStatsZipFileName = FileIO.getFileName(BATTLE_STATS_SUFFIX, ".zip");
            File battleStatsFile = Resources.getRobotProxy().getDataFile(battleStatsFileName);
            if (battleStatsFile.exists()) {
                battleStatsFile.delete();
            }
            File battleStatsZipFile = Resources.getRobotProxy().getDataFile(battleStatsZipFileName);
            ObjectInput oi = null;
            if (battleStatsZipFile.exists()) {
                try {
                    try {
                        ZipInputStream zis = new ZipInputStream(new FileInputStream(battleStatsZipFile));
                        zis.getNextEntry();
                        oi = new ObjectInputStream(zis);
                        battleStats = (BattleStats)oi.readObject();
                        oi.close();
                    }
                    catch (Exception e) {
                        log.error("Unable to load existing battle stats.  Creating new battle stats.");
                        battleStats = new BattleStats();
                        if (oi != null) {
                            try {
                                oi.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (oi != null) {
                        try {
                            oi.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (oi != null) {
                    try {
                        oi.close();
                    }
                    catch (Exception exception) {}
                }
            } else {
                battleStats = new BattleStats();
            }
        }
        String robotName = Resources.getRobotProxy().getName();
        if (battleStats != null && !robotName.equals(FileIO.battleStats.robotName)) {
            boolean clearBattleStatsOnNewVersion = configuration.isClearBattleStatsOnNewVersion();
            battleStats.setClearStatsOnNewVersion(clearBattleStatsOnNewVersion);
            if (clearBattleStatsOnNewVersion) {
                battleStats.clear();
            }
            FileIO.battleStats.robotName = robotName;
        }
    }

    public static void saveBattleStats() {
        block13: {
            if (battleStats == null) {
                return;
            }
            String battleStatsFileName = FileIO.getFileName(BATTLE_STATS_SUFFIX, BATTLE_STATS_EXT);
            String battleStatsZipFileName = FileIO.getFileName(BATTLE_STATS_SUFFIX, ".zip");
            File battleStatsZipFile = Resources.getRobotProxy().getDataFile(battleStatsZipFileName);
            ObjectOutput oo = null;
            try {
                try {
                    ZipOutputStream zos = new ZipOutputStream((OutputStream)new RobocodeFileOutputStream(battleStatsZipFile));
                    zos.putNextEntry(new ZipEntry(battleStatsFileName));
                    oo = new ObjectOutputStream(zos);
                    oo.writeObject(battleStats);
                }
                catch (Exception e) {
                    log.error("Unable to save battle stats.");
                    if (oo == null) break block13;
                    try {
                        oo.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (oo != null) {
                    try {
                        oo.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static void logException(AdvancedRobot robot, Exception e) {
        block5: {
            String fileName = String.valueOf(robot.getName().split(" ")[0]) + "_Exception.txt";
            File exceptionFile = robot.getDataFile(fileName);
            log.error("Fatal exception occurred.");
            log.error("Writing stack trace to " + exceptionFile.getAbsolutePath());
            RobocodeFileWriter writer = null;
            try {
                writer = new RobocodeFileWriter(exceptionFile);
                String s = String.valueOf(e.getClass().getName()) + ": " + e.getMessage() + "\n";
                writer.write(s);
                log.error(s);
                StackTraceElement[] stackTraceElementArray = e.getStackTrace();
                int n = stackTraceElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement ste = stackTraceElementArray[n2];
                    s = String.valueOf(ste.toString()) + "\n";
                    writer.write(s);
                    log.error(s);
                    ++n2;
                }
                writer.close();
            }
            catch (IOException ioe) {
                if (writer == null) break block5;
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void logSkippedTurns(AdvancedRobot robot, int skippedTurns) {
        block5: {
            if (skippedTurns > 0) {
                String fileName = String.valueOf(robot.getName().split(" ")[0]) + "_SkippedTurns.txt";
                File exceptionFile = robot.getDataFile(fileName);
                log.warn(String.valueOf(skippedTurns) + " turns skipped.");
                RobocodeFileWriter writer = null;
                try {
                    writer = new RobocodeFileWriter(exceptionFile);
                    String s = "Turns skipped for " + robot.getName() + ": " + skippedTurns + "\n";
                    writer.write(s);
                    writer.close();
                }
                catch (IOException ioe) {
                    if (writer == null) break block5;
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

