/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.processor;

import java.awt.geom.Point2D;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.event.MyWaveListener;
import xander.core.event.OpponentWaveListener;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.core.track.WaveHistory;
import xander.core.track.XBulletWave;
import xander.gfws.processor.FactorArrayProcessor;

public abstract class AbstractFactorArrayProcessor
implements FactorArrayProcessor,
MyWaveListener,
OpponentWaveListener {
    protected boolean offensive;
    protected RobotProxy robotProxy;

    public AbstractFactorArrayProcessor(boolean offensive) {
        this.offensive = offensive;
        this.robotProxy = Resources.getRobotProxy();
        WaveHistory waveHistory = Resources.getWaveHistory();
        if (offensive) {
            waveHistory.addMyWaveListener(this);
        } else {
            waveHistory.addOpponentWaveListener(this);
        }
    }

    protected abstract void process(Wave var1, double var2, double var4);

    protected abstract void processVisit(Wave var1, double var2, double var4);

    @Override
    public void oppWaveCreated(Wave wave) {
    }

    @Override
    public void oppWaveHitBullet(Wave wave, Bullet oppBullet) {
        if (!this.offensive) {
            double hitAngle = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), oppBullet.getX(), oppBullet.getY());
            double hitDistance = RCMath.getDistanceBetweenPoints(wave.getOriginX(), wave.getOriginY(), this.robotProxy.getX(), this.robotProxy.getY());
            Point2D.Double hitLocation = RCMath.getLocation(wave.getOriginX(), wave.getOriginY(), hitDistance, hitAngle);
            this.process(wave, hitLocation.x, hitLocation.y);
        }
    }

    @Override
    public void oppWaveHit(Wave wave) {
        if (!this.offensive) {
            this.processVisit(wave, this.robotProxy.getX(), this.robotProxy.getY());
        }
    }

    @Override
    public void oppNextWaveToHit(Wave wave) {
    }

    @Override
    public void oppBulletHit(Wave wave, HitByBulletEvent hitByBulletEvent) {
        if (!this.offensive) {
            this.process(wave, this.robotProxy.getX(), this.robotProxy.getY());
        }
    }

    @Override
    public void oppWavePassing(Wave wave) {
    }

    @Override
    public void oppWavePassed(Wave wave) {
    }

    @Override
    public void oppWaveUpdated(Wave wave) {
    }

    @Override
    public void oppWaveDestroyed(Wave wave) {
    }

    @Override
    public void myWaveCreated(XBulletWave wave) {
    }

    @Override
    public void myWaveHitBullet(XBulletWave wave, Bullet myBullet) {
    }

    @Override
    public void myWaveHit(XBulletWave wave, Snapshot opponentSnapshot) {
        if (this.offensive) {
            this.process(wave, opponentSnapshot.getX(), opponentSnapshot.getY());
        }
    }

    @Override
    public void myBulletHit(XBulletWave wave, BulletHitEvent bulletHitEvent) {
    }

    @Override
    public void myWavePassing(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWavePassed(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWaveDestroyed(XBulletWave wave) {
    }
}

