/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import pa3k.BulletTracking;
import pa3k.Change;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.RobotModule;
import pa3k.SelfTracking;
import pa3k.Simulation;
import pa3k.State;
import pa3k.StateMomentumDirectionKeep;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.KeyEvent;
import robocode.Robot;
import robocode.Rules;

public class MonteCarlo
extends RobotModule {
    protected Tracking tracking;
    protected Opponent target;
    protected SelfTracking selfTracking;
    protected static State[] states = null;
    protected static long samples = 0L;
    protected State currentState;
    protected double lastVelocity;
    protected List<Simulation> simulations;

    public MonteCarlo(AdvancedRobot advancedRobot, Tracking tracking, SelfTracking selfTracking) {
        super(advancedRobot);
        this.selfTracking = selfTracking;
        this.tracking = tracking;
        this.lastVelocity = 0.0;
        if (states == null) {
            int n;
            states = new State[16];
            for (n = 0; n < 8; ++n) {
                MonteCarlo.states[n] = new StateMomentumDirectionKeep(n, false);
            }
            for (n = 1; n <= 8; ++n) {
                MonteCarlo.states[7 + n] = new StateMomentumDirectionKeep(n, true);
            }
        }
        this.currentState = states[0];
        this.simulations = new LinkedList<Simulation>();
    }

    @Override
    public void turn() {
        this.target = this.tracking.getLastHitBy();
        long l = this.robot.getTime();
        BulletTracking bulletTracking = null;
        if (this.target != null && this.tracking.getOwnBullets().size() > 0) {
            bulletTracking = this.tracking.getOwnBullets().getFirst();
        }
        if (this.target != null && l > 5L && (l < 40L || bulletTracking != null && bulletTracking.getETA(this.target.getLastPosition()) <= l)) {
            boolean bl;
            block13: {
                bl = false;
                try {
                    double d = this.target.getLastVelocity();
                    boolean bl2 = bl = this.lastVelocity > 0.0 && d < 0.0 || this.lastVelocity < 0.0 && d > 0.0;
                    if (d != 0.0) {
                        this.lastVelocity = d;
                    }
                    long l2 = this.target.getLastSpeedChange(l - 1L);
                    long l3 = 0L;
                    long l4 = 0L;
                    double d2 = 0.0;
                    Object object = new Position(this.target.getLastPosition());
                    ((Position)object).modify(1L, 140 * (this.target.getLastVelocity() > 0.0 ? 1 : -1), this.target.getLastHeading());
                    boolean bl3 = !((Position)object).isInBattlefield();
                    object = this.currentState.amIStillHere(this.robot, this.selfTracking, this.target, l, states, bl, l2, bl3, l4, l3, d2);
                    ++samples;
                    if (object != null) {
                        if (!((Change)object).checkConsitency(this.currentState)) {
                            Log.log(2, "Inconsistent change: " + object);
                            this.currentState.deleteChange((Change)object);
                        }
                        this.currentState = ((Change)object).getTargetState();
                        ((Change)object).increaseLikelihood();
                    } else {
                        assert (false);
                        this.currentState.increaseNoChangeLikelihood(l2, bl3, l4, l3, d2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError();
                }
            }
            Position position = new Position((Robot)this.robot);
            Iterator<Simulation> iterator = this.simulations.iterator();
            while (iterator.hasNext()) {
                Simulation simulation = iterator.next();
                if (!simulation.isStillValid(l, this.currentState, bl)) {
                    iterator.remove();
                    continue;
                }
                Position position2 = simulation.expectedPosition(states, l, Rules.getBulletSpeed((double)1.8), position, this.target);
            }
            int n = this.simulations.size();
            for (int i = 0; n < 15 && i < 5; ++n, ++i) {
                Simulation simulation = new Simulation(states, this.currentState, l, Rules.getBulletSpeed((double)1.8), position, this.target);
                this.simulations.add(simulation);
            }
            if (l % 20L == 0L) {
                this.dumpData();
            }
        }
    }

    public Position[] simulatePosition(double d, Position position) {
        Position[] positionArray = new Position[this.simulations.size()];
        long l = this.robot.getTime();
        Iterator<Simulation> iterator = this.simulations.iterator();
        for (int i = 0; i < positionArray.length; ++i) {
            positionArray[i] = iterator.next().expectedPosition(states, l + 1L, d, position, this.target);
        }
        return positionArray;
    }

    @Override
    public void init() {
    }

    public void dumpData() {
        for (State state : states) {
            Log.log(4, state + ":");
            Log.log(4, "  stay: " + state.getLikelihood());
            state.dumpChanges();
        }
    }

    public void onOkey(KeyEvent keyEvent) {
        this.dumpData();
    }

    public long getSamples() {
        return samples;
    }
}

