/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import java.awt.Graphics2D;
import pa3k.AngleUtils;
import pa3k.BulletTracking;
import pa3k.Log;
import pa3k.Position;
import pa3k.RobotModule;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.Robot;
import robocode.util.Utils;

public class Moving
extends RobotModule {
    public final int MAX_WALL_DISTANCE = 22;
    public final int BLIND_STICK = 150;
    protected int direction = 1;
    protected double newHeading = 0.0;
    protected Tracking tracking;
    protected Position hideout = null;
    protected BulletTracking wave = null;
    protected Position generalPosition = null;
    protected double diveAllowance;
    protected int lastDirectionChange;

    public Moving(AdvancedRobot advancedRobot, Tracking tracking) {
        super(advancedRobot);
        this.tracking = tracking;
        this.diveAllowance = 1.3744467859455345;
        this.lastDirectionChange = 0;
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        this.changeDirection();
    }

    @Override
    public void init() {
        this.generalPosition = new Position(this.robot.getBattleFieldWidth() / 2.0, this.robot.getBattleFieldHeight() / 2.0);
    }

    @Override
    public void turn() {
        double d;
        Position position = new Position((Robot)this.robot);
        long l = this.robot.getTime();
        double d2 = 0.0;
        if (this.lastDirectionChange > 0) {
            --this.lastDirectionChange;
        }
        if (this.wave != null && l > this.wave.getETA(position) - 1L) {
            this.wave.setEvaded();
            this.wave = null;
            this.hideout = null;
            this.newHeading = this.direction == 1 ? this.robot.getHeadingRadians() : Utils.normalAbsoluteAngle((double)(this.robot.getHeadingRadians() + Math.PI));
        }
        if (this.hideout == null) {
            if (this.generalPosition != null) {
                Log.log(4, "Following general direction");
                this.newHeading = position.getDirectionTo(this.generalPosition);
                d2 = position.distance(this.generalPosition) * (double)this.direction;
            } else {
                Log.log(4, "Not going anywhere");
                d2 = 20 * this.direction;
                this.newHeading = this.robot.getHeadingRadians();
                if (this.direction == -1) {
                    this.newHeading = Utils.normalAbsoluteAngle((double)(this.newHeading + Math.PI));
                }
            }
        } else {
            this.newHeading = position.getDirectionTo(this.hideout);
            d2 = position.distance(this.hideout) * (double)this.direction;
        }
        double d3 = 0.0;
        int n = 3;
        int n2 = 1;
        while (n > 0) {
            double d4;
            --n;
            Log.log(4, "loop start heading " + this.newHeading);
            Position position2 = new Position(position);
            position2.modify(1L, 80.0, this.newHeading);
            boolean bl = position2.adjustForWalls(position, n2, null, 0.0, this.newHeading);
            n2 = -1;
            this.newHeading = position.getDirectionTo(position2);
            if (bl) {
                Log.log(4, "Wall corrected heading: " + this.newHeading);
            }
            double d5 = this.robot.getHeadingRadians();
            if (this.direction == -1) {
                d5 = Utils.normalAbsoluteAngle((double)(d5 + Math.PI));
            }
            if (Math.abs(d3 = Utils.normalRelativeAngle((double)(this.newHeading - d5))) > 1.5707963267948966) {
                Log.log(4, "New heading requires direction change");
                this.changeDirection();
                continue;
            }
            if (this.tracking.getLastHitBy() == null || n < 2) break;
            double d6 = AngleUtils.difference(this.newHeading, position.getDirectionTo(this.tracking.getLastHitBy().getLastPosition()));
            double d7 = 9.0 * this.diveAllowance / 10.0;
            if (d6 > 0.0 && d6 < d7) {
                Log.log(4, "Positive dive protection violated: " + d6);
                if (bl) {
                    Log.log(4, "  also wall hit, changing dir");
                    this.changeDirection();
                    continue;
                }
                d4 = this.newHeading;
                this.newHeading = Utils.normalAbsoluteAngle((double)(this.newHeading + this.diveAllowance - d6));
                Log.paintArc(3, position, d4, Utils.normalRelativeAngle((double)(this.newHeading - d4)), 100.0, new Color(255, 255, 255, 60), 0);
                continue;
            }
            if (d6 < 0.0 && d6 > -d7) {
                Log.log(4, "Positive dive protection violated: " + d6);
                if (bl) {
                    Log.log(4, "  also wall hit, changing dir");
                    this.changeDirection();
                    continue;
                }
                d4 = this.newHeading;
                this.newHeading = Utils.normalAbsoluteAngle((double)(this.newHeading + this.diveAllowance + d6));
                Log.paintArc(3, position, d4, Utils.normalRelativeAngle((double)(this.newHeading - d4)), 100.0, new Color(255, 255, 255, 60), 0);
                continue;
            }
            if (d6 < -(Math.PI - d7)) {
                Log.log(4, "Negative dive protection violated: " + d6);
                if (bl) {
                    Log.log(4, "  also wall hit, changing dir");
                    this.changeDirection();
                    continue;
                }
                d4 = this.newHeading;
                this.newHeading = Utils.normalAbsoluteAngle((double)(this.newHeading - d6 - (Math.PI - this.diveAllowance)));
                Log.paintArc(3, position, d4, Utils.normalRelativeAngle((double)(this.newHeading - d4)), 100.0, new Color(255, 255, 255, 60), 0);
                continue;
            }
            if (!(d6 > Math.PI - d7)) break;
            Log.log(4, "Negative dive protection violated: " + d6);
            if (bl) {
                Log.log(4, "  also wall hit, changing dir");
                this.changeDirection();
                continue;
            }
            d4 = this.newHeading;
            this.newHeading = Utils.normalAbsoluteAngle((double)(this.newHeading - d6 + (Math.PI - this.diveAllowance)));
            Log.paintArc(3, position, d4, Utils.normalRelativeAngle((double)(this.newHeading - d4)), 100.0, new Color(255, 255, 255, 60), 0);
        }
        if (d3 > (d = 0.17453292519943295 - 0.006544984694978735 * Math.abs(this.robot.getVelocity()))) {
            d3 = d;
        } else if (d3 < -d) {
            d3 = -d;
        }
        this.robot.setTurnRightRadians(d3);
        this.robot.setAhead(d2);
    }

    private void changeDirection() {
        Log.log(4, "Changing direction");
        this.direction *= -1;
        this.newHeading = Utils.normalAbsoluteAngle((double)(this.newHeading + 1.5707963267948966));
        this.lastDirectionChange = 25;
    }

    @Override
    public void onPaint(Graphics2D graphics2D) {
        if (this.hideout != null) {
            Log.paintPoint(1, this.hideout, Color.YELLOW);
        }
    }

    public void bulletHitMe(BulletTracking bulletTracking) {
        if (bulletTracking == this.wave) {
            this.wave = null;
            this.hideout = null;
        }
    }

    public double timeToPosition(Position position) {
        Position position2 = new Position((Robot)this.robot);
        double d = 0.0;
        double d2 = this.robot.getHeadingRadians();
        double d3 = this.robot.getVelocity();
        double d4 = position2.getDirectionTo(position);
        boolean bl = false;
        double d5 = Math.abs(Utils.normalRelativeAngle((double)(d2 - d4)));
        if (d5 > 1.5707963267948966 && d3 > 0.0) {
            bl = true;
        }
        if (d5 < 1.5707963267948966 && d3 < 0.0) {
            bl = true;
        }
        double d6 = 0.0;
        if (bl) {
            d6 = Math.abs(d3) / 2.0;
            d += d6 * Math.abs(d3) / 2.0;
            d3 = 0.0;
        }
        double d7 = (8.0 - Math.abs(d3)) / 1.0;
        return (long)((position2.distance(position) + (d -= d7 * (8.0 - Math.abs(d3)) / 2.0)) / 8.0 + d7 + d6);
    }
}

