/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import pa3k.Aiming;
import pa3k.BulletTracking;
import pa3k.Log;
import pa3k.OpponentBulletReaction;
import pa3k.OpponentDataStorage;
import pa3k.Position;
import pa3k.ScoreKeeper;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Opponent {
    protected String name;
    protected double[] lastHeading;
    protected double[] lastVelocity;
    protected Position[] lastPosition;
    protected long[] lastTime;
    protected int lastIndex;
    public static final int HISTORY = 40;
    protected int lastEnergyIndex;
    protected double lastEnergy;
    protected double[] lastEnergyDrop;
    protected long[] lastEnergyDropTime;
    protected Aiming selfAiming;
    protected Aiming opponentAiming;
    protected double solicitedEnergyLost;
    protected boolean dead;
    protected int lastDirection;
    protected double lastBulletEnergy;
    protected long lastBulletTime;
    protected OpponentBulletReaction bulletReaction;
    protected BulletTracking lastBulletFiredAt;
    protected BulletTracking lastBulletFiredAt2;
    protected BulletTracking lastBulletFiredAtConsidered;
    protected ScoreKeeper outgoingSK;
    protected ScoreKeeper incomingSK;

    public void giveSolicitedEnergyLost(double d) {
        this.solicitedEnergyLost += d;
    }

    public Opponent(String string, AdvancedRobot advancedRobot, Aiming aiming, Aiming aiming2) {
        this.name = string;
        this.lastIndex = 0;
        this.lastEnergyIndex = 0;
        this.lastHeading = new double[40];
        this.lastVelocity = new double[40];
        this.lastPosition = new Position[40];
        this.lastTime = new long[40];
        this.lastEnergy = 100.0;
        this.lastEnergyDrop = new double[40];
        this.lastEnergyDropTime = new long[40];
        this.lastBulletEnergy = 0.0;
        this.lastBulletTime = 0L;
        for (int i = 0; i < this.lastPosition.length; ++i) {
            this.lastPosition[i] = new Position();
        }
        this.lastTime[0] = 0L;
        this.solicitedEnergyLost = 0.0;
        this.selfAiming = aiming;
        this.opponentAiming = aiming2;
        this.lastDirection = 1;
        this.dead = false;
        this.bulletReaction = OpponentDataStorage.getBulletsReaction(string);
        this.lastBulletFiredAt = null;
        this.lastBulletFiredAt2 = null;
        this.lastBulletFiredAtConsidered = null;
        this.outgoingSK = new ScoreKeeper(string, true);
        this.incomingSK = new ScoreKeeper(string, false);
    }

    public double getSuggestedEnergy(double d, double d2) {
        if (d < 100.0) {
            return 3.0;
        }
        if (this.outgoingSK.getPoints(d) < 15) {
            return 2.0;
        }
        double d3 = this.outgoingSK.getKellyCriterion(d);
        if (d3 < 0.0) {
            return 0.1;
        }
        double d4 = (d2 - 0.1) * d3;
        if (d4 > 3.0) {
            d4 = 3.0;
        }
        if (d4 < 0.1) {
            d4 = 0.1;
        }
        return d4;
    }

    public double getSuggestedDistance() {
        if (this.outgoingSK.getPoints() < 10 || this.incomingSK.getPoints() < 10) {
            return Double.NaN;
        }
        return this.outgoingSK.getBestDistance(this.incomingSK);
    }

    public int getScanPriority(long l) {
        if (this.dead) {
            return -1;
        }
        int n = (int)(l - this.getLastTime());
        if (n > 14) {
            this.dead = true;
            return -1;
        }
        return n;
    }

    public void firedAt(BulletTracking bulletTracking) {
        this.lastBulletFiredAt2 = this.lastBulletFiredAt;
        this.lastBulletFiredAt = bulletTracking;
    }

    public void bulletHit(BulletTracking bulletTracking) {
        if (bulletTracking.getTargetOpponent() == this) {
            this.selfAiming.hit(bulletTracking);
            this.outgoingSK.hit(bulletTracking);
        } else {
            this.selfAiming.possibleHit(bulletTracking);
        }
        this.solicitedEnergyLost += bulletTracking.getDamage();
    }

    public void bulletPossibleHit(BulletTracking bulletTracking) {
        assert (bulletTracking.getTargetOpponent() == this);
        this.selfAiming.possibleHit(bulletTracking);
    }

    public void bulletMiss(BulletTracking bulletTracking) {
        this.selfAiming.miss(bulletTracking);
        if (!bulletTracking.isSimulated()) {
            this.outgoingSK.miss(bulletTracking);
        }
    }

    public long lastSeen(long l) {
        return l - this.lastTime[this.lastIndex];
    }

    public BulletTracking updateInfo(ScannedRobotEvent scannedRobotEvent, double d, Position position) {
        double d2;
        long l;
        long l2 = scannedRobotEvent.getTime();
        long l3 = l2 - this.lastTime[this.lastIndex];
        if (l3 > 1L) {
            Log.log(3, scannedRobotEvent.getTime() + ": " + (l3 - 1L) + " scan(s) skipped");
        }
        ++this.lastIndex;
        this.lastIndex %= 40;
        this.lastHeading[this.lastIndex] = scannedRobotEvent.getHeadingRadians();
        this.lastVelocity[this.lastIndex] = scannedRobotEvent.getVelocity();
        if (this.lastVelocity[this.lastIndex] > 0.0) {
            this.lastDirection = 1;
        }
        if (this.lastVelocity[this.lastIndex] < 0.0) {
            this.lastDirection = -1;
        }
        this.lastTime[this.lastIndex] = l2;
        this.lastPosition[this.lastIndex].x = position.x + Math.sin(d) * scannedRobotEvent.getDistance();
        this.lastPosition[this.lastIndex].y = position.y + Math.cos(d) * scannedRobotEvent.getDistance();
        this.lastPosition[this.lastIndex].correctForWalls();
        if (this.lastBulletFiredAt != null && this.lastBulletFiredAt != this.lastBulletFiredAtConsidered && (this.lastBulletFiredAt2 == null || this.lastBulletFiredAt2.getETA(this.lastPosition[this.lastIndex]) + 1L < scannedRobotEvent.getTime()) && (l = l2 - this.lastBulletFiredAt.getTime()) >= 2L && l <= 4L) {
            try {
                d2 = this.lastVelocity[this.lastIndex] - this.getLastVelocity(l2 - 1L);
                double d3 = this.getLastVelocity(l2 - 1L) - this.getLastVelocity(l2 - 2L);
                if (d2 != d3) {
                    Log.log(3, this.name + " is reacting to fired bullet, delta t: " + l);
                    ++this.bulletReaction.bulletsReactedTo;
                } else {
                    ++this.bulletReaction.bulletsIgnored;
                    Log.log(3, "Bullet ignored");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.lastBulletFiredAtConsidered = this.lastBulletFiredAt;
        }
        if (scannedRobotEvent.getEnergy() + this.solicitedEnergyLost < this.lastEnergy && l3 == 1L) {
            ++this.lastEnergyIndex;
            this.lastEnergyIndex %= 40;
            this.lastEnergyDrop[this.lastEnergyIndex] = this.lastEnergy - scannedRobotEvent.getEnergy() + this.solicitedEnergyLost;
            this.lastEnergyDropTime[this.lastEnergyIndex] = scannedRobotEvent.getTime();
            if (this.lastEnergyDrop[this.lastEnergyIndex] >= 0.09000000000000001 && this.lastEnergyDrop[this.lastEnergyIndex] <= 3.01) {
                boolean bl = false;
                for (int i = 1; i <= 8; ++i) {
                    d2 = Rules.getWallHitDamage((double)i);
                    if (!(this.lastEnergyDrop[this.lastEnergyIndex] >= d2 - 0.01) && !(this.lastEnergyDrop[this.lastEnergyIndex] <= d2 + 0.01)) continue;
                    bl = true;
                    break;
                }
                if (!(!bl || this.lastPosition[this.lastIndex].getWallDistance() < 20.0 && Rules.getGunHeat((double)this.lastBulletEnergy) / 0.1 > (double)(scannedRobotEvent.getTime() - this.lastBulletTime + 2L))) {
                    this.lastEnergy = scannedRobotEvent.getEnergy();
                    this.solicitedEnergyLost = 0.0;
                    this.lastBulletEnergy = this.lastEnergyDrop[this.lastEnergyIndex];
                    this.lastBulletTime = scannedRobotEvent.getTime() - 1L;
                    this.lastPosition[this.lastIndex].check();
                    return new BulletTracking(this.lastBulletEnergy, this.lastBulletTime);
                }
            }
        }
        this.solicitedEnergyLost = 0.0;
        this.lastEnergy = scannedRobotEvent.getEnergy();
        this.lastPosition[this.lastIndex].check();
        return null;
    }

    public Position getLastPosition(long l) throws Exception {
        if (this.dead && l >= this.lastTime[this.lastIndex]) {
            return this.lastPosition[this.lastIndex];
        }
        this.lastPosition[this.lastIndex].check();
        int n = this.lastIndex;
        for (int i = 0; i < 40; ++i) {
            if (this.lastTime[n] == l) {
                return this.lastPosition[n];
            }
            if (this.lastTime[n] < l) {
                if (i > 0) {
                    return this.lastPosition[n].getAverage(this.lastPosition[(n + 1) % 40]);
                }
                Position position = new Position(this.lastPosition[n]);
                position.modify(l - this.lastTime[n], this.lastVelocity[n], this.lastHeading[n]);
                position.check();
                return position;
            }
            n += 39;
            n %= 40;
        }
        throw new Exception();
    }

    public double getLastHeading(long l) throws Exception {
        if (this.dead && l >= this.lastTime[this.lastIndex]) {
            return this.lastHeading[this.lastIndex];
        }
        int n = this.lastIndex;
        for (int i = 0; i < 40; ++i) {
            if (this.lastTime[n] == l) {
                return this.lastHeading[n];
            }
            if (this.lastTime[n] < l) {
                if (i > 0) {
                    return Utils.normalAbsoluteAngle((double)((Utils.normalRelativeAngle((double)this.lastHeading[n]) + Utils.normalRelativeAngle((double)this.lastHeading[(n + 1) % 40])) / 2.0));
                }
                int n2 = (n + 40 - 1) % 40;
                return Utils.normalAbsoluteAngle((double)(this.lastHeading[n] + Utils.normalRelativeAngle((double)(this.lastHeading[n] - this.lastHeading[n2])) * (double)(l - this.lastTime[n2]) / (double)(this.lastTime[n] - this.lastTime[n2])));
            }
            n += 39;
            n %= 40;
        }
        throw new Exception();
    }

    public double getLastVelocity(long l) throws Exception {
        if (this.dead && l >= this.lastTime[this.lastIndex]) {
            return this.lastVelocity[this.lastIndex];
        }
        int n = this.lastIndex;
        for (int i = 0; i < 40; ++i) {
            if (this.lastTime[n] == l) {
                return this.lastVelocity[n];
            }
            if (this.lastTime[n] < l) {
                if (i > 0) {
                    return (this.lastVelocity[n] + this.lastVelocity[(n + 1) % 40]) / 2.0;
                }
                int n2 = (n + 40 - 1) % 40;
                return this.lastVelocity[n] + (this.lastVelocity[n] - this.lastVelocity[n2]) * (double)(l - this.lastTime[n2]) / (double)(this.lastTime[n] - this.lastTime[n2]);
            }
            n += 39;
            n %= 40;
        }
        throw new Exception();
    }

    public void bulletMissedMe(BulletTracking bulletTracking) {
        if (this.opponentAiming != null) {
            this.opponentAiming.miss(bulletTracking);
        }
        this.incomingSK.miss(bulletTracking);
    }

    public void bulletHitMe(BulletTracking bulletTracking) {
        if (this.opponentAiming != null) {
            this.opponentAiming.hit(bulletTracking);
        }
        this.incomingSK.hit(bulletTracking);
    }

    public void death() {
        this.dead = true;
        Log.log(1, "Opponent " + this + " died");
        Log.log(1, "Opponents aming:");
        if (this.opponentAiming != null) {
            this.opponentAiming.dumpStats();
        }
        Log.log(1, "Our aming at opponent:");
        this.selfAiming.dumpStats();
        Log.log(1, "Incoming scoring:");
        Log.log(1, this.incomingSK.toString());
        Log.log(1, "Outgoing scoring:");
        Log.log(1, this.outgoingSK.toString());
    }

    public double getMaxVelocity() {
        if (this.lastEnergy == 0.0) {
            return 0.01;
        }
        return 8.0;
    }

    public Aiming getSelfAiming() {
        return this.selfAiming;
    }

    public Aiming getOpponentAiming() {
        return this.opponentAiming;
    }

    public long getLastTime() {
        return this.lastTime[this.lastIndex];
    }

    public Position getLastPosition() {
        return this.lastPosition[this.lastIndex];
    }

    public double getLastEnergy() {
        return this.lastEnergy;
    }

    public double getLastHeading() {
        return this.lastHeading[this.lastIndex];
    }

    public double getLastVelocity() {
        return this.lastVelocity[this.lastIndex];
    }

    public String toString() {
        return this.name;
    }

    public void bulletPossibleHitMe(BulletTracking bulletTracking) {
        if (this.opponentAiming != null) {
            this.opponentAiming.possibleHit(bulletTracking);
        }
    }

    public int getLastDirection() {
        return this.lastDirection;
    }

    public double getVelocityDelta() {
        long l = this.getLastTime();
        try {
            return this.getLastVelocity(l) - this.getLastVelocity(l - 1L);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    public long getLastSpeedChange(long l) {
        long l2 = l;
        try {
            double d = this.getLastVelocity(l);
            for (int i = 0; i < 40; ++i) {
                if (d == this.getLastVelocity(--l2)) continue;
                return l - l2;
            }
        }
        catch (Exception exception) {
            return 10000L;
        }
        return 10000L;
    }

    public long getLastEnergyDrop(long l) {
        if (this.lastEnergyDropTime[this.lastEnergyIndex] == 0L) {
            return Long.MAX_VALUE;
        }
        return l - this.lastEnergyDropTime[this.lastEnergyIndex];
    }

    public boolean isMovementBasedOnFiring() {
        if (this.bulletReaction.bulletsIgnored + this.bulletReaction.bulletsReactedTo < 5) {
            return true;
        }
        return (double)this.bulletReaction.bulletsReactedTo / (double)(this.bulletReaction.bulletsIgnored + this.bulletReaction.bulletsReactedTo) > 0.2;
    }

    public boolean isDead() {
        return this.dead;
    }
}

