/*
 * Decompiled with CFR 0.152.
 */
package oog;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class PricklyPear
extends AdvancedRobot {
    static final Rectangle2D.Double fieldRect = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    static final Rectangle2D.Double movingField = new Rectangle2D.Double(36.0, 36.0, 728.0, 528.0);
    Info info = new Info();
    boolean enemyScanned = false;
    static double[] myTotalShots = new double[11];
    static double[] myTotalHits = new double[11];
    static double totalBulletHitBullets;
    static double totalEnemyShots;
    static final boolean DRAW_MOVE_WAVES = true;
    static double[][][] surfHits;
    ArrayList surfWaves = new ArrayList();
    double enemyGunHeat = 2.666666666666667;
    ArrayList gunWaves = new ArrayList();
    static double[][] mainGunHits;
    static double[] gunBuffers;
    static final int BINS = 33;
    static final int MID_BIN = 16;
    static double[][][] GFHits;
    static ArrayList magicShots;
    static final int NUMBER_OF_CROWD_GUNS = 4;
    static double[][] crowdHits;
    static double[] fretGunHits;

    static {
        surfHits = new double[17][17][11];
        mainGunHits = new double[21][3];
        gunBuffers = new double[21];
        GFHits = new double[33][17][11];
        magicShots = new ArrayList();
        crowdHits = new double[4][11];
        fretGunHits = new double[2];
    }

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        Color darkGreen = new Color(0, 50, 10);
        this.setColors(darkGreen, Color.black, darkGreen);
        this.setScanColor(darkGreen);
        this.setBulletColor(Color.black);
        while (true) {
            this.getAllEvents();
            if (!this.enemyScanned) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            } else {
                this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(this.info.absBearing - this.getRadarHeadingRadians())) * 2.0);
                this.gun();
                this.move();
            }
            this.execute();
        }
    }

    public void move() {
        double energyChange = this.info.lastEnemyEnergy - this.info.enemyEnergy;
        this.enemyGunHeat -= 0.1;
        if (energyChange >= 0.1 && energyChange <= 3.0 && this.enemyGunHeat <= 0.1) {
            totalEnemyShots += 1.0;
            this.enemyGunHeat = 1.0 + energyChange / 5.0;
            this.fireMovementWave(energyChange);
        }
        if (this.info.wasHit) {
            this.addMovementHit(this.surfWave(true));
            this.info.wasHit = false;
        }
        this.updateMovementWaves();
        double turn = this.findBestDirection();
        int dir = Math.abs(turn - this.info.myHeading) < 1.5707963267948966 ? 1 : -1;
        this.setAhead((double)dir * Double.POSITIVE_INFINITY);
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)(turn + (dir == 1 ? 0.0 : Math.PI) - this.info.myHeading)));
    }

    public void addMovementHit(MovementWave mw) {
        if (mw != null) {
            double myAngle = Utils.normalAbsoluteAngle((double)Math.atan2(this.info.myPos.x - mw.eStartPos.x, this.info.myPos.y - mw.eStartPos.y));
            int GF = (int)Math.rint(8.0 + 8.0 * (Utils.normalRelativeAngle((double)(myAngle - mw.startBearing)) / mw.maxEscapeAngle));
            int a = 0;
            while (a < 17) {
                int b = 0;
                while (b < 17) {
                    int c = 0;
                    while (c < 11) {
                        double[] dArray = surfHits[a][b];
                        int n = c;
                        dArray[n] = dArray[n] * 0.9;
                        double[] dArray2 = surfHits[a][b];
                        int n2 = c;
                        dArray2[n2] = dArray2[n2] + 1.0 / (Math.pow((a - GF == 0 ? 0.5 : (double)(a - GF)) / 16.0, 2.0) + Math.pow((b - ((int)Math.rint(mw.latVelSeg) + 8) == 0 ? 0.5 : (double)(b - ((int)Math.rint(mw.latVelSeg) + 8))) / 16.0, 2.0) + Math.pow((c - mw.distSeg == 0 ? 0.5 : (double)(c - mw.distSeg)) / 16.0, 2.0));
                        ++c;
                    }
                    ++b;
                }
                ++a;
            }
        }
    }

    public MovementWave surfWave(boolean hit) {
        double bestDistance = Double.NEGATIVE_INFINITY;
        MovementWave closest = null;
        int i = 0;
        while (i < this.surfWaves.size()) {
            MovementWave mw = (MovementWave)this.surfWaves.get(i);
            double radius = (this.info.time - mw.startTime) * mw.speed + mw.speed;
            if (radius > bestDistance && (hit || radius < this.info.myPos.distance(mw.eStartPos))) {
                closest = mw;
                bestDistance = radius;
            }
            ++i;
        }
        return closest;
    }

    public double findBestDirection() {
        double bestRating = Double.POSITIVE_INFINITY;
        double bestTurn = 0.0;
        double bestGF = -1.0;
        double bestDistRating = Double.POSITIVE_INFINITY;
        double turn = 0.0;
        while (turn < Math.PI * 2) {
            Point2D.Double movePoint = this.project(this.info.myPos, 160.0, turn);
            double rating = 0.0;
            double distRating = Math.abs(350.0 - movePoint.distance(this.info.ePos));
            if (this.info.enemyEnergy == 0.0) {
                distRating = rating = movePoint.distance(this.info.ePos);
            }
            int GF = -1;
            if (this.surfWave(false) != null) {
                MovementWave mw = this.surfWave(false);
                movePoint = this.predictPos(turn, mw);
                double myAngle = Utils.normalAbsoluteAngle((double)Math.atan2(movePoint.x - mw.eStartPos.x, movePoint.y - mw.eStartPos.y));
                GF = (int)Math.rint(8.0 + 8.0 * (Utils.normalRelativeAngle((double)(myAngle - mw.startBearing)) / mw.maxEscapeAngle));
                rating = this.rateMovementWaves(GF);
            }
            if ((rating < bestRating || (double)GF == bestGF && distRating < bestDistRating) && (movingField.contains(movePoint) || this.info.enemyEnergy == 0.0)) {
                bestGF = GF;
                bestTurn = turn;
                bestRating = rating;
                bestDistRating = distRating;
            }
            turn += 0.19634954084936207;
        }
        return bestTurn;
    }

    public void fireMovementWave(double bulletPower) {
        MovementWave mw = new MovementWave();
        mw.startBearing = Utils.normalRelativeAngle((double)(this.info.absBearing + Math.PI));
        mw.startTime = this.info.time;
        mw.eStartPos = this.info.ePos;
        mw.latVelSeg = this.info.myLatVel;
        mw.distSeg = (int)Math.rint(this.info.distance) / 100;
        mw.speed = 20.0 - 3.0 * bulletPower;
        mw.maxEscapeAngle = Math.asin(8.0 / mw.speed);
        this.surfWaves.add(mw);
    }

    public double rateMovementWaves(int GF) {
        double rating = 0.0;
        int i = 0;
        while (i < this.surfWaves.size()) {
            MovementWave mw = (MovementWave)this.surfWaves.get(i);
            double timeUntilHit = (this.info.myPos.distance(mw.eStartPos) - ((this.info.time - mw.startTime) * mw.speed + mw.speed)) / mw.speed;
            if (timeUntilHit > 0.0) {
                rating += surfHits[GF][(int)Math.rint(mw.latVelSeg) + 8][mw.distSeg] / Math.pow(timeUntilHit, 2.0);
                if (surfHits[GF][(int)Math.rint(mw.latVelSeg) + 8][mw.distSeg] / Math.pow(timeUntilHit, 2.0) == 0.0) {
                    double dodgeAngle = mw.latVelSeg + 8.0;
                    rating += 1.0 / Math.pow((double)GF - dodgeAngle == 0.0 ? 0.5 : (double)GF - dodgeAngle, 2.0);
                }
            }
            ++i;
        }
        return rating;
    }

    public Point2D.Double predictPos(double turnAngle, MovementWave mw) {
        Point2D.Double movePoint = this.info.myPos;
        double radius = (this.info.time - mw.startTime) * mw.speed + mw.speed;
        double heading = this.info.myHeading;
        int dir = Math.abs(turnAngle - this.info.myHeading) < 1.5707963267948966 ? 1 : -1;
        double speed = this.info.myVelocity;
        do {
            heading += Math.max(-Rules.MAX_TURN_RATE_RADIANS, Math.min(Rules.MAX_TURN_RATE_RADIANS, Utils.normalRelativeAngle((double)(turnAngle + (dir == 1 ? 0.0 : Math.PI) - heading))));
            speed += (double)((speed / (double)dir > 0.0 ? 1 : 2) * dir);
            if (fieldRect.contains(movePoint = this.project(movePoint, speed = Math.min(8.0, Math.max(-8.0, speed)), heading))) continue;
            return movePoint;
        } while ((radius += mw.speed) < movePoint.distance(mw.eStartPos));
        return movePoint;
    }

    public void updateMovementWaves() {
        int i = 0;
        while (i < this.surfWaves.size()) {
            MovementWave mw = (MovementWave)this.surfWaves.get(i);
            Graphics2D g = this.getGraphics();
            g.setColor(Color.blue);
            double radius = (this.info.time - mw.startTime) * mw.speed + mw.speed;
            g.drawOval((int)(mw.eStartPos.x - radius), (int)(mw.eStartPos.y - radius), (int)radius * 2, (int)radius * 2);
            if ((this.info.time - mw.startTime) * mw.speed + mw.speed > mw.eStartPos.distance(this.info.myPos) + 30.0) {
                this.surfWaves.remove(mw);
            }
            ++i;
        }
    }

    public void gun() {
        double bulletPower = this.findBulletPower();
        double bulletSpeed = 20.0 - 3.0 * bulletPower;
        this.updateWaves();
        double[] crowdShots = this.findCrowdShots(bulletSpeed);
        double[] aim = new double[]{this.findGFAim(bulletSpeed), this.findMagicAim(bulletSpeed), this.findCrowdedGunAim(crowdShots)};
        int currentBuffer = 0;
        double bestBuffer = Double.NEGATIVE_INFINITY;
        int i = 1;
        while (i < 21) {
            if (gunBuffers[i] >= bestBuffer) {
                currentBuffer = i;
                bestBuffer = gunBuffers[i];
            }
            ++i;
        }
        double[] finalAim = new double[21];
        int gunType = 0;
        int buffer = 0;
        while (buffer < 21) {
            double bestGun = Double.NEGATIVE_INFINITY;
            int i2 = 0;
            while (i2 < 3) {
                if (mainGunHits[buffer][i2] >= bestGun) {
                    bestGun = mainGunHits[buffer][i2];
                    finalAim[buffer] = aim[i2];
                    if (buffer == currentBuffer) {
                        gunType = i2;
                    }
                }
                ++i2;
            }
            ++buffer;
        }
        if (gunType == 0) {
            System.out.println("Current Gun: GuessFactor");
        }
        if (gunType == 1) {
            System.out.println("Current Gun: Magic Gun");
        }
        if (gunType == 2) {
            System.out.println("Current Gun: Crowded Gun");
        }
        System.out.println("Current VGun rolling is:  " + (double)currentBuffer / 20.0);
        double randomAim = 0.0;
        if (totalBulletHitBullets / totalEnemyShots > 0.25) {
            System.out.println("Using anti bulletshielding mode");
            randomAim = 0.01 - 0.02 * Math.random();
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.info.absBearing - this.getGunHeadingRadians())) + finalAim[currentBuffer] + randomAim);
        if (this.getGunHeat() == 0.0 && (this.info.myEnergy >= 1.0 || this.info.enemyEnergy < this.info.myEnergy * 4.0) && this.info.enemyEnergy > 0.0) {
            this.fireGunWave(crowdShots, aim, bulletSpeed, finalAim);
            this.setFire(bulletPower);
            int n = (int)Math.rint(this.info.distance / 100.0);
            myTotalShots[n] = myTotalShots[n] + 1.0;
        }
    }

    public void checkForMainGunHits(GunWave gw) {
        if (this.info.eRect.contains(this.project(gw.myStartPos, (this.info.time - gw.startTime) * gw.speed, gw.GFBulletAngle))) {
            gw.firstGunHit = true;
        }
        if (this.info.eRect.contains(this.project(gw.myStartPos, (this.info.time - gw.startTime) * gw.speed, gw.magicBulletAngle))) {
            gw.secondGunHit = true;
        }
        if (this.info.eRect.contains(this.project(gw.myStartPos, (this.info.time - gw.startTime) * gw.speed, gw.crowdBulletAngle))) {
            gw.thirdGunHit = true;
        }
        int i = 0;
        while (i < 21) {
            if (this.info.eRect.contains(this.project(gw.myStartPos, (this.info.time - gw.startTime) * gw.speed, gw.gunBufferAngles[i]))) {
                gw.gunBufferHit[i] = true;
            }
            ++i;
        }
    }

    public void doGunWaveSegments(GunWave gw) {
        gw.latVelSeg = (int)Math.rint(this.info.eLatVel);
        gw.distanceSeg = (int)Math.rint(this.info.distance / 100.0);
        gw.timeSeg = this.info.timeCount;
    }

    public double findBulletPower() {
        double hitRate = myTotalHits[(int)Math.rint(this.info.distance / 100.0)] / myTotalShots[(int)Math.rint(this.info.distance / 100.0)];
        if (myTotalHits[(int)Math.rint(this.info.distance / 100.0)] == 0.0) {
            int i = 0;
            while (i < 11) {
                if (myTotalHits[i] != 0.0) {
                    hitRate = myTotalHits[i] / myTotalShots[i];
                }
                ++i;
            }
        }
        double bulletPower = 1.0 + Math.sqrt(100.0 * hitRate) / 4.0;
        System.out.println("Base FirePower:  " + bulletPower);
        bulletPower = Math.min(bulletPower, this.info.enemyEnergy / 4.0);
        bulletPower = Math.min(bulletPower, this.info.myEnergy / 15.0);
        if (this.info.distance < 100.0) {
            bulletPower = 3.0;
        }
        bulletPower = this.limit(bulletPower, 0.1, 3.0);
        return bulletPower;
    }

    public void fireGunWave(double[] crowdShots, double[] aim, double bulletSpeed, double[] finalAim) {
        GunWave gw = new GunWave();
        gw.startBearing = this.info.absBearing;
        gw.startTime = this.info.time;
        gw.speed = bulletSpeed;
        gw.myStartPos = this.info.myPos;
        gw.maxEscapeAngle = Math.asin(8.0 / gw.speed);
        this.doGunWaveSegments(gw);
        this.initMainGun(gw, aim, finalAim);
        this.initCrowdGun(gw, crowdShots);
        this.gunWaves.add(gw);
    }

    public void initMainGun(GunWave gw, double[] aim, double[] finalAim) {
        gw.GFBulletAngle = gw.startBearing + aim[0];
        gw.magicBulletAngle = gw.startBearing + aim[1];
        gw.crowdBulletAngle = gw.startBearing + aim[2];
        int i = 0;
        while (i < 21) {
            gw.gunBufferHit[i] = false;
            gw.gunBufferAngles[i] = gw.startBearing + finalAim[i];
            ++i;
        }
        gw.firstGunHit = false;
        gw.secondGunHit = false;
        gw.thirdGunHit = false;
    }

    public void removeGunWave(GunWave gw) {
        gw.GF = this.findGunGF(gw);
        int a = 0;
        while (a < 33) {
            int b = -8;
            while (b < 9) {
                int c = 0;
                while (c < 11) {
                    double[] dArray = GFHits[a][b + 8];
                    int n = c;
                    dArray[n] = dArray[n] + 1.0 / (Math.pow(a - gw.GF == 0 ? 0.5 : (double)(a - gw.GF), 2.0) + Math.pow(b - gw.latVelSeg == 0 ? 0.5 : (double)(b - gw.latVelSeg), 2.0) + Math.pow(c - gw.distanceSeg == 0 ? 0.5 : (double)(c - gw.distanceSeg), 2.0));
                    ++c;
                }
                ++b;
            }
            ++a;
        }
        this.updateMainGunHits(gw);
        this.updateCrowdedGunHits(gw);
        magicShots.add(gw);
        PricklyPear.fretGunHits[gw.latVelSeg > 0 ? 1 : 0] = gw.GF;
        this.gunWaves.remove(gw);
    }

    public void updateMainGunHits(GunWave gw) {
        int i = 0;
        while (i < 21) {
            int b = 0;
            while (b < 3) {
                double[] dArray = mainGunHits[i];
                int n = b++;
                dArray[n] = dArray[n] * ((double)i / 20.0);
            }
            if (gw.firstGunHit) {
                double[] dArray = mainGunHits[i];
                dArray[0] = dArray[0] + 1.0;
            }
            if (gw.secondGunHit) {
                double[] dArray = mainGunHits[i];
                dArray[1] = dArray[1] + 1.0;
            }
            if (gw.thirdGunHit) {
                double[] dArray = mainGunHits[i];
                dArray[2] = dArray[2] + 1.0;
            }
            if (gw.gunBufferHit[i]) {
                int n = i;
                gunBuffers[n] = gunBuffers[n] + 1.0;
            }
            ++i;
        }
    }

    public void updateWaves() {
        int i = 0;
        while (i < this.gunWaves.size()) {
            GunWave gw = (GunWave)this.gunWaves.get(i);
            this.checkForMainGunHits(gw);
            this.checkForCrowdedGunHits(gw);
            if ((this.info.time - gw.startTime) * gw.speed > this.info.myPos.distance(this.info.ePos)) {
                this.removeGunWave(gw);
            }
            ++i;
        }
    }

    public double findGFAim(double bulletSpeed) {
        double bestGFAngle = Double.NEGATIVE_INFINITY;
        int GFAim = 0;
        int i = 0;
        while (i < 33) {
            if (GFHits[i][(int)Math.rint(this.info.eLatVel) + 8][(int)Math.rint(this.info.distance / 100.0)] > bestGFAngle) {
                bestGFAngle = GFHits[i][(int)Math.rint(this.info.eLatVel) + 8][(int)Math.rint(this.info.distance / 100.0)];
                GFAim = i - 16;
            }
            ++i;
        }
        return Math.asin((double)GFAim * 0.5 / bulletSpeed);
    }

    public int findGunGF(GunWave gw) {
        int found = (int)Math.rint(16.0 + 16.0 * Utils.normalRelativeAngle((double)(Utils.normalAbsoluteAngle((double)Math.atan2(this.info.ePos.x - gw.myStartPos.x, this.info.ePos.y - gw.myStartPos.y)) - gw.startBearing)) / gw.maxEscapeAngle);
        found = (int)this.limit(found, 0.0, 32.0);
        return found;
    }

    public double findMagicAim(double bulletSpeed) {
        double bestMagicShot = Double.POSITIVE_INFINITY;
        double aim = 0.0;
        int i = 0;
        while (i < magicShots.size()) {
            GunWave gw = (GunWave)magicShots.get(i);
            double rating = Math.pow((double)gw.latVelSeg - this.info.eLatVel, 2.0) + Math.pow(((double)gw.distanceSeg - this.info.distance / 100.0) / 10.0, 2.0) + Math.pow((this.info.timeCount - gw.timeSeg) / 200 > 1 ? 1 : 0, 2.0);
            if (rating <= bestMagicShot) {
                bestMagicShot = rating;
                aim = Math.asin((double)(gw.GF - 16) * 0.5 / bulletSpeed);
            }
            ++i;
        }
        return aim;
    }

    public double circularTargetingAngle(double bulletSpeed) {
        double headingChange = this.info.eHeadingChange;
        int count = 0;
        Point2D.Double aimSpot = this.info.ePos;
        double enemyHeading = this.info.eHeading;
        while ((double)(++count) * bulletSpeed < this.info.myPos.distance(aimSpot)) {
            aimSpot = this.project(aimSpot, this.info.eVelocity, enemyHeading);
            enemyHeading = Utils.normalRelativeAngle((double)(enemyHeading + headingChange));
            if (!fieldRect.contains(aimSpot)) break;
        }
        double aim = Utils.normalRelativeAngle((double)(Utils.normalAbsoluteAngle((double)Math.atan2(aimSpot.x - this.info.myPos.x, aimSpot.y - this.info.myPos.y)) - this.info.absBearing));
        return aim;
    }

    public void checkForCrowdedGunHits(GunWave gw) {
        int i = 0;
        while (i < 4) {
            if (this.info.eRect.contains(this.project(gw.myStartPos, (this.info.time - gw.startTime) * gw.speed, gw.crowdGunAngles[i]))) {
                gw.crowdGunHits[i] = true;
            }
            ++i;
        }
    }

    public double findCrowdedGunAim(double[] shots) {
        double crowdBest = Double.NEGATIVE_INFINITY;
        double aim = 0.0;
        int i = 0;
        while (i < 4) {
            if (crowdHits[i][(int)Math.rint(this.info.distance / 100.0)] >= crowdBest) {
                crowdBest = crowdHits[i][(int)Math.rint(this.info.distance / 100.0)];
                aim = shots[i];
            }
            ++i;
        }
        if (crowdBest == 0.0) {
            aim = shots[2];
        }
        return aim;
    }

    public double[] findCrowdShots(double bulletSpeed) {
        double[] crowdShots = new double[]{0.0, this.info.eLatVel / bulletSpeed, this.circularTargetingAngle(bulletSpeed), Math.asin((fretGunHits[this.info.eLatVel > 0.0 ? 1 : 0] - 16.0) * 0.5 / bulletSpeed)};
        return crowdShots;
    }

    public void initCrowdGun(GunWave gw, double[] crowdShots) {
        int i = 0;
        while (i < 4) {
            gw.crowdGunAngles[i] = gw.startBearing + crowdShots[i];
            gw.crowdGunHits[i] = false;
            ++i;
        }
    }

    public void updateCrowdedGunHits(GunWave gw) {
        int i = 0;
        while (i < 4) {
            if (gw.crowdGunHits[i]) {
                double[] dArray = crowdHits[i];
                int n = gw.distanceSeg;
                dArray[n] = dArray[n] + 1.0;
            }
            ++i;
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        totalBulletHitBullets += 1.0;
        try {
            Point2D.Double eBulletPos = new Point2D.Double(e.getHitBullet().getX(), e.getHitBullet().getY());
            MovementWave eHitWave = this.findEHitBullet(eBulletPos, e.getHitBullet().getVelocity());
            int GF = (int)Math.rint(8.0 + 8.0 * (Utils.normalRelativeAngle((double)(e.getHitBullet().getHeadingRadians() - eHitWave.startBearing)) / eHitWave.maxEscapeAngle));
            int a = 0;
            while (a < 17) {
                int b = 0;
                while (b < 17) {
                    int c = 0;
                    while (c < 11) {
                        double[] dArray = surfHits[a][b];
                        int n = c;
                        dArray[n] = dArray[n] + 1.0 / (Math.pow((a - GF == 0 ? 0.5 : (double)(a - GF)) / 16.0, 2.0) + Math.pow((b - ((int)Math.rint(eHitWave.latVelSeg) + 8) == 0 ? 0.5 : (double)(b - ((int)Math.rint(eHitWave.latVelSeg) + 8))) / 16.0, 2.0) + Math.pow((c - eHitWave.distSeg == 0 ? 0.5 : (double)(c - eHitWave.distSeg)) / 16.0, 2.0));
                        ++c;
                    }
                    ++b;
                }
                ++a;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MovementWave findEHitBullet(Point2D.Double bulletPos, double bulletSpeed) {
        MovementWave closest = null;
        try {
            double bestRating = Double.POSITIVE_INFINITY;
            int closestIndex = 0;
            int i = 0;
            while (i < this.surfWaves.size()) {
                MovementWave mw = (MovementWave)this.surfWaves.get(i);
                double rating = Math.abs((this.info.time - mw.startTime) * mw.speed + mw.speed - bulletPos.distance(mw.eStartPos));
                if (rating < bestRating) {
                    bestRating = rating;
                    closest = mw;
                    closestIndex = i;
                }
                ++i;
            }
            this.surfWaves.remove(closestIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return closest;
    }

    public void onBulletHit(BulletHitEvent e) {
        this.info.lastEnemyEnergy = this.info.lastEnemyEnergy - (4.0 * e.getBullet().getPower() + (e.getBullet().getPower() > 1.0 ? 2.0 * (e.getBullet().getPower() - 1.0) : 0.0));
        int n = (int)Math.rint(this.info.distance / 100.0);
        myTotalHits[n] = myTotalHits[n] + 1.0;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.info.wasHit = true;
        this.info.lastEnemyEnergy += 3.0 * e.getPower();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.enemyScanned = true;
        this.info.myPos = new Point2D.Double(this.getX(), this.getY());
        this.info.absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.info.time = this.getTime();
        this.info.eLatVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - this.info.absBearing);
        this.info.distance = e.getDistance();
        this.info.ePos = this.project(this.info.myPos, this.info.distance, this.info.absBearing);
        this.info.eRect = new Rectangle2D.Double(this.info.ePos.x - 18.0, this.info.ePos.y - 18.0, 36.0, 36.0);
        this.info.eHeadingChange = e.getHeadingRadians() - this.info.eHeading;
        this.info.eHeading = e.getHeadingRadians();
        this.info.lastEnemyEnergy = this.info.enemyEnergy;
        this.info.enemyEnergy = e.getEnergy();
        this.info.myLatVel = this.getVelocity() * Math.sin(this.getHeadingRadians() - Utils.normalRelativeAngle((double)(this.info.absBearing + Math.PI)));
        this.info.myHeading = this.getHeadingRadians();
        this.info.myVelocity = this.getVelocity();
        this.info.myEnergy = this.getEnergy();
        ++this.info.timeCount;
        this.info.eVelocity = e.getVelocity();
    }

    public double limit(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public Point2D.Double project(Point2D.Double origin, double dist, double angle) {
        return new Point2D.Double(origin.x + dist * Math.sin(angle), origin.y + dist * Math.cos(angle));
    }

    public class GunWave {
        Point2D.Double myStartPos;
        boolean[] gunBufferHit = new boolean[21];
        boolean firstGunHit;
        boolean secondGunHit;
        boolean thirdGunHit;
        boolean[] crowdGunHits = new boolean[4];
        double startBearing;
        double speed;
        double startTime;
        double[] crowdGunAngles = new double[4];
        int latVelSeg;
        double maxEscapeAngle;
        double[] gunBufferAngles = new double[21];
        double GFBulletAngle;
        double magicBulletAngle;
        double crowdBulletAngle;
        int GF;
        int distanceSeg;
        int timeSeg;
    }

    public class Info {
        Point2D.Double myPos;
        Point2D.Double ePos;
        Rectangle2D.Double eRect;
        double enemyEnergy;
        double lastEnemyEnergy;
        double distance;
        double absBearing;
        double time;
        double eLatVel;
        double eHeading;
        double myLatVel;
        double myHeading;
        boolean wasHit;
        double myEnergy;
        double myVelocity;
        int timeCount;
        double eHeadingChange;
        double eVelocity;
    }

    public class MovementWave {
        Point2D.Double eStartPos;
        double latVelSeg;
        double startBearing;
        double startTime;
        double speed;
        double maxEscapeAngle;
        int distSeg;
    }
}

