/*
 * Decompiled with CFR 0.152.
 */
package ustimaw;

import java.util.ArrayList;
import java.util.HashMap;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import ustimaw.Gun;
import ustimaw.Nightmare;
import ustimaw.Position;

class GuessFactorTargeting
extends Gun {
    private final ArrayList<Wave> waves = new ArrayList();
    private final ArrayList<Data> data = new ArrayList();
    private final int nbin = 31;
    private final HashMap<String, double[]> binsMap = new HashMap();

    GuessFactorTargeting() {
    }

    @Override
    double getAngle(Nightmare n, double p) {
        if (n.target == null) {
            return 0.0;
        }
        this.fire(n, p);
        double gf = 0.0;
        if (this.data.size() != 0) {
            gf = this.data.get(this.data.size() - 1).guessFactor;
        }
        int x = 15;
        double[] bins = this.binsMap.get(n.target);
        int i = 0;
        while (i < 31) {
            if (bins[x] < bins[i]) {
                x = i;
            }
            ++i;
        }
        gf = (1.0 * (double)x - 15.0) / 15.0;
        double rb = n.getCurrentEnemyPosition(n.target).sub(n.getPosition()).arg();
        return rb + this.getMaxEscapeAngle(p) * gf * (double)(Math.sin(n.enemys.get((Object)n.target).sre.getHeadingRadians() - rb) * n.enemys.get((Object)n.target).sre.getVelocity() > 0.0 ? 1 : -1);
    }

    @Override
    String name() {
        return null;
    }

    @Override
    void update(Nightmare n) {
        for (String s : n.enemys.keySet()) {
            if (this.binsMap.containsKey(s)) continue;
            this.binsMap.put(s, new double[31]);
        }
        int i = 0;
        while (i < this.waves.size()) {
            Wave wave = this.waves.get(i);
            long e = n.getTime() - wave.time;
            String target = wave.target;
            if (n.isDead(target)) {
                this.waves.remove(i--);
            } else {
                Position ep = n.getCurrentEnemyPosition(target);
                if (Rules.getBulletSpeed((double)wave.power) * (double)e >= ep.sub(wave.position).abs()) {
                    double gf = wave.getGuessFactor(ep);
                    this.data.add(new Data(gf));
                    double[] bins = this.binsMap.get(target);
                    int j = 0;
                    while (j < 31) {
                        int n2 = j;
                        bins[n2] = bins[n2] + 1.0 / (double)(1 + Math.abs(this.getIndex(gf) - j));
                        ++j;
                    }
                    this.waves.remove(i);
                    --i;
                }
            }
            ++i;
        }
        for (String s : this.binsMap.keySet()) {
            double[] bins = this.binsMap.get(s);
            int i2 = 0;
            while (i2 < 31) {
                double r = Math.pow(0.1, 2.8);
                int n3 = i2++;
                bins[n3] = bins[n3] * (1.0 - r);
            }
        }
    }

    int getIndex(double d) {
        return Math.min(30, Math.max(0, (int)(31.0 * (d + 1.0) / 2.0)));
    }

    @Override
    void fire(Nightmare n, double p) {
        String[] stringArray = n.getLivingEnemys();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String s = stringArray[n3];
            ScannedRobotEvent sre = n.enemys.get((Object)s).sre;
            this.waves.add(new Wave(n.getTime(), p, n.getPosition(), n.getCurrentEnemyPosition(s).sub(n.getPosition()).arg(), Utils.normalRelativeAngle((double)(sre.getHeadingRadians() - n.getCurrentEnemyPosition(s).sub(n.getPosition()).arg())) * sre.getVelocity() > 0.0 ? 1 : -1, s));
            ++n3;
        }
    }

    double getMaxEscapeAngle(double p) {
        return Math.asin(8.0 / Rules.getBulletSpeed((double)p));
    }

    class Data {
        private double guessFactor;

        Data(double gf) {
            this.guessFactor = gf;
        }
    }

    class Wave {
        private long time;
        private double power;
        private Position position;
        private double zero;
        private int sign;
        private String target;

        Wave(long t, double pw, Position ps, double z, int s, String tg) {
            this.time = t;
            this.power = pw;
            this.position = ps;
            this.zero = z;
            this.sign = s;
            this.target = tg;
        }

        double getGuessFactor(Position p) {
            return (double)this.sign * Utils.normalRelativeAngle((double)(p.sub(this.position).arg() - this.zero)) / GuessFactorTargeting.this.getMaxEscapeAngle(this.power);
        }
    }
}

