/*
 * Decompiled with CFR 0.152.
 */
package EFD;

import EFD.EFDUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import robocode.Bullet;
import robocode.Rules;

public class GunWave {
    public Point2D.Double origin;
    public double bulletPower;
    public long fireTime;
    public double bulletSpeed;
    public double distanceTraveled;
    public double enemyBearing;
    public Bullet bullet = null;
    public double[] data;
    private double enemyBearingOnHit;
    private double angleOffset = 0.0;
    private boolean hasPassed = false;
    private boolean onTarget;

    public GunWave(Point2D.Double origin, double bulletPower, long fireTime, double enemyBearing, double[] data) {
        this.origin = origin;
        this.bulletPower = bulletPower;
        this.fireTime = fireTime;
        this.distanceTraveled = this.bulletSpeed = Rules.getBulletSpeed((double)bulletPower);
        this.enemyBearing = enemyBearing;
        this.data = data;
    }

    public GunWave(Bullet bullet, long fireTime, double enemyBearing, double[] data) {
        this.bullet = bullet;
        this.origin = new Point2D.Double(bullet.getX(), bullet.getY());
        this.bulletPower = bullet.getPower();
        this.fireTime = fireTime;
        this.distanceTraveled = this.bulletSpeed = Rules.getBulletSpeed((double)this.bulletPower);
        this.enemyBearing = enemyBearing;
        this.data = data;
    }

    public boolean hasPassedEnemy(Point2D.Double enemyPosition, long currentTime) {
        if (this.origin.distance(enemyPosition) <= (double)(currentTime - this.fireTime) * this.bulletSpeed) {
            this.hasPassed = true;
            return true;
        }
        return false;
    }

    public void missEnemy(Point2D.Double enemyPosition) {
        this.enemyBearingOnHit = EFDUtils.absoluteAngle(this.origin, enemyPosition);
        this.angleOffset = EFDUtils.normaliseAngle(this.enemyBearingOnHit - this.enemyBearing);
        this.hasPassed = true;
        this.onTarget = false;
    }

    public void hitEnemy(Point2D.Double enemyPosition) {
        this.enemyBearingOnHit = EFDUtils.absoluteAngle(this.origin, enemyPosition);
        this.angleOffset = EFDUtils.normaliseAngle(this.enemyBearingOnHit - this.enemyBearing);
        this.hasPassed = true;
        this.onTarget = true;
    }

    public boolean isOnTarget() {
        return this.onTarget;
    }

    public boolean hasPassed() {
        return this.hasPassed;
    }

    public double getEnemyBearingOnHit() {
        return this.enemyBearingOnHit;
    }

    public double getAngleOffset() {
        return this.angleOffset;
    }

    public void paint(Graphics g, Color c, long currentTime) {
        Color oldColor = g.getColor();
        if (this.bullet != null) {
            Point2D.Double bPos = EFDUtils.projectPoint(this.origin, this.bullet.getHeadingRadians(), this.distanceTraveled);
            g.setColor(Color.gray);
            g.drawLine((int)this.origin.x, (int)this.origin.y, (int)bPos.x, (int)bPos.y);
        }
        g.setColor(c);
        g.drawOval((int)(this.origin.x - this.distanceTraveled), (int)(this.origin.y - this.distanceTraveled), (int)this.distanceTraveled * 2, (int)this.distanceTraveled * 2);
        g.setColor(oldColor);
    }
}

