/*
 * Decompiled with CFR 0.152.
 */
package EFD;

import EFD.AdvancedEFD;
import EFD.GunWave;
import EFD.LogEntry;
import EFD.MovementWave;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class Statistics {
    public static final int NUM_DIMENSIONS = 10;
    private AdvancedEFD r;
    public ArrayList<LogEntry> log = new ArrayList();
    public ArrayList<MovementWave> currentMovementWaves = new ArrayList();
    public ArrayList<MovementWave> movementWaves = new ArrayList();
    public ArrayList<GunWave> gunWaves = new ArrayList();
    public static ArrayList<double[]> gunLog = new ArrayList();
    public static HashMap<double[], GunWave> gunLogToWave = new HashMap();
    public static ArrayList<double[]> movementLog = new ArrayList();
    public static HashMap<double[], MovementWave> movementLogToWave = new HashMap();
    public static int bulletsHit = 0;
    public static int bulletsShot = 0;
    public static int hitByBullets = 0;
    public static int enemyBulletsShot = 0;
    public static int wallHits = 0;
    public static final double[] movementWeights = new double[]{0.0, 2.0, 1.0, 3.0, 5.0, 2.0, 1.0, 2.0, 1.0, 0.0};
    public static final double[] targetingWeights = new double[]{1.0, 2.0, 1.0, 2.0, 3.0, 2.0, 3.0, 1.0, 0.0, 0.0};

    public Statistics(AdvancedEFD r) {
        this.r = r;
    }

    public void update(ScannedRobotEvent e) {
        this.log.add(0, new LogEntry(e, this.r));
        this.updateGunWaves();
        this.updateCurrentMovementWaves();
    }

    public void registerHitByBullet(HitByBulletEvent e) {
        ++hitByBullets;
        if (!this.currentMovementWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            MovementWave hitWave = null;
            int x = 0;
            while (x < this.currentMovementWaves.size()) {
                MovementWave ew = this.currentMovementWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this.r.position.distance(ew.origin)) < 30.0 && Math.abs(Rules.getBulletSpeed((double)e.getBullet().getPower()) - ew.getBulletSpeed()) < 0.001) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logMovementHit(hitWave, hitBulletLocation);
                this.currentMovementWaves.remove(this.currentMovementWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void logMovementHit(MovementWave wave, Point2D.Double position) {
        wave.hit(position);
        movementLog.add(0, wave.data);
        movementLogToWave.put(wave.data, wave);
        this.movementWaves.add(wave);
    }

    public void logMovementMiss(MovementWave wave, Point2D.Double position) {
        wave.miss(position);
    }

    public void registerBulletHit(BulletHitEvent e) {
        ++bulletsHit;
        if (!this.gunWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            Point2D.Double enemyPosition = this.log.get((int)0).enemyPosition;
            GunWave hitWave = null;
            int x = 0;
            while (x < this.gunWaves.size()) {
                GunWave ew = this.gunWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this.r.position.distance(hitBulletLocation)) < 50.0 && Math.abs(Rules.getBulletSpeed((double)e.getBullet().getPower()) - ew.bulletSpeed) < 0.001) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logGunHit(hitWave, enemyPosition);
                this.gunWaves.remove(this.gunWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void logGunMiss(GunWave wave, Point2D.Double targetLocation) {
        wave.missEnemy(targetLocation);
        gunLog.add(0, wave.data);
        gunLogToWave.put(wave.data, wave);
    }

    public void logGunHit(GunWave wave, Point2D.Double targetLocation) {
        wave.hitEnemy(targetLocation);
        gunLog.add(0, wave.data);
        gunLogToWave.put(wave.data, wave);
    }

    public void displayStats() {
        System.out.println("BulletsHit: " + bulletsHit);
        System.out.println("BulletsShot: " + bulletsShot);
        System.out.println("HitByBullets: " + hitByBullets);
        System.out.println("enemyBulletsShot: " + enemyBulletsShot);
        System.out.println("wallHits: " + wallHits);
    }

    public void updateGunWaves() {
        int i = 0;
        while (i < this.gunWaves.size()) {
            GunWave currentWave = this.gunWaves.get(i);
            currentWave.distanceTraveled = (double)(this.r.getTime() - currentWave.fireTime) * currentWave.bulletSpeed;
            if (currentWave.hasPassedEnemy(this.log.get((int)0).enemyPosition, this.r.getTime())) {
                this.logGunMiss(currentWave, this.log.get((int)0).enemyPosition);
                this.gunWaves.remove(currentWave);
                --i;
            }
            ++i;
        }
    }

    public void updateCurrentMovementWaves() {
        int i = 0;
        while (i < this.currentMovementWaves.size()) {
            MovementWave currentWave = this.currentMovementWaves.get(i);
            currentWave.update(this.r.getTime());
            if (currentWave.hasPassed(this.log.get((int)0).position)) {
                this.logMovementMiss(currentWave, this.log.get((int)0).position);
                this.currentMovementWaves.remove(currentWave);
                --i;
            }
            ++i;
        }
        this.r.waveSurfing.paintWaves();
    }

    public double[] createMovementDatapoint(double bulletPower) {
        LogEntry l1 = this.log.get(1);
        LogEntry l2 = this.log.get(2);
        double distance = l2.position.distance(l1.enemyPosition);
        double cornerDistance = Math.sqrt(Math.pow(Math.min(l2.position.x, this.r.getBattleFieldWidth() - l2.position.x) - 17.0, 2.0) + Math.pow(Math.min(l2.position.y, this.r.getBattleFieldHeight() - l2.position.y) - 17.0, 2.0));
        double wallDistance = Math.min(Math.min(l2.position.x, this.r.getBattleFieldWidth() - l2.position.x) - 17.0, Math.min(l2.position.y, this.r.getBattleFieldHeight() - l2.position.y) - 17.0);
        double acceleration = this.log.size() > 4 ? l2.velocity - this.log.get((int)3).velocity : 0.0;
        double lateralVelocity = l2.getLateralVelocity();
        double advancingVelocity = l2.getAdvancingVelocity();
        double lateralVelocityL8T = lateralVelocity;
        int i = 3;
        while (i < Math.min(this.log.size(), 9)) {
            lateralVelocityL8T += this.log.get(i).getLateralVelocity();
            ++i;
        }
        double advancingVelocityL8T = advancingVelocity;
        i = 3;
        while (i < Math.min(this.log.size(), 9)) {
            advancingVelocityL8T += this.log.get(i).getAdvancingVelocity();
            ++i;
        }
        double energy = l2.energy;
        distance /= this.r.MAX_DISTANCE;
        cornerDistance /= this.r.MAX_CORNER_DISTANCE;
        wallDistance /= this.r.MAX_WALL_DISTANCE;
        acceleration = (acceleration + 2.0) / 4.0;
        lateralVelocity = (lateralVelocity + 8.0) / 16.0;
        advancingVelocity = (advancingVelocity + 8.0) / 16.0;
        lateralVelocityL8T = (lateralVelocityL8T + 64.0) / 128.0;
        advancingVelocityL8T = (advancingVelocityL8T + 64.0) / 128.0;
        double bPower = bulletPower / 3.0;
        return new double[]{distance, cornerDistance, wallDistance, acceleration, lateralVelocity, advancingVelocity, lateralVelocityL8T, advancingVelocityL8T, energy /= 100.0, bPower};
    }

    public double[] createTargetingDatapoint(double bulletPower) {
        LogEntry l = this.log.get(0);
        double enemyDistance = l.position.distance(l.enemyPosition);
        double enemyCornerDistance = Math.sqrt(Math.pow(Math.min(l.enemyPosition.x, this.r.getBattleFieldWidth() - l.enemyPosition.x) - 17.0, 2.0) + Math.pow(Math.min(l.enemyPosition.y, this.r.getBattleFieldHeight() - l.enemyPosition.y) - 17.0, 2.0));
        double enemyWallDistance = Math.min(Math.min(l.enemyPosition.x, this.r.getBattleFieldWidth() - l.enemyPosition.x) - 17.0, Math.min(l.enemyPosition.y, this.r.getBattleFieldHeight() - l.enemyPosition.y) - 17.0);
        double enemyAcceleration = this.log.size() > 1 ? l.enemyVelocity - this.log.get((int)1).enemyVelocity : 0.0;
        double enemyLateralVelocity = l.getEnemyLateralVelocity();
        double enemyAdvancingVelocity = l.getEnemyAdvancingVelocity();
        double enemyLateralVelocityL8T = enemyLateralVelocity;
        int i = 1;
        while (i < Math.min(this.log.size(), 7)) {
            enemyLateralVelocityL8T += this.log.get(i).getEnemyLateralVelocity();
            ++i;
        }
        double enemyAdvancingVelocityL8T = enemyAdvancingVelocity;
        i = 1;
        while (i < Math.min(this.log.size(), 7)) {
            enemyAdvancingVelocityL8T += this.log.get(i).getEnemyAdvancingVelocity();
            ++i;
        }
        double enemyEnergy = l.enemyEnergy;
        enemyDistance /= this.r.MAX_DISTANCE;
        enemyCornerDistance /= this.r.MAX_CORNER_DISTANCE;
        enemyWallDistance /= this.r.MAX_WALL_DISTANCE;
        enemyAcceleration = (enemyAcceleration + 2.0) / 4.0;
        enemyLateralVelocity = (enemyLateralVelocity + 8.0) / 16.0;
        enemyAdvancingVelocity = (enemyAdvancingVelocity + 8.0) / 16.0;
        enemyLateralVelocityL8T = (enemyLateralVelocityL8T + 64.0) / 128.0;
        enemyAdvancingVelocityL8T = (enemyAdvancingVelocityL8T + 64.0) / 128.0;
        double bPower = bulletPower / 3.0;
        return new double[]{enemyDistance, enemyCornerDistance, enemyWallDistance, enemyAcceleration, enemyLateralVelocity, enemyAdvancingVelocity, enemyLateralVelocityL8T, enemyAdvancingVelocityL8T, enemyEnergy /= 100.0, bPower};
    }

    public void printDataPoint(double[] data) {
        System.out.println("enemyDistance: " + data[0]);
        System.out.println("enemyCornerDistance: " + data[1]);
        System.out.println("enemyWallDistance: " + data[2]);
        System.out.println("enemyAcceleration: " + data[3]);
        System.out.println("enemyLateralVelocity: " + data[4]);
        System.out.println("enemyAdvancingVelocity: " + data[5]);
        System.out.println("enemyLateralVelocityL8T: " + data[6]);
        System.out.println("enemyAdvancingVelocityL8T: " + data[7]);
        System.out.println("enemyEnergy: " + data[8]);
        System.out.println("bulletPower: " + data[9]);
    }

    public double distanceSquared(double[] data1, double[] data2) {
        double d = Double.MAX_VALUE;
        int i = 0;
        while (i < Math.min(data1.length, data2.length)) {
            d += Math.pow(data1[i] - data2[i], 2.0);
            ++i;
        }
        return Math.sqrt(d);
    }

    public double weightedDistanceSquared(double[] data1, double[] data2, double[] weights) {
        double d = Double.MAX_VALUE;
        d = 0.0;
        int i = 0;
        while (i < Math.min(data1.length, data2.length)) {
            d += Math.pow(data1[i] - data2[i], 2.0) * weights[i];
            ++i;
        }
        return Math.sqrt(d);
    }

    public double[][] nearestNeighbors(ArrayList<double[]> allPoints, double[] currentPoint, int numNeighbors, int numDimensions, double[] weights) {
        numNeighbors = Math.min(numNeighbors, allPoints.size());
        double[][] nearestPoints = new double[numNeighbors][numDimensions];
        if (allPoints.isEmpty()) {
            return nearestPoints;
        }
        int i = 0;
        while (i < numNeighbors) {
            nearestPoints[i] = allPoints.get(i);
            ++i;
        }
        double[] nearestDistancesSq = new double[numNeighbors];
        nearestDistancesSq[0] = this.weightedDistanceSquared(currentPoint, nearestPoints[0], weights);
        double longestDistanceSq = nearestDistancesSq[0];
        int longestIndex = 0;
        int x = 1;
        while (x < numNeighbors) {
            nearestDistancesSq[x] = this.weightedDistanceSquared(currentPoint, nearestPoints[x], weights);
            if (nearestDistancesSq[x] > longestDistanceSq) {
                longestDistanceSq = nearestDistancesSq[x];
                longestIndex = x;
            }
            ++x;
        }
        int x2 = numNeighbors;
        while (x2 < allPoints.size()) {
            double thisDistanceSq = this.weightedDistanceSquared(currentPoint, allPoints.get(x2), weights);
            if (thisDistanceSq < longestDistanceSq) {
                nearestPoints[longestIndex] = allPoints.get(x2);
                nearestDistancesSq[longestIndex] = thisDistanceSq;
                longestDistanceSq = thisDistanceSq;
                int i2 = 0;
                while (i2 < nearestDistancesSq.length) {
                    if (nearestDistancesSq[i2] > longestDistanceSq) {
                        longestDistanceSq = nearestDistancesSq[i2];
                        longestIndex = i2;
                    }
                    ++i2;
                }
            }
            ++x2;
        }
        return nearestPoints;
    }
}

