/*
 * Decompiled with CFR 0.152.
 */
package demetrix.movement;

import demetrix.info.EnemyInfo;
import demetrix.info.SelfInfo;
import demetrix.misc.Const;
import demetrix.movement.Step;
import java.awt.geom.Point2D;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RTM {
    private static int STOPTIME_MIN = 16;
    private static int STOPTIME_MAX = 44;
    private static int MOVETIME_MIN = 4;
    private static int MOVETIME_MAX = 6;
    private static int CHANGETIME_MIN = 16;
    private static int CHANGETIME_MAX = 50;
    private double moveX;
    private double moveY;
    private double velocity;
    private int direction;
    private double TangentFactor;
    private int nextChangeTime;
    private int nextStopTime;
    private int nextMoveTime;
    private Random random;

    private final void doStop_n_Go(SelfInfo self, EnemyInfo enemy) {
        --this.nextStopTime;
        --this.nextMoveTime;
        if (enemy.getDistance() < 200.0) {
            this.velocity = 8.0;
            return;
        }
        if (this.nextStopTime <= 0) {
            this.velocity = 0.0;
            this.nextStopTime = STOPTIME_MIN + this.random.nextInt(STOPTIME_MAX - STOPTIME_MIN + 1);
            this.nextMoveTime = MOVETIME_MIN + this.random.nextInt(MOVETIME_MAX - MOVETIME_MIN + 1);
            return;
        }
        if (this.nextMoveTime <= 0) {
            this.velocity = 8.0;
        }
    }

    private final void selectTangent(SelfInfo self, EnemyInfo enemy) {
        double distance = enemy.getDistance();
        if (distance < 100.0) {
            this.TangentFactor = 1.8;
            return;
        }
        if (distance < 320.0) {
            this.TangentFactor = 1.2;
            return;
        }
        if (distance > 420.0) {
            this.TangentFactor = 0.8;
            return;
        }
        this.TangentFactor = 0.8 + 0.4 * this.random.nextDouble();
    }

    public Step execute(SelfInfo self, EnemyInfo enemy) {
        --this.nextChangeTime;
        double X = self.getPosition().getX();
        double Y = self.getPosition().getY();
        this.selectTangent(self, enemy);
        this.doStop_n_Go(self, enemy);
        if (this.nextChangeTime <= 0) {
            this.direction = -this.direction;
            this.nextChangeTime = CHANGETIME_MIN + this.random.nextInt(CHANGETIME_MAX - CHANGETIME_MIN + 1);
        }
        double tangent = enemy.getAbsoluteBearing() + (double)this.direction * Math.PI / (double)2 * this.TangentFactor;
        this.moveX = X + 80.0 * Math.sin(tangent);
        this.moveY = Y + 80.0 * Math.cos(tangent);
        if (Const.MOVING_FIELD.contains(this.moveX, this.moveY)) {
            return new Step(new Point2D.Double(this.moveX, this.moveY), this.velocity, this.direction);
        }
        double nextDirectionCW = tangent;
        double nextDirectionCCW = tangent;
        double totalAngle = 0.0;
        do {
            nextDirectionCW += 0.08;
            nextDirectionCCW -= 0.08;
            if ((totalAngle += 0.08) > Math.toRadians(45.0)) {
                this.direction = -this.direction;
                tangent = enemy.getAbsoluteBearing() + (double)this.direction * Math.PI / (double)2 * this.TangentFactor;
                this.moveX = X + 40.0 * Math.sin(tangent);
                this.moveY = Y + 40.0 * Math.cos(tangent);
                break;
            }
            this.moveX = X + 80.0 * Math.sin(nextDirectionCW);
            this.moveY = Y + 80.0 * Math.cos(nextDirectionCW);
            if (Const.MOVING_FIELD.contains(this.moveX, this.moveY)) break;
            this.moveX = X + 80.0 * Math.sin(nextDirectionCCW);
            this.moveY = Y + 80.0 * Math.cos(nextDirectionCCW);
        } while (!Const.MOVING_FIELD.contains(this.moveX, this.moveY));
        return new Step(new Point2D.Double(this.moveX, this.moveY), this.velocity, this.direction);
    }

    public void initiate() {
        this.direction = 2 * this.random.nextInt(2) - 1;
    }

    private final /* synthetic */ void this() {
        this.velocity = 8.0;
        this.TangentFactor = 1.0;
        this.nextChangeTime = 80;
        this.nextStopTime = 22;
        this.nextMoveTime = 0;
        this.random = new Random();
    }

    public RTM() {
        this.this();
    }
}

