/*
 * Decompiled with CFR 0.152.
 */
package gjr;

import gjr.EnemiesTrackingStrategy;
import gjr.Enemy;
import gjr.StrategyRobot;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Iterator;
import robocode.util.Utils;

public class AntigravityMovementStrategy
extends EnemiesTrackingStrategy {
    public AntigravityMovementStrategy(StrategyRobot robot) {
        this.setRobot(robot);
        this.enemies.put("Center Field", new Enemy("Center Field", robot.getBattleFieldWidth() / 2.0, robot.getBattleFieldHeight() / 2.0));
    }

    public void execute() {
        StrategyRobot robot = this.getRobot();
        Iterator keys = this.enemies.keySet().iterator();
        double xForce = 0.0;
        double yForce = 0.0;
        double totalDanger = 0.0;
        double myX = robot.getX();
        double myY = robot.getY();
        while (keys.hasNext()) {
            Enemy enemy = (Enemy)this.enemies.get(keys.next());
            double enemyX = enemy.getX();
            double enemyY = enemy.getY();
            double distance = Point2D.Double.distance(myX, myY, enemyX, enemyY);
            double force = enemy.getDanger() / Math.pow(distance, 2.0);
            double angle = Math.atan2(enemyX - myX, enemyY - myY);
            xForce -= force * Math.sin(angle);
            yForce -= force * Math.cos(angle);
            totalDanger += enemy.getDanger();
        }
        double goalHeadingRadians = Math.atan2(xForce, yForce);
        double goalDistance = 100.0;
        RoundRectangle2D.Double fieldRect = new RoundRectangle2D.Double(25.0, 25.0, robot.getBattleFieldHeight() - 50.0, robot.getBattleFieldWidth() - 50.0, 75.0, 75.0);
        while (!fieldRect.contains(myX + Math.sin(goalHeadingRadians) * goalDistance, myY + Math.cos(goalHeadingRadians) * goalDistance)) {
            goalHeadingRadians += goalHeadingRadians * 0.1;
        }
        double turn = Utils.normalRelativeAngle((double)(goalHeadingRadians - robot.getHeadingRadians()));
        if (Math.abs(turn) > 1.5707963267948966) {
            turn = Utils.normalRelativeAngle((double)(turn + Math.PI));
            robot.setBack(goalDistance);
        } else {
            robot.setAhead(goalDistance);
        }
        robot.setTurnRightRadians(turn);
    }
}

