/*
 * Decompiled with CFR 0.152.
 */
package gtf.robocode;

import gtf.robocode.Util;
import gtf.robocode.VectorPolar;

public class Vector2D {
    public double x;
    public double y;
    public static final Vector2D ZERO = new Vector2D(0.0, 0.0);

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D plus(Vector2D p2) {
        return new Vector2D(this.x + p2.x, this.y + p2.y);
    }

    public double norm() {
        return Util.norm(this.x, this.y);
    }

    public double bearingRadians() {
        if (this.y == 0.0) {
            if (this.x >= 0.0) {
                return 1.5707963267948966;
            }
            return -1.5707963267948966;
        }
        double theta = Math.atan(this.x / this.y);
        if (this.y < 0.0) {
            theta += Math.PI;
        }
        return Util.toBearingRadians(theta);
    }

    public Vector2D minus(Vector2D p2) {
        return new Vector2D(this.x - p2.x, this.y - p2.y);
    }

    public VectorPolar toPolar() {
        return new VectorPolar(this.norm(), this.bearingRadians());
    }

    public Vector2D times(double scalar) {
        return new Vector2D(scalar * this.x, scalar * this.y);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

