/*
 * Decompiled with CFR 0.152.
 */
package gtf.robocode.motor;

import gtf.robocode.Util;
import gtf.robocode.Vector2D;
import gtf.robocode.forcefield.ForceField;
import gtf.robocode.motor.Motor;
import robocode.AdvancedRobot;
import robocode.HitWallEvent;

class FieldMotor
extends Motor {
    protected ForceField field;

    FieldMotor(AdvancedRobot robot, ForceField field) {
        super(robot);
        this.field = field;
    }

    public void doMotion() {
        Vector2D force = this.field.getVector2D(this.robot.getX(), this.robot.getY());
        double oldHeading = this.robot.getHeading();
        double newHeading = Math.toDegrees(force.toPolar().theta);
        double speed = force.norm();
        System.out.println("heading " + newHeading + ", speed " + speed);
        this.robot.setAhead(speed);
        this.robot.setTurnRight(Util.normalize(newHeading - oldHeading));
    }

    public void onHitWall(HitWallEvent e) {
        double bearing = e.getBearing();
        if (0.0 <= bearing) {
            this.robot.setTurnLeft(180.0 - 2.0 * bearing);
        } else {
            this.robot.setTurnRight(180.0 + 2.0 * bearing);
        }
    }
}

