/*
 * Decompiled with CFR 0.152.
 */
package jaybot.guns;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jaybot.bots.BaseBot;
import jaybot.intel.Enemy;

public class VirtualBullet {
    private Enemy _$2170;
    private Point2D _$2171;
    private double _$2172;
    private double _$2143;
    private Point2D _$2173;
    private double _$2174;
    private double _$2175;
    private double _$2176;
    private double _$2177;
    private int _$2178 = 0;
    private BaseBot _$1144 = null;
    public static final int SHOT_AHEAD = 0;
    public static final int SHOT_LINEAR_FRONT = 1;
    public static final int SHOT_LINEAR_BACK = -1;

    public VirtualBullet(BaseBot myBot, Enemy shooter, Point2D origin, double shotTime, double shotPower, Point2D targetActual, double targetHeading, double targetVelocity, int shotType) {
        this._$1144 = myBot;
        this._$2170 = shooter;
        this._$2171 = origin;
        this._$2172 = shotTime;
        this._$2143 = shotPower;
        this._$2173 = targetActual;
        this._$2174 = targetHeading;
        this._$2175 = targetVelocity;
        this._$2176 = BaseBot.getBulletVelocityFromPower(shotPower);
        this._$2177 = BaseBot.getAngleBetweenPointsInDegrees(origin, targetActual);
        this._$2178 = shotType;
        this._$2171 = BaseBot.projectPointInSpace(origin, this._$2177, 20.0);
    }

    public double getScore() {
        int cnt = 0;
        switch (this._$2178) {
            case 0: {
                cnt = this._$2170.getVirtualHitWeightAhead();
                break;
            }
            case 1: {
                cnt = this._$2170.getVirtualHitWeightFront();
                break;
            }
            case -1: {
                cnt = this._$2170.getVirtualHitWeightBack();
            }
        }
        return cnt;
    }

    public Point2D getPositionAt(double time) {
        return this.getPositionAt(time, false);
    }

    public int getShotType() {
        return this._$2178;
    }

    protected Point2D getPositionAt(double time, boolean boundsCheck) {
        Point2D answer = BaseBot.projectPointInTime(this._$2171, this._$2177, this._$2176, time - this._$2172);
        if (boundsCheck && !this._$1144.getFieldRect().contains(answer.getX(), answer.getY())) {
            answer = null;
        }
        return answer;
    }

    public double getHeading() {
        return this._$2177;
    }

    public Point2D getOrigin() {
        return this._$2171;
    }

    public boolean isInLineOfFire(Point2D unsafePt, double time) {
        if (this.isDead(time)) {
            return false;
        }
        double avgBot = Math.max(this._$1144.getWidth(), this._$1144.getHeight());
        if (this._$2171.distance(unsafePt) < this._$2171.distance(this.getPositionAt(time)) - avgBot - 10.0) {
            return false;
        }
        avgBot = avgBot / 2.0 + 2.0;
        Rectangle2D.Double unsafeRect = new Rectangle2D.Double(unsafePt.getX() - avgBot, unsafePt.getY() - avgBot, unsafePt.getX() + avgBot, unsafePt.getY() + avgBot);
        Point2D futureShotPt = BaseBot.projectPointInTime(this._$2171, this._$2177, this._$2176, time - this._$2172 + 500.0);
        return unsafeRect.intersectsLine(this._$2171.getX(), this._$2171.getY(), futureShotPt.getX(), futureShotPt.getY());
    }

    public boolean isDead(double time) {
        return this.getPositionAt(time, true) == null;
    }

    public double timeToImpact(Point2D unsafePt, double time) {
        double distance = this.distanceToPoint(unsafePt, time);
        if (distance != Double.NEGATIVE_INFINITY) {
            return distance / this._$2176;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double distanceToPoint(Point2D unsafePt, double time) {
        Point2D futureShotPt = BaseBot.projectPointInTime(this._$2171, this._$2177, this._$2176, time - this._$2172);
        return futureShotPt.distance(unsafePt);
    }
}

