/*
 * Decompiled with CFR 0.152.
 */
package jaybot.tactics;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import jaybot.bots.BaseBot;
import jaybot.guns.FiringSolution;
import jaybot.guns.Gun;
import jaybot.guns.GunAccuracyComparator;
import jaybot.intel.Enemy;
import jaybot.tactics.BasePersonality;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class OutaCenterPersonality
extends BasePersonality {
    protected double moveDirection = 1.0;
    protected Enemy currentTarget = null;
    private static final boolean _$827 = false;
    private static final double _$855 = 45.0;
    private static final double _$856 = 55.0;
    private static final double _$879 = 75.0;
    protected String whichGun = "Linear";
    protected int useGunCount = 0;

    public void doStartupAction() {
        this.myBot.setColors(this.myBot.getTankColor(), this.myBot.getGunColor(), Color.black);
        this.myBot.setAdjustGunForRobotTurn(false);
        this.myBot.setAdjustRadarForGunTurn(false);
    }

    public void doRunIteration() {
        this.myBot.turnRadarRight(360.0);
        this.doGravity();
    }

    public void reactToAnotherRobotDeath(RobotDeathEvent event, Enemy deadBadGuy) {
        if (deadBadGuy == this.currentTarget) {
            this.currentTarget = null;
        }
    }

    public void reactToBulletHitAnotherBullet(BulletHitBulletEvent event, Enemy ownerOfOtherBullet, Enemy intendedTarget) {
    }

    public void reactToBulletHitTarget(BulletHitEvent event, Enemy actualTarget, Enemy intendedTarget) {
    }

    public void reactToBulletMissedTarget(BulletMissedEvent event, Enemy intendedTarget) {
    }

    protected double calcTurnDegrees(Point2D fromPoint, Point2D targetPoint, double currentHeading) {
        return BaseBot.normalizeRelativeAngleDegrees(BaseBot.getAngleBetweenPointsInDegrees(fromPoint, targetPoint) - currentHeading);
    }

    public void reactToSeeingEnemyRobot(ScannedRobotEvent event, Enemy badGuy) {
        double maxFirePower;
        if (this.currentTarget == null && this.currentTarget != badGuy) {
            this.currentTarget = badGuy;
        }
        Enemy holdTarget = this.currentTarget;
        Point2D myPos = this.myBot.getTankPosition();
        if (holdTarget != null && holdTarget.hasKnownPosition() && badGuy.hasKnownPosition()) {
            boolean switchTargets;
            double eDistanceToMe = badGuy.getLastPosition().distance(myPos);
            double targetDistance = holdTarget.getLastPosition().distance(myPos);
            boolean bl = switchTargets = targetDistance > 200.0 && (eDistanceToMe < 150.0 || eDistanceToMe + 100.0 < targetDistance);
            if (switchTargets && this.currentTarget != badGuy) {
                holdTarget = badGuy;
                this.currentTarget = badGuy;
            }
        }
        if (badGuy == holdTarget && this.shootAtCurrentTarget(holdTarget, maxFirePower = 3.0)) {
            this.myBot.stop();
        }
    }

    protected static double getBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        return Math.atan2(xo, yo);
    }

    protected void doGravity() {
        double bearingTotal = 0.0;
        double bearingCount = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double fWidth = this.myBot.getFieldRect().getWidth();
        double fHeight = this.myBot.getFieldRect().getHeight();
        double radius = Math.min(fWidth, fHeight) * 0.7;
        long time = this.myBot.getTime();
        Point2D myPos = this.myBot.getTankPosition();
        double myX = myPos.getX();
        double myY = myPos.getY();
        double fx = 0.0;
        double fy = 0.0;
        double factorCount = 0.0;
        boolean doCenter = false;
        Iterator i = this.myBot.getOpponentTracker().getAliveEnemies().iterator();
        while (i.hasNext() || doCenter) {
            Point2D ePos;
            Enemy e = null;
            if (i.hasNext()) {
                e = (Enemy)i.next();
                if (!e.hasKnownPosition()) continue;
                ePos = e.getLastPosition();
            } else {
                ePos = this.myBot.getFieldCenter();
            }
            if (!doCenter) {
                bearingTotal += BaseBot.getAngleBetweenPointsInDegrees(myPos, ePos);
                dx += ePos.getX();
                dy += ePos.getY();
                bearingCount += 1.0;
            }
            if (this.myBot.nearWall(ePos, 50.0)) {
                double ex = ePos.getX();
                double ey = ePos.getY();
                if (ex < 50.0) {
                    ex = -75.0;
                }
                if (ex > fWidth - 50.0) {
                    ex = fWidth + 75.0;
                }
                if (ey < 50.0) {
                    ey = -75.0;
                }
                if (ey > fHeight - 50.0) {
                    ey = fWidth + 75.0;
                }
                ePos.setLocation(ex, ey);
            }
            double baseForce = 300.0;
            if (doCenter) {
                baseForce /= 2.0;
            }
            double force = Math.max(0.0, baseForce - myPos.distance(ePos)) / baseForce * 75.0;
            double angle = OutaCenterPersonality.getBearing(myX, myY, ePos.getX(), ePos.getY());
            if (force > 0.0) {
                fx -= force * Math.sin(angle);
                fy -= force * Math.cos(angle);
                factorCount += 1.0;
            }
            if (!i.hasNext() && !doCenter) {
                doCenter = true;
                continue;
            }
            if (i.hasNext()) continue;
            doCenter = false;
        }
        if (factorCount > 0.0) {
            fx /= factorCount;
            fy /= factorCount;
        }
        myX += fx;
        myY += fy;
        double absTotal = Math.abs(fx) + Math.abs(fy);
        double bearingAverage = this.myBot.headingToBearingDegrees(bearingTotal / bearingCount);
        Point2D.Double mass = new Point2D.Double(dx / bearingCount, dy / bearingCount);
        if (absTotal > 20.0) {
            double delta;
            this.myBot.logDetail("Forces: " + dblfmt.format(fx) + ", " + dblfmt.format(fy) + "   =    " + dblfmt.format(myX) + ", " + dblfmt.format(myY));
            double buffer = 100.0;
            if (myX < buffer) {
                delta = buffer - myX;
                myX = buffer + delta;
            }
            if (myY < buffer) {
                delta = buffer - myY;
                myY = buffer + delta;
            }
            if (myX > fWidth - buffer) {
                delta = myX - (fWidth - buffer);
                myX = fWidth - buffer - delta;
            }
            if (myY > fHeight - buffer) {
                delta = myY - (fHeight - buffer);
                myY = fHeight - buffer - delta;
            }
            Point2D goPt = new Point2D.Double(myX, myY);
            double headingToGo = BaseBot.getAngleBetweenPointsInDegrees(myPos, goPt);
            double distanceToGo = myPos.distance(goPt);
            double headingToMass = BaseBot.getAngleBetweenPointsInDegrees(myPos, mass);
            if (Math.abs(BaseBot.normalizeRelativeAngleDegrees(headingToGo - headingToMass)) < 10.0) {
                this.myBot.logDetail("angle reflecting back into the mass");
            }
            double amount = 100.0 + (double)new Random().nextInt(30) - 15.0;
            goPt = BaseBot.projectPointInSpace(goPt, headingToGo, Math.min(distanceToGo, amount));
            this.myBot.moveTank(goPt);
        } else {
            this.myBot.logDetail("scoot");
            this.moveAndScoot(mass, bearingAverage, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void moveAndScoot(Point2D mass, double bearingAverage, boolean doReversals) {
        block12: {
            myPos = this.myBot.getTankPosition();
            sign = this.myBot.getSign(bearingAverage);
            doubleMovement = false;
            if (!doReversals) break block12;
            if (!this.myBot.nearWall(myPos, 30.0)) ** GOTO lbl-1000
            v0 = this.myBot.getFieldCenter();
            v1 = this.myBot.getHeading();
            v2 = this.moveDirection < 0.0 ? 180 : 0;
            if (Math.abs(this.calcTurnDegrees(myPos, v0, v1 + (double)v2)) > 90.0) {
                this.moveDirection = -1.0 * this.moveDirection;
                doubleMovement = true;
                this.myBot.logDetail("Near wall reversal");
            } else if (this.myBot.getOthers() >= 1) {
                v3 = this.myBot.getHeading();
                v4 = this.moveDirection < 0.0 ? 180 : 0;
                if (Math.abs(this.calcTurnDegrees(myPos, mass, v3 + (double)v4)) < 30.0) {
                    this.moveDirection = -1.0 * this.moveDirection;
                    this.myBot.logDetail("Pointing towards center mass reversal");
                }
            }
        }
        turnAmount = 10.0 - (double)new Random().nextInt(20);
        centerRadius = Math.min(this.myBot.getFieldRect().getWidth(), this.myBot.getFieldRect().getHeight()) / 2.0 - 50.0;
        idealDistance = centerRadius * 0.8;
        if (myPos.distance(this.myBot.getFieldCenter()) > centerRadius) {
            bearingAverage = this.myBot.headingToBearingDegrees(BaseBot.getAngleBetweenPointsInDegrees(myPos, this.myBot.getFieldCenter()));
            turnAmount += 25.0;
        } else if (myPos.distance(this.myBot.getFieldCenter()) < centerRadius * 0.7) {
            bearingAverage = this.myBot.headingToBearingDegrees(BaseBot.getAngleBetweenPointsInDegrees(myPos, this.myBot.getFieldCenter()));
            turnAmount -= 25.0;
        } else if (myPos.distance(mass) < idealDistance) {
            turnAmount -= 10.0;
        } else if (myPos.distance(mass) > idealDistance) {
            turnAmount += 10.0;
        }
        turnBearing = BaseBot.normalizeRelativeAngleDegrees(bearingAverage - (double)sign * (90.0 - turnAmount * this.moveDirection));
        turnBearing = Math.min(Math.max(turnBearing, -45.0), 45.0);
        moveAmount = this.moveDirection * (55.0 + (double)new Random().nextInt(40));
        if (doubleMovement) {
            moveAmount *= 1.6;
        }
        this.myBot.turnTankToBearingDegrees(turnBearing);
        this.myBot.ahead(moveAmount);
    }

    protected boolean shootAtCurrentTarget(Enemy shootTarget, double maxFirePower) {
        FiringSolution solution = null;
        if (!shootTarget.hasKnownPosition()) {
            return false;
        }
        double distance = this.myBot.getTankPosition().distance(shootTarget.getLastPosition());
        if (this.useGunCount >= 1) {
            ArrayList<Gun> gunlist = new ArrayList<Gun>();
            gunlist.add(shootTarget.getGunByName("Linear"));
            gunlist.add(shootTarget.getGunByName("Linear"));
            gunlist.add(shootTarget.getGunByName("Ahead"));
            Collections.sort(gunlist, new GunAccuracyComparator(true));
            int decision = new Random().nextInt(100);
            this.whichGun = decision <= 50 ? ((Gun)gunlist.get(0)).getGunName() : (decision <= 85 ? ((Gun)gunlist.get(1)).getGunName() : ((Gun)gunlist.get(2)).getGunName());
            this.useGunCount = 0;
        }
        Gun gun = null;
        gun = this.whichGun.equals("Linear") ? shootTarget.getGunByName("Linear") : (this.whichGun.equals("Lag") ? shootTarget.getGunByName("Lag") : shootTarget.getGunByName("Ahead"));
        double power = 1.73;
        power = gun.getRunningShotAccuracy() > 50.0 ? 3.0 : (gun.getRunningShotAccuracy() > 30.0 ? 2.2 : 1.73);
        if (distance > 300.0) {
            power = Math.min(0.3, power);
        }
        if (this.myBot.getOthers() > 3) {
            power = 3.0;
        }
        power = Math.min(power, maxFirePower);
        solution = gun.buildFiringSolution(this.myBot, shootTarget, power);
        boolean didFire = false;
        if (solution != null) {
            this.myBot.logTactical("Scan :: " + solution.toString() + ", movement reliability=" + shootTarget.getMovementReliability());
            if (this.myBot.fireBullet(solution, true)) {
                ++this.useGunCount;
                didFire = true;
            }
        } else {
            this.myBot.logTactical("Scan :: cannot determine firing solution for some reason (gun chose not to fire?)");
            ++this.useGunCount;
        }
        return didFire;
    }

    public void reactToYouCollidedWithEnemyRobot(HitRobotEvent event, Enemy badGuy) {
        this.currentTarget = badGuy;
        this.myBot.turnGunToBearingDegrees(event.getBearing());
        this.myBot.fireBulletWithoutGun(event.getName(), 3.0, 20.0);
        if (event.isMyFault()) {
            this.moveDirection = -1.0 * this.moveDirection;
        }
        double moveAmount = this.moveDirection * (55.0 + (double)new Random().nextInt(30)) * 2.0;
        this.myBot.ahead(moveAmount);
        this.myBot.turnRight(30.0);
        this.myBot.ahead(moveAmount / 2.0);
        this.myBot.turnRight(30.0);
        this.myBot.ahead(moveAmount / 2.0);
    }

    public void reactToYouHitByEnemyBullet(HitByBulletEvent event, Enemy badGuy) {
    }

    public void reactToYouHitWall(HitWallEvent event) {
    }
}

