/*
 * Decompiled with CFR 0.152.
 */
package jaybot.tactics;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import jaybot.bots.BaseBot;
import jaybot.guns.FiringSolution;
import jaybot.guns.Gun;
import jaybot.guns.GunAccuracyComparator;
import jaybot.guns.TargetFocus;
import jaybot.intel.Enemy;
import jaybot.tactics.BasePersonality;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class UnoKillerPersonality
extends BasePersonality
implements TargetFocus {
    private static final double _$826 = 66.0;
    private static double _$828 = 350.0;
    private static final double _$829 = 250.0;
    private static final double _$830 = 250.0;
    private static final double _$831 = 50.0;
    private static final double _$832 = 77.0;
    private static final double _$833 = 175.0;
    private static final double _$834 = 250.0;
    protected Point2D crowdCenterOfGravity = null;
    protected int scanCount = 0;
    protected int moveDirection = 1;
    protected Point2D tankPositionAtScanStart = null;
    protected Enemy currentTarget = null;
    protected long lastScanTime = 0L;
    protected String whichGun = "Linear";
    protected int useGunCount = 0;

    public Point2D getAimingPosition() {
        return this.tankPositionAtScanStart;
    }

    public Enemy getCurrentTarget() {
        return this.currentTarget;
    }

    public double getSweetSpotForDistance() {
        return 250.0;
    }

    public void doStartupAction() {
        this.myBot.setColors(this.myBot.getTankColor(), this.myBot.getGunColor(), Color.black);
        this.crowdCenterOfGravity = this.myBot.getFieldCenter();
        this.myBot.setAdjustGunForRobotTurn(true);
        this.myBot.setAdjustRadarForGunTurn(true);
        _$828 = this.crowdCenterOfGravity.getX() - 75.0;
    }

    public void doRunIteration() {
        this.myBot.turnRadarRight(Double.POSITIVE_INFINITY);
    }

    protected double calcTurnDegrees(Point2D targetPoint, double currentHeading) {
        return this.calcTurnDegrees(this.tankPositionAtScanStart, targetPoint, currentHeading);
    }

    protected double calcTurnDegrees(Point2D fromPoint, Point2D targetPoint, double currentHeading) {
        return BaseBot.normalizeRelativeAngleDegrees(BaseBot.getAngleBetweenPointsInDegrees(fromPoint, targetPoint) - currentHeading);
    }

    protected void reverseDirection() {
        this.moveDirection *= -1;
    }

    public void reactToYouHitByEnemyBullet(HitByBulletEvent event, Enemy badGuy) {
        if (new Random().nextInt(10) < 1) {
            this.reverseDirection();
        }
    }

    public void reactToYouHitWall(HitWallEvent event) {
        this.reverseDirection();
    }

    public void reactToYouCollidedWithEnemyRobot(HitRobotEvent event, Enemy badGuy) {
        this.currentTarget = badGuy;
        this.myBot.stop();
        double gunToCollisionAngle = BaseBot.diffBetweenRelativeAnglesDegrees(this.myBot.getGunBearingInDegrees(), event.getBearing());
        if (Math.abs(gunToCollisionAngle) < 20.0) {
            if (this.myBot.getGunHeat() <= 0.0) {
                this.myBot.fireBulletWithoutGun(event.getName(), 3.0, 1.0);
            }
        } else if (Math.abs(gunToCollisionAngle) < 45.0) {
            this.myBot.turnGunToBearingDegrees(event.getBearing());
            if (this.myBot.getGunHeat() <= 0.0) {
                this.myBot.fireBulletWithoutGun(event.getName(), 3.0, 1.0);
            }
        }
        this.myBot.resume();
        if (event.isMyFault()) {
            this.myBot.back(new Random().nextInt(50) + 50);
        } else {
            double absBearing = Math.abs(event.getBearing());
            int multiplier = 1;
            if (new Random().nextInt(2) == 1) {
                multiplier = -1;
            }
            if (absBearing <= 45.0) {
                this.myBot.back(new Random().nextInt(50) + 50);
                this.myBot.turnTankToBearingDegrees(75 * multiplier);
                this.myBot.ahead(150.0);
            } else if (absBearing >= 135.0) {
                this.myBot.ahead(new Random().nextInt(50) + 50);
                this.myBot.turnTankToBearingDegrees(75 * multiplier);
                this.myBot.ahead(150.0);
            } else if (event.getBearing() < 0.0) {
                this.myBot.turnTankToBearingDegrees(event.getBearing() + 90.0);
                this.myBot.ahead(new Random().nextInt(75) + 50);
            } else {
                this.myBot.turnTankToBearingDegrees(event.getBearing() - 90.0);
                this.myBot.ahead(new Random().nextInt(75) + 50);
            }
        }
    }

    public void reactToSeeingEnemyRobot(ScannedRobotEvent event, Enemy badGuy) {
        if (this.scanCount == 0) {
            this.tankPositionAtScanStart = this.myBot.getTankPosition();
        }
        ++this.scanCount;
        if (this.scanCount >= (this.myBot.getOthers() + 2) / 2) {
            this.scanCount = 0;
        }
        this.currentTarget = badGuy;
        if (this.myBot.getOpponentTracker().getTrackedAliveCompetitorCount() > 1) {
            this.pick();
        }
        if (this.currentTarget != null && this.myBot.getGunHeat() > 0.0) {
            double gunBearing = this.myBot.headingToBearingDegrees(BaseBot.getAngleBetweenPointsInDegrees(this.tankPositionAtScanStart, this.currentTarget.getLastPosition()));
            this.myBot.turnGunToBearingDegrees(gunBearing);
        }
        if (this.currentTarget != null && this.myBot.getGunHeat() < 0.15 && this.myBot.getEnergy() > 0.1) {
            long time = this.myBot.getTime();
            long lastShot = this.currentTarget.getLastShotMeTime();
            if (this.myBot.getOthers() > 1 || this.currentTarget.getLastKnownEnergy() == 0.0 || this.myBot.getEnergy() < this.currentTarget.getLastKnownEnergy() || this.myBot.getEnergy() > this.currentTarget.getLastKnownEnergy() + 20.0 || this.currentTarget.getLastCollisionTime() + 80L > time) {
                this.shootAtCurrentTarget();
            }
        }
        if (this.currentTarget != null && this.currentTarget.hasKnownPosition() && this.tankPositionAtScanStart.distance(this.currentTarget.getLastPosition()) > 30.0) {
            this.wiggleAndScoot();
        }
    }

    public void reactToAnotherRobotDeath(RobotDeathEvent event, Enemy deadBadGuy) {
        if (deadBadGuy == this.currentTarget) {
            this.currentTarget = null;
        }
    }

    public void reactToBulletHitAnotherBullet(BulletHitBulletEvent event, Enemy ownerOfOtherBullet, Enemy intendedTarget) {
    }

    public void reactToBulletHitTarget(BulletHitEvent event, Enemy actualTarget, Enemy intendedTarget) {
    }

    public void reactToBulletMissedTarget(BulletMissedEvent event, Enemy intendedTarget) {
    }

    protected void shootAtCurrentTarget() {
        FiringSolution solution = null;
        double distance = this.myBot.getTankPosition().distance(this.currentTarget.getLastPosition());
        if (distance > 600.0) {
            return;
        }
        if (this.useGunCount >= 1) {
            ArrayList<Gun> gunlist = new ArrayList<Gun>();
            gunlist.add(this.currentTarget.getGunByName("Linear"));
            gunlist.add(this.currentTarget.getGunByName("Lag"));
            gunlist.add(this.currentTarget.getGunByName("Ahead"));
            Collections.sort(gunlist, new GunAccuracyComparator(true));
            int decision = new Random().nextInt(100);
            this.whichGun = decision <= 50 ? ((Gun)gunlist.get(0)).getGunName() : (decision <= 85 ? ((Gun)gunlist.get(1)).getGunName() : ((Gun)gunlist.get(2)).getGunName());
            this.useGunCount = 0;
        }
        Gun gun = null;
        gun = this.whichGun.equals("Linear") ? this.currentTarget.getGunByName("Linear") : (this.whichGun.equals("Lag") ? this.currentTarget.getGunByName("Lag") : this.currentTarget.getGunByName("Ahead"));
        double power = 1.73;
        power = gun.getRunningShotAccuracy() > 50.0 ? 3.0 : (gun.getRunningShotAccuracy() > 30.0 ? 2.2 : 1.73);
        if (distance > 300.0) {
            power = Math.min(0.3, power);
        } else if (distance < 100.0) {
            power = Math.max(2.5, power);
        }
        if (this.currentTarget.getLastKnownEnergy() == 0.0) {
            power = 3.0;
        }
        if ((solution = gun.buildFiringSolution(this.myBot, this.currentTarget, power)) != null) {
            this.myBot.logTactical("Scan :: " + solution.toString() + ", movement reliability=" + this.currentTarget.getMovementReliability());
            if (this.myBot.fireBullet(solution, true)) {
                ++this.useGunCount;
            }
        } else {
            this.myBot.logTactical("Scan :: cannot determine firing solution for some reason (gun chose not to fire?)");
            ++this.useGunCount;
        }
    }

    protected double calcScore(double distance, double likelyhood) {
        if (distance <= 175.0) {
            distance /= likelyhood;
        }
        return likelyhood * 1000.0 / Math.pow(distance, 2.0);
    }

    /*
     * Unable to fully structure code
     */
    protected void wiggleAndScoot() {
        bearingToVictim = this.calcTurnDegrees(this.currentTarget.getLastPosition(), this.myBot.getHeading());
        sign = this.myBot.getSign(bearingToVictim);
        wallReverseInEffect = false;
        if (!this.myBot.nearWall(this.tankPositionAtScanStart, 100.0)) ** GOTO lbl-1000
        v0 = this.myBot.getFieldCenter();
        v1 = this.myBot.getHeading();
        v2 = this.moveDirection < 0 ? 180 : 0;
        if (Math.abs(this.calcTurnDegrees(v0, v1 + (double)v2)) > 90.0) {
            this.reverseDirection();
            wallReverseInEffect = true;
        } else if (this.myBot.getOthers() > 1) {
            v3 = this.myBot.getHeading();
            v4 = this.moveDirection < 0 ? 180 : 0;
            if (Math.abs(this.calcTurnDegrees(this.crowdCenterOfGravity, v3 + (double)v4)) < 90.0) {
                this.reverseDirection();
            }
        }
        turnAmount = 10.0 - (double)new Random().nextInt(20);
        idealDistance = UnoKillerPersonality._$828;
        if (this.myBot.getOthers() > 1) {
            idealDistance = 250.0;
        } else {
            if (this.currentTarget.getLastKnownEnergy() > this.myBot.getEnergy()) {
                idealDistance = 250.0;
            }
            if (this.tankPositionAtScanStart.distance(this.currentTarget.getLastPosition()) > idealDistance) {
                turnAmount += 40.0;
            } else if (this.tankPositionAtScanStart.distance(this.currentTarget.getLastPosition()) < idealDistance - 75.0) {
                turnAmount -= 40.0;
            }
        }
        turnBearing = BaseBot.normalizeRelativeAngleDegrees(bearingToVictim - (double)sign * (90.0 - turnAmount * (double)this.moveDirection));
        this.myBot.turnTankToBearingDegrees(Math.min(Math.max(turnBearing, -50.0), 50.0));
        moveAmount = (double)this.moveDirection * (77.0 + (double)new Random().nextInt(45));
        absMove = Math.abs(moveAmount);
        moveTime = absMove / 8.0;
        reverseAmount = -1.0 * moveAmount;
        myHeading = this.myBot.getHeading();
        pos = this.myBot.getTankPosition();
        time = this.myBot.getTime();
        checkTime = time + moveTime;
        if (this.myBot.getOthers() == 1) {
            closestShot = null;
            if (!wallReverseInEffect) {
                closestShot = this.myBot.inDangerOfBulletHit(pos, time, null);
            }
            if (closestShot != null) {
                shotDistance = closestShot.distanceToPoint(pos, time);
                if (shotDistance <= 175.0) {
                    forwardPos = BaseBot.projectPointInSpace(pos, myHeading, moveAmount);
                    forwardClosestShot = this.myBot.inDangerOfBulletHit(forwardPos, time, closestShot);
                    if (forwardClosestShot == null) {
                        forwardClosestShot = closestShot;
                    }
                    if ((backwardClosestShot = this.myBot.inDangerOfBulletHit(backwardPos = BaseBot.projectPointInSpace(pos, myHeading, reverseAmount), time, closestShot)) == null) {
                        backwardClosestShot = closestShot;
                    }
                    stayScore = this.calcScore(shotDistance, closestShot.getScore());
                    forwardDistance = forwardClosestShot != null ? forwardClosestShot.distanceToPoint(forwardPos, time) : this.myBot.getBattleFieldWidth();
                    forwardScore = this.calcScore(forwardDistance, forwardClosestShot != null ? forwardClosestShot.getScore() : 1.0);
                    backwardDistance = backwardClosestShot != null ? backwardClosestShot.distanceToPoint(backwardPos, time) : this.myBot.getBattleFieldWidth();
                    backwardScore = this.calcScore(backwardDistance, backwardClosestShot != null ? backwardClosestShot.getScore() : 1.0);
                    doReverse = false;
                    if (stayScore > forwardScore && stayScore > backwardScore) {
                        this.myBot.logDetail("Dodge:  stay score is best (s=" + UnoKillerPersonality.dblfmt.format(stayScore) + " f=" + UnoKillerPersonality.dblfmt.format(forwardScore) + " b=" + UnoKillerPersonality.dblfmt.format(backwardScore) + ")");
                        doReverse = new Random().nextInt(22) == 1;
                    } else if (forwardScore > backwardScore) {
                        this.myBot.logDetail("Dodge:  forward score is best (s=" + UnoKillerPersonality.dblfmt.format(stayScore) + " f=" + UnoKillerPersonality.dblfmt.format(forwardScore) + " b=" + UnoKillerPersonality.dblfmt.format(backwardScore) + ")");
                    } else if (backwardScore > forwardScore) {
                        this.myBot.logDetail("Dodge:  backward score is best (s=" + UnoKillerPersonality.dblfmt.format(stayScore) + " f=" + UnoKillerPersonality.dblfmt.format(forwardScore) + " b=" + UnoKillerPersonality.dblfmt.format(backwardScore) + ")");
                        doReverse = new Random().nextInt(3) == 1;
                    } else {
                        this.myBot.logDetail("Dodge:  unknown situation!!!!!!!!!!!!!!!!!!!!!!");
                    }
                    if (doReverse) {
                        this.reverseDirection();
                        moveAmount = reverseAmount;
                    }
                }
            } else if (new Random().nextInt(4) == 1) {
                this.reverseDirection();
                moveAmount = reverseAmount;
            }
        }
        this.myBot.ahead(moveAmount);
    }

    protected void pick() {
        double x = 0.0;
        double y = 0.0;
        Enemy possibleNextVictim = null;
        double curTime = this.myBot.getTime();
        int enemyCount = 0;
        Iterator i = this.myBot.getOpponentTracker().getAliveEnemies().iterator();
        while (i.hasNext()) {
            possibleNextVictim = (Enemy)i.next();
            double elapsed = curTime - possibleNextVictim.getLastDataScanTime();
            if (elapsed > 66.0) continue;
            ++enemyCount;
            x += possibleNextVictim.getLastKnownX();
            y += possibleNextVictim.getLastKnownY();
            if (possibleNextVictim.getMovementReliability() < this.currentTarget.getMovementReliability() || !(possibleNextVictim.getLastDataScanTime() + 33.0 >= curTime) || !(this.tankPositionAtScanStart.distance(possibleNextVictim.getLastPosition()) < this.tankPositionAtScanStart.distance(this.currentTarget.getLastPosition()))) continue;
            this.currentTarget = possibleNextVictim;
        }
        this.crowdCenterOfGravity.setLocation(x / (double)enemyCount, y / (double)enemyCount);
    }
}

