/*
 * Decompiled with CFR 0.152.
 */
package rsalesc.roborio.utils.geo;

import rsalesc.roborio.utils.R;
import rsalesc.roborio.utils.geo.Point;

public class AxisRectangle {
    public double minx;
    public double maxx;
    public double miny;
    public double maxy;

    public AxisRectangle(double d, double d2, double d3, double d4) {
        this.minx = d;
        this.maxx = d2;
        this.miny = d3;
        this.maxy = d4;
    }

    public double getWidth() {
        return this.maxx - this.minx;
    }

    public double getHeight() {
        return this.maxy - this.miny;
    }

    public Point getCenter() {
        return new Point((this.minx + this.maxx) / 2.0, (this.miny + this.maxy) / 2.0);
    }

    public boolean contains(Point point) {
        return R.nearOrBetween(this.minx, point.getX(), this.maxx) && R.nearOrBetween(this.miny, point.getY(), this.maxy);
    }

    public AxisRectangle shrinkX(double d) {
        if (d * 2.0 > this.getWidth()) {
            double d2 = (this.minx + this.maxx) / 2.0;
            return new AxisRectangle(d2, d2, this.miny, this.maxy);
        }
        return new AxisRectangle(this.minx + d, this.maxx - d, this.miny, this.maxy);
    }

    public AxisRectangle shrinkY(double d) {
        if (d * 2.0 > this.getHeight()) {
            double d2 = (this.miny + this.maxy) / 2.0;
            return new AxisRectangle(this.minx, this.maxx, d2, d2);
        }
        return new AxisRectangle(this.minx, this.maxx, this.miny + d, this.maxy - d);
    }

    public AxisRectangle shrink(double d, double d2) {
        return this.shrinkX(d).shrinkY(d2);
    }

    public Point[] getCorners() {
        Point[] pointArray = new Point[]{new Point(this.minx, this.miny), new Point(this.maxx, this.miny), new Point(this.maxx, this.maxy), new Point(this.minx, this.maxy)};
        return pointArray;
    }
}

