/*
 * Decompiled with CFR 0.152.
 */
package simonton.dc;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PriorityQueue;
import simonton.dc.Distancer;
import simonton.utils.FastMath;

public class Cluster
extends AbstractCollection {
    public static final Filter NON_FILTER = new Filter(){

        @Override
        public boolean accepts(Point value) {
            return true;
        }
    };
    public final double[] center;
    private final int size;
    private final Filter filter;
    private final Distancer distancer;
    private final PriorityQueue points = new PriorityQueue();
    private final double[] testPoint;

    public Cluster(double[] center, int size, Distancer distancer, Filter filter) {
        this.center = center;
        this.size = size;
        this.distancer = distancer;
        this.filter = filter;
        this.testPoint = new double[center.length];
    }

    public Collection getValues() {
        ArrayList<Object> values = new ArrayList<Object>(this.points.size());
        for (Point node : this.points) {
            values.add(node.value);
        }
        return values;
    }

    public void consider(Object value, double[] location) {
        this.consider(new Point(value, location));
    }

    public void consider(Point p) {
        p.setDistanceToCenter(this.distancer, this.center);
        if (this.points.size() < this.size) {
            if (this.filter.accepts(p)) {
                this.points.add(p);
            }
        } else if (p.distanceToCenter < ((Point)this.points.peek()).distanceToCenter && this.filter.accepts(p)) {
            this.points.poll();
            this.points.add(p);
        }
    }

    public void trimTo(int size) {
        while (this.points.size() > size) {
            this.points.poll();
        }
    }

    public boolean isViable(double[] lBounds, double[] uBounds) {
        if (this.points.size() < this.size) {
            return true;
        }
        int i = lBounds.length;
        while (--i >= 0) {
            this.testPoint[i] = FastMath.bound(this.center[i], lBounds[i], uBounds[i]);
        }
        return ((Point)this.points.peek()).isFartherThan(this.testPoint, this.center, this.distancer);
    }

    @Override
    public Iterator iterator() {
        return this.points.iterator();
    }

    @Override
    public int size() {
        return this.points.size();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Cluster)) {
            return false;
        }
        HashSet mine = new HashSet(this.points);
        HashSet his = new HashSet(((Cluster)o).points);
        return mine.equals(his);
    }

    @Override
    public String toString() {
        return this.points.toString();
    }

    public static interface Filter {
        public boolean accepts(Point var1);
    }

    public static class Point
    implements Comparable {
        private static long nextId = 0L;
        public final Object value;
        public final double[] location;
        public final long id = nextId++;
        public double distanceToCenter;

        public void setDistanceToCenter(Distancer distancer, double[] center) {
            this.distanceToCenter = distancer.getDistance(center, this.location);
        }

        public boolean isFartherThan(double[] testPoint, double[] center, Distancer distancer) {
            return this.distanceToCenter > distancer.getDistance(testPoint, center);
        }

        public int compareTo(Point other) {
            if (this.distanceToCenter > other.distanceToCenter) {
                return -1;
            }
            return this.distanceToCenter >= other.distanceToCenter ? 0 : 1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Point)) {
                return false;
            }
            Point other = (Point)o;
            return this.value.equals(other.value) && Arrays.equals(this.location, other.location);
        }

        public int hashCode() {
            return Arrays.hashCode(this.location) ^ this.value.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }

        public int compareTo(Object obj) {
            return this.compareTo((Point)obj);
        }

        public Point(Object value, double[] location) {
            this.value = value;
            this.location = location;
        }
    }
}

