/*
 * Decompiled with CFR 0.152.
 */
package simonton.waves;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.ScannedRobotEvent;
import simonton.core.SlaveBot;
import simonton.dc.DCStatistician;
import simonton.utils.FastMath;
import simonton.utils.Location;
import simonton.utils.Util;
import simonton.waves.Wave;
import simonton.waves.WaveStatistician;

public class EnemyWaveManager
extends SlaveBot {
    private WaveStatistician statistician;
    private Location lastPos;
    private List waves = new LinkedList();
    private Wave gunHeatWave;
    private Wave lastFiredWave;
    private Wave aimedThisTick;
    private Wave aimedLastTick;
    private long lastChange;
    private int orientation = 1;
    private ScannedRobotEvent scan;
    private int consecutiveHeatSurfs;

    public EnemyWaveManager(WaveStatistician statistician) {
        this.statistician = statistician;
        this.keepSynchronized(false, statistician);
    }

    public List getApproachingWaves(boolean includeDeadWaves) {
        ArrayList<Wave> approaching = new ArrayList<Wave>();
        for (Wave wave : this.waves) {
            if (!wave.approaching || !wave.live && !includeDeadWaves) continue;
            approaching.add(wave);
        }
        if (this.gunHeatWave != null) {
            approaching.add(this.gunHeatWave);
        }
        return approaching;
    }

    public Wave getMostRecentWave() {
        if (this.gunHeatWave != null) {
            return this.gunHeatWave;
        }
        return this.lastFiredWave;
    }

    public boolean changed() {
        return this.lastChange == this.getTime();
    }

    public long getDelayUntilFire(long startTime) {
        long nextFireTime = this.getTime() + (long)Math.ceil(this.getGunHeat() / Util.gunCoolingRate);
        long elapsed = startTime - nextFireTime;
        if (elapsed >= 0L) {
            double delay = Math.ceil(Util.getGunHeat(this.firePower) / Util.gunCoolingRate);
            nextFireTime = (long)((double)nextFireTime + Math.ceil((double)(elapsed + 1L) / delay) * delay);
        }
        return nextFireTime - startTime;
    }

    public void offtick() {
        ((DCStatistician)this.statistician).offtick();
    }

    @Override
    public void run() {
        super.run();
        this.waves.clear();
        this.aimedThisTick = null;
        this.aimedLastTick = null;
        this.scan = null;
        this.lastChange = 0L;
    }

    @Override
    public void runIteration() {
        super.runIteration();
        if (this.scan == null) {
            return;
        }
        long time = this.getTime();
        Iterator it = this.waves.iterator();
        while (it.hasNext()) {
            Wave wave = (Wave)it.next();
            if (wave.approaching && wave.willPass(this.hisLoc)) {
                wave.approaching = false;
                wave.recordPassing(this.hisLoc);
            }
            if (wave.approaching || wave.washCode(this.hisLoc, time) >= 0) continue;
            it.remove();
        }
        if (this.fire) {
            this.aimedLastTick.origin = this.lastPos;
            this.aimedLastTick.setBulletPower(this.firePower, -10.0, -10.0);
            this.aimedLastTick.setStats(false);
            this.waves.add(this.aimedLastTick);
            this.lastFiredWave = this.aimedLastTick;
            this.lastChange = this.getTime();
        }
        this.lastPos = this.myLoc;
        this.aimedLastTick = this.aimedThisTick;
        double latV = Util.getLateralVelocity(this, this.scan);
        if (latV != 0.0) {
            this.orientation = FastMath.sign(latV);
        }
        this.aimedThisTick = new Wave(this, this.scan, this.orientation, FastMath.min(this.firePower, this.getEnergy()), this.statistician);
        ++this.aimedThisTick.fireTime;
        this.aimedThisTick.setAimingState();
        this.gunHeatWave = null;
        if (this.getEnergy() > 0.0) {
            int delayToNextFire = FastMath.ceil(this.getGunHeat() / this.getGunCoolingRate() - 1.0E-5);
            if (delayToNextFire == 0) {
                if (this.consecutiveHeatSurfs < 3) {
                    this.aimedLastTick.setStats(false);
                    this.aimedLastTick.origin = this.myLoc;
                    this.gunHeatWave = this.aimedLastTick;
                    this.lastChange = this.getTime();
                }
            } else if (delayToNextFire == 1) {
                this.aimedThisTick.setStats(false);
                this.gunHeatWave = this.aimedThisTick;
                this.lastChange = this.getTime();
            }
        }
        this.consecutiveHeatSurfs = this.gunHeatWave == null ? 0 : ++this.consecutiveHeatSurfs;
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        super.onScannedRobot(e);
        this.scan = e;
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        super.onBulletHit(e);
        this.logHit(e.getBullet());
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e) {
        super.onBulletHitBullet(e);
        this.logHit(e.getBullet());
    }

    private void logHit(Bullet b) {
        String stats = "";
        Iterator it = this.waves.iterator();
        while (it.hasNext()) {
            Wave wave = (Wave)it.next();
            if (wave.live && wave.equals(b)) {
                wave.recordDiscovery(b.getHeadingRadians());
                it.remove();
                for (Wave otherWave : this.waves) {
                    otherWave.updateStats();
                }
                this.lastChange = this.getTime();
            }
            stats = String.valueOf(stats) + String.format("  %.2f?=%.2f, %d?=0\n", wave.speed, b.getVelocity(), wave.washCode(new Location(b), Util.time));
        }
        Util.log("EnemyWaveManager.logHit(): No Waves Found For Enemy Hit!!%n%s", new Object[]{stats});
    }

    @Override
    public void onPaint(Graphics2D g) {
        super.onPaint(g);
        int time = (int)this.getTime();
        for (Wave wave : this.waves) {
            wave.onPaint(g, time);
        }
    }
}

