/*
 * Decompiled with CFR 0.152.
 */
package synapse;

import synapse.BaseBot;
import synapse.Enemy;
import synapse.segmentation.Axis;

public class Segmentation {
    public static final boolean USE_VALUE_MULTIPLIERS = true;
    public static final boolean NOT_USE_VALUE_MULTIPLIERS = false;
    private float[][] data;
    private float[] peak;
    private float[] rootMeanSquare;
    private float[] crestFactor;
    private long[] count;
    private long[] shots;
    private long[] hits;
    private final Axis[] axes;
    private final int numWavebuckets;
    private final float valueMultiplier;
    private final float raDepth;

    public Segmentation(int numWavebuckets, Axis[] axes) {
        this(numWavebuckets, axes, 200.0f, true);
    }

    public Segmentation(int numWavebuckets, Axis[] axes, float rollingDepth, boolean useValueMultipliers) {
        this.numWavebuckets = numWavebuckets;
        this.axes = axes;
        int numSeg = 1;
        float valueMultiplier = 1.0f;
        Axis[] axisArray = axes;
        int n = axes.length;
        int n2 = 0;
        while (n2 < n) {
            Axis a = axisArray[n2];
            numSeg *= a.getNumSegments();
            if (useValueMultipliers) {
                valueMultiplier = (float)((double)valueMultiplier * a.getValueMultiplier());
            }
            ++n2;
        }
        this.valueMultiplier = valueMultiplier;
        this.data = new float[numSeg][numWavebuckets];
        this.peak = new float[numSeg];
        this.rootMeanSquare = new float[numSeg];
        this.crestFactor = new float[numSeg];
        this.count = new long[numSeg];
        this.shots = new long[numSeg];
        this.hits = new long[numSeg];
        this.raDepth = rollingDepth;
    }

    public float getMaximum(int index) {
        return this.peak[index];
    }

    public float[] getBuckets(int index) {
        return this.data[index];
    }

    public int getDepth() {
        return this.axes.length;
    }

    public long getShots(int index) {
        return this.shots[index];
    }

    public float getHitRatio(int index) {
        if (this.shots[index] == 0L) {
            return 0.0f;
        }
        return (float)this.hits[index] / (float)this.shots[index];
    }

    public void clearHits() {
        int i = 0;
        while (i < this.data.length) {
            this.count[i] = 0L;
            this.hits[i] = 0L;
            ++i;
        }
    }

    public float getFitness(int index) {
        return this.valueMultiplier * this.crestFactor[index];
    }

    public float getBestGuessFactor(int segmentIndex) {
        int bucket = this.data[segmentIndex].length / 2;
        float max = 0.0f;
        int i = 0;
        while (i < this.data[segmentIndex].length) {
            if (this.data[segmentIndex][i] > max) {
                max = this.data[segmentIndex][i];
                bucket = i;
            }
            ++i;
        }
        return 2.0f * ((float)bucket + 0.5f) / (float)this.data[segmentIndex].length - 1.0f;
    }

    public String toString() {
        String s = "";
        Axis[] axisArray = this.axes;
        int n = this.axes.length;
        int n2 = 0;
        while (n2 < n) {
            Axis a = axisArray[n2];
            if (!s.isEmpty()) {
                s = String.valueOf(s) + " / ";
            }
            s = String.valueOf(s) + a;
            ++n2;
        }
        if (s.isEmpty()) {
            return "none";
        }
        return s;
    }

    public void registerHit(float guessFactor, int index, boolean fired, float weight, float smoothing) {
        int n = index;
        this.count[n] = this.count[n] + 1L;
        float totalSquares = 0.0f;
        int bucket = (int)((double)this.numWavebuckets * ((double)(guessFactor / 2.0f) + 0.5));
        this.peak[index] = 0.0f;
        if (fired) {
            int n2 = index;
            this.shots[n2] = this.shots[n2] + 1L;
        }
        int i = 0;
        while (i < this.numWavebuckets) {
            float newValue = smoothing / (smoothing + (float)((bucket - i) * (bucket - i)));
            this.data[index][i] = (this.data[index][i] * this.raDepth + newValue * weight) / (this.raDepth + weight);
            totalSquares += this.data[index][i] * this.data[index][i];
            if (this.data[index][i] > this.peak[index]) {
                this.peak[index] = this.data[index][i];
            }
            ++i;
        }
        this.rootMeanSquare[index] = (float)Math.sqrt(totalSquares / (float)this.numWavebuckets);
        if (this.rootMeanSquare[index] > 0.0f) {
            this.crestFactor[index] = this.peak[index] / this.rootMeanSquare[index];
        }
    }

    public void registerSuccess(int index) {
        int n = index;
        this.count[n] = this.count[n] + 1L;
        int n2 = index;
        this.hits[n2] = this.hits[n2] + 1L;
    }

    public int getIndex(BaseBot bot) {
        int[] seg = new int[this.axes.length];
        int i = 0;
        while (i < this.axes.length) {
            seg[i] = this.axes[i].getSegmentationIndex(bot);
            ++i;
        }
        return this.getIndex(seg);
    }

    public int getIndex(Enemy e) {
        int[] seg = new int[this.axes.length];
        int i = 0;
        while (i < this.axes.length) {
            seg[i] = this.axes[i].getSegmentationIndex(e);
            ++i;
        }
        return this.getIndex(seg);
    }

    private int getIndex(int[] segmentIndices) {
        int index = 0;
        int i = 0;
        while (i < segmentIndices.length) {
            index *= this.axes[i].getNumSegments();
            index += segmentIndices[i];
            ++i;
        }
        return index;
    }
}

