/*
 * Decompiled with CFR 0.152.
 */
package synapse.segmentation;

import synapse.BaseBot;
import synapse.Enemy;
import synapse.Util;
import synapse.segmentation.Axis;

public class BulletFlightTime
extends Axis {
    private final int segments;

    public BulletFlightTime() {
        this(8);
    }

    public BulletFlightTime(int segments) {
        this.segments = segments;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 80.0;
    }

    @Override
    public int getNumSegments() {
        return this.segments;
    }

    @Override
    public double getAxisValue(Enemy e) {
        return Util.limit(0.0, e.lastIncomingBulletFlightTime, 80.0);
    }

    @Override
    public double getAxisValue(BaseBot j) {
        return Util.limit(0.0, j.lastIncomingBulletFlightTime, 80.0);
    }

    @Override
    public double getValueMultiplier() {
        return 0.95;
    }

    @Override
    public String toString() {
        return "Bullet Flight Time";
    }
}

