/*
 * Decompiled with CFR 0.152.
 */
package synapse.segmentation;

import synapse.BaseBot;
import synapse.Enemy;
import synapse.segmentation.Axis;

public class LastStopped
extends Axis {
    private final int segments;

    public LastStopped() {
        this(10);
    }

    public LastStopped(int segments) {
        this.segments = segments;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public int getNumSegments() {
        return this.segments;
    }

    @Override
    public double getAxisValue(Enemy e) {
        return (double)(e.ctime - e.lastStopped) / e.distance;
    }

    @Override
    public double getAxisValue(BaseBot j) {
        return (double)(j.time - j.lastStopped) / j.target.distance;
    }

    @Override
    public String toString() {
        return "Last Stopped";
    }

    @Override
    public double getValueMultiplier() {
        return 0.95;
    }
}

