/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.move;

import vuen.fractal.FractalE;
import vuen.fractal.data.Memory;
import vuen.fractal.data.Packet;
import vuen.fractal.util.BotMath;

public class Flank {
    FractalE robot;
    Memory memory;
    public double dir = 0.0;

    public Flank(FractalE robot, Memory memory) {
        this.robot = robot;
        this.memory = memory;
    }

    public void init() {
        this.dir = 0.0;
    }

    public void go() {
        Packet now = this.memory.getPacket(0);
        if (now == null) {
            return;
        }
        Packet enemy = this.memory.getPacket(this.memory.getTarget());
        if (enemy == null) {
            return;
        }
        double xwall = 1.0 / now.x - 1.0 / (BotMath.arenawidth - now.x);
        double ywall = 1.0 / now.y - 1.0 / (BotMath.arenawidth - now.y);
        double angle = Math.abs(BotMath.normalRelativeAngle(BotMath.angleVector(xwall, ywall) - now.heading));
        if (angle < 90.0) {
            this.dir = 1.0;
        } else {
            this.dir = -1.0;
            angle = 180.0 - angle;
        }
        this.dir *= (90.0 - angle) / 90.0;
        this.dir *= 200.0 / (BotMath.distancePoints(now.x, now.y, enemy.x, enemy.y) + BotMath.distanceNormalClosestWall(now.x, now.y));
    }
}

