/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.move;

import vuen.fractal.FractalE;
import vuen.fractal.data.Memory;
import vuen.fractal.data.Packet;
import vuen.fractal.move.Flank;
import vuen.fractal.util.BotMath;

public class Roller {
    FractalE robot;
    Memory memory;
    Flank flank;
    double ahead = 10000.0;
    double roll = 20.0;
    boolean wait = false;
    int waittime;
    public static final double DISTANCE = 300.0;

    public Roller(FractalE robot, Memory memory, Flank flank) {
        this.robot = robot;
        this.memory = memory;
        this.flank = flank;
    }

    public void init() {
        this.ahead = 10000L * (Math.round(Math.random()) * 2L - 1L);
        this.roll = -1.0;
        this.doRollVal();
        this.wait = true;
        this.waittime = (int)(Math.random() * 20.0) + 10;
    }

    public void go() {
        if (this.wait) {
            this.doWait();
        } else {
            this.doRollVal();
        }
        if (!this.wait) {
            this.robot.setAhead(this.ahead);
        }
    }

    public void doWait() {
        if (this.robot.getTime() > (long)this.waittime) {
            this.wait = false;
        }
        Packet self = this.memory.getPacket(0);
        Packet enemy = this.memory.getPacket(this.memory.getTarget());
        if (enemy == null || self == null) {
            return;
        }
    }

    public void doRollVal() {
        Packet self = this.memory.getPacket(0);
        Packet enemy = this.memory.getPacket(this.memory.getTarget());
        if (enemy == null || self == null) {
            return;
        }
        if (this.robot.getTime() > 20L) {
            this.roll -= 1.0 / BotMath.geometricabs(300.0 / BotMath.distancePoints(self.x, self.y, enemy.x, enemy.y));
        }
        if (BotMath.isHeadingWall(self.x, self.y, self.heading - 90.0 * (BotMath.sign(this.ahead) - 1.0))) {
            double bs = 20.0 - this.memory.gen.getPower(this.memory.getTarget()) * 3.0;
            this.roll = Math.random() * 10.0 + 300.0 / bs;
            this.ahead *= -1.0;
        } else if (this.roll < 0.0) {
            double bs = 20.0 - this.memory.gen.getPower(this.memory.getTarget()) * 3.0;
            this.roll = (Math.random() - 0.75) * 10.0 + 300.0 / bs;
            this.ahead *= -1.0;
        }
    }
}

