/*
 * Decompiled with CFR 0.152.
 */
package dk;

import dk.BattleField;
import dk.Point;

public class Util {
    static final double PI = Math.PI;

    private Util() {
    }

    public static int sign(int v) {
        if (v < 0) {
            return -1;
        }
        if (v > 0) {
            return 1;
        }
        return 0;
    }

    public static int sign(double v) {
        if (v < 0.0) {
            return -1;
        }
        if (v > 0.0) {
            return 1;
        }
        return 0;
    }

    static double timeWeightedAverage(double sample, double current, long sinceLast, double decayRate) {
        double weight = Math.exp(-decayRate * (double)sinceLast);
        return weight * current + (1.0 - weight) * sample;
    }

    static double halfLifeDecayRate(long halfLife) {
        return -Math.log(0.5) / (double)halfLife;
    }

    static double movingAverage(double sample, double sampleWeight, double current, int numberOfSamples) {
        return (current * (double)numberOfSamples + sample * sampleWeight) / ((double)numberOfSamples + sampleWeight);
    }

    public static double normalizeBearing(double angle) {
        if (angle > Math.PI) {
            angle -= Math.PI * 2;
        } else if (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static double normalizeHeading(double angle) {
        if (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        } else if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static double toDegrees(double angle) {
        return angle / (Math.PI * 2) * 360.0;
    }

    public static double toRadians(double angle) {
        return angle / 360.0 * (Math.PI * 2);
    }

    public static double range(Point p1, Point p2) {
        if (p1 == null || p2 == null) {
            return 1000000.0;
        }
        double dx = p1.getX() - p2.getX();
        double dy = p1.getY() - p2.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double bearing(Point p1, Point p2) {
        double r = Util.range(p1, p2);
        double dx = p2.getX() - p1.getX();
        double dy = p2.getY() - p1.getY();
        if (r > 0.0) {
            if (dx >= 0.0) {
                if (dy > 0.0) {
                    return Math.asin(dx / r);
                }
                if (dy <= 0.0) {
                    return Math.PI - Math.asin(dx / r);
                }
            } else if (dx < 0.0) {
                if (dy > 0.0) {
                    return Math.PI * 2 - Math.asin(-dx / r);
                }
                if (dy <= 0.0) {
                    return Math.PI + Math.asin(-dx / r);
                }
            }
        }
        return 0.0;
    }

    public static double lateralVelocity(double velocity, double heading, double bearing) {
        return velocity * Math.sin(heading - bearing);
    }

    public static Point applyHeading(Point p1, double angle, double distance) {
        return new Point(p1.getX() + Math.sin(angle) * distance, p1.getY() + Math.cos(angle) * distance);
    }

    public static Point clamp(Point p) {
        return Util.clamp(p, BattleField.r.getBattleFieldWidth(), BattleField.r.getBattleFieldHeight(), 18.0);
    }

    public static Point clamp(Point p, double width, double height, double border) {
        boolean didClamp = false;
        double x = p.getX();
        double y = p.getY();
        if (x < border) {
            didClamp = true;
            x = border;
        }
        if (y < border) {
            didClamp = true;
            y = border;
        }
        if (x > width - border) {
            didClamp = true;
            x = width - border;
        }
        if (y > height - border) {
            didClamp = true;
            y = height - border;
        }
        if (didClamp) {
            return new Point(x, y);
        }
        return p;
    }

    public static int indexFromValue(double value, int buckets, double min, double max) {
        double bucketSize = (max - min) / (double)buckets;
        int index = (int)((value - min) / bucketSize);
        if (index < 0) {
            index = 0;
        } else if (index >= buckets) {
            index = buckets - 1;
        }
        return index;
    }

    public static double valueFromIndex(int index, int buckets, double min, double max) {
        double bucketSize = (max - min) / (double)buckets;
        double value = (double)(index + 1) * bucketSize + min;
        return value;
    }

    public static double bulletDamage(double power) {
        double damage = 4.0 * power;
        if (power > 1.0) {
            damage += 2.0 * (power - 1.0);
        }
        return damage;
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static int bulletTravelTime(double distance, double power) {
        return (int)(distance / Util.bulletVelocity(power) + 0.99) - 1;
    }
}

