/*
 * Decompiled with CFR 0.152.
 */
package pulsar.movement;

import apv.MovSimStat;
import java.awt.geom.Point2D;
import java.util.Map;
import pulsar.PulsarMax;
import pulsar.movement.Movement;
import pulsar.util.RobotData;
import pulsar.util.Util;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.util.Utils;

public abstract class AbstractMovement
implements Movement {
    private boolean isRealStrategy = true;

    public boolean isRealStrategy() {
        return this.isRealStrategy;
    }

    public void setIsRealStrategy(boolean b) {
        this.isRealStrategy = b;
    }

    public void doMovement(AdvancedRobot robot, double goalDirection, RobotData target, Map radar, Map wavesMap, boolean wallAvoid) {
        Move move = this.setMovement(robot, (double)8, goalDirection, target, wallAvoid);
        AbstractMovement.executeMove(move, robot);
    }

    protected Move setMovement(AdvancedRobot robot, double maxVelocity, double goalDirection, RobotData currentTarget, boolean wallAvoid) {
        MovSimStat move = new MovSimStat(robot.getX(), robot.getY(), robot.getVelocity(), robot.getHeadingRadians(), 0.0);
        return this.setMovement(move, maxVelocity, goalDirection, currentTarget, wallAvoid);
    }

    protected Move setMovement(MovSimStat moveStat, double maxVelocity, double goalDirection, RobotData currentTarget, boolean wallAvoid) {
        double turnDirection = currentTarget.getDirectionRelativeTo(PulsarMax.robotStats, 0);
        boolean wallAvoiding = false;
        int times = 0;
        if (wallAvoid) {
            Point2D.Double predictLoc;
            while ((predictLoc = Util.linearPredict(moveStat.x, moveStat.y, goalDirection, 8, 18)) != null && !PulsarMax.fieldWithMargin.contains(predictLoc) && PulsarMax.fieldWithMargin.contains(moveStat.x, moveStat.y) && times++ < 65) {
                goalDirection += 0.1 * turnDirection;
                wallAvoiding = true;
            }
        }
        Move move = new Move();
        move.timesWallsAvoid = times;
        double turn = Utils.normalRelativeAngle((double)(goalDirection - moveStat.heading));
        if (Math.abs(turn) > 1.5707963267948966) {
            turn = Utils.normalRelativeAngle((double)(turn + Math.PI));
            move.ahead = -100000;
        } else {
            move.ahead = 100000;
        }
        move.turn = turn;
        if (wallAvoiding) {
            maxVelocity = turn >= 0.5235987755982988 ? 0.0 : maxVelocity;
        }
        move.maxVelocity = maxVelocity;
        return move;
    }

    protected Move setMovement(AdvancedRobot robot, double maxVelocity, Point2D.Double circleLoc, double direction, double optimalDistance) {
        MovSimStat move = new MovSimStat(robot.getX(), robot.getY(), robot.getVelocity(), robot.getHeadingRadians(), 0.0);
        return this.setMovement(move, maxVelocity, circleLoc, direction, optimalDistance);
    }

    protected Move setMovement(MovSimStat moveStat, double maxVelocity, Point2D.Double circleLoc, double direction, double optimalDistance) {
        Point2D.Double predictLoc;
        double distance = Point2D.distance(moveStat.x, moveStat.y, circleLoc.getX(), circleLoc.getY());
        double turnDirection = direction;
        double goalDirection = Util.absbearing(moveStat.x, moveStat.y, circleLoc.getX(), circleLoc.getY()) - 1.5707963267948966 * direction;
        if (distance > optimalDistance + 20.0) {
            goalDirection += direction * Math.PI / (double)16;
        } else if (distance < (double)200) {
            goalDirection += direction * -Math.PI / (double)6;
        } else if (distance < optimalDistance - 200.0) {
            goalDirection += direction * -Math.PI / (double)8;
        } else if (distance < optimalDistance - 100.0) {
            goalDirection += direction * -Math.PI / (double)10;
        } else if (distance < optimalDistance - 20.0) {
            goalDirection += direction * -Math.PI / (double)12;
        }
        boolean wallAvoiding = false;
        int times = 0;
        while ((predictLoc = Util.linearPredict(moveStat.x, moveStat.y, goalDirection, 8, 18)) != null && !PulsarMax.fieldWithMargin.contains(predictLoc) && PulsarMax.fieldWithMargin.contains(moveStat.x, moveStat.y) && times++ < 65) {
            goalDirection += 0.1 * turnDirection;
            wallAvoiding = true;
        }
        Move move = new Move();
        move.timesWallsAvoid = times;
        double turn = Utils.normalRelativeAngle((double)(goalDirection - moveStat.heading));
        if (Math.abs(turn) > 1.5707963267948966) {
            turn = Utils.normalRelativeAngle((double)(turn + Math.PI));
            move.ahead = -100000;
        } else {
            move.ahead = 100000;
        }
        move.turn = turn;
        if (wallAvoiding) {
            maxVelocity = turn >= 0.5235987755982988 ? 0.0 : maxVelocity;
        }
        move.maxVelocity = maxVelocity;
        return move;
    }

    protected static void executeMove(Move move, AdvancedRobot robot) {
        robot.setTurnRightRadians(move.turn);
        robot.setAhead(move.ahead);
        robot.setMaxVelocity(move.maxVelocity);
    }

    public void onHitRobot(HitRobotEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent event, Map wavesMap) {
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onHitByBullet(HitByBulletEvent e, Map wavesMap) {
    }

    public Map getSegmentationMap() {
        return null;
    }

    public Object getSavedData() {
        return null;
    }

    public void setSavedData(Object o) {
    }

    class Move {
        double turn;
        double ahead;
        double maxVelocity = 8;
        int timesWallsAvoid;

        static /* synthetic */ AbstractMovement access$0(Move move) {
            return move.AbstractMovement.this;
        }
    }
}

