/*
 * Decompiled with CFR 0.152.
 */
package pulsar.targeting;

import java.util.HashMap;
import java.util.Map;
import pulsar.PulsarMax;
import pulsar.Settings;
import pulsar.Strategy;
import pulsar.gf.DistanceSegmentation;
import pulsar.gf.GFUtil;
import pulsar.gf.Segmentation;
import pulsar.movement.AvoidRamMovement;
import pulsar.util.RobotData;
import pulsar.util.Util;
import pulsar.util.Wave;
import robocode.AdvancedRobot;

public abstract class Targeting
implements Strategy {
    private Targeting[] targetings = new Targeting[]{this};
    private double[] weights = new double[]{1.0};
    private boolean isRealStrategy = true;
    private static final DistanceSegmentation distanceSeg = new DistanceSegmentation(2);

    public boolean isRealStrategy() {
        return this.isRealStrategy;
    }

    public void setIsRealStrategy(boolean b) {
        this.isRealStrategy = b;
    }

    public abstract double[] target(double var1, RobotData var3);

    public double getGunTurnLimit(RobotData target) {
        return 0.5 * Math.atan2(36, target.getDistanceTo(PulsarMax.robotStats, 0));
    }

    public double getScore(AdvancedRobot robot, RobotData target, Map radar, Map wavesMap) {
        return target.getCurrentTotalHitRate(this.getName());
    }

    public int getBestIndex(double firePower, RobotData target) {
        return (int)this.getBestIndexData(firePower, target)[0];
    }

    protected Targeting[] getTargetings() {
        return this.targetings;
    }

    protected void setTargetings(Targeting[] t) {
        this.targetings = t;
    }

    protected void setWeights(double[] w) {
        this.weights = w;
    }

    protected double[] getWeights() {
        return this.weights;
    }

    protected double[] getBestIndexData(double firePower, RobotData target) {
        int bestIndex = 13;
        double maxValue = 0.0;
        float[] combinedValues = new float[27];
        Targeting[] targetings = this.getTargetings();
        double[] weights = this.getWeights();
        float[][] data = Targeting.getTargetingDataGFValues(targetings, firePower, target);
        int i = 0;
        while (i < targetings.length) {
            int j = 0;
            while (j < combinedValues.length) {
                int n = j;
                combinedValues[n] = (float)((double)combinedValues[n] + (double)data[i][j] * weights[i]);
                ++j;
            }
            ++i;
        }
        maxValue = combinedValues[bestIndex];
        i = 0;
        while (i < combinedValues.length) {
            if ((double)combinedValues[i] > maxValue) {
                bestIndex = i;
                maxValue = combinedValues[i];
            }
            ++i;
        }
        return new double[]{bestIndex, maxValue};
    }

    protected static float[][] getTargetingDataGFValues(Targeting[] targetings, double firePower, RobotData target) {
        HashMap<String, Segmentation[]> segs = new HashMap<String, Segmentation[]>();
        int i = 0;
        while (i < targetings.length) {
            Segmentation[] seg = targetings[i].getSegmentation();
            if (seg != null) {
                segs.put(targetings[i].getName() + target.name, seg);
            }
            ++i;
        }
        float[][] data = new float[targetings.length][27];
        Wave wave = PulsarMax.robotStats.createWave(target, firePower, true, segs);
        int i2 = 0;
        while (i2 < targetings.length) {
            int[] gfIndexes = (int[])wave.gfIndexes.get(targetings[i2].getName() + target.name);
            data[i2] = GFUtil.getGuessFactorValue(targetings[i2].getName(), null, false, -1, target.name, gfIndexes, -1, Double.POSITIVE_INFINITY, 1.0, 0.0, targetings[i2].getSegmentationSizes(), 27, Settings.TARGETING_HIT_SAMPLES > 0);
            ++i2;
        }
        return data;
    }

    public abstract int[] getSegmentationSizes();

    public abstract String[] getSegmentationNames();

    public Segmentation[] getSegmentation() {
        return null;
    }

    public double getFirePower(AdvancedRobot robot, RobotData target) {
        if (PulsarMax.getMode() == 1) {
            return 3;
        }
        double firePower = 1.9;
        int distanceIndex = distanceSeg.getIndex(PulsarMax.robotStats, target, 0);
        if (distanceIndex == 0) {
            firePower = 3;
        } else if (distanceIndex >= distanceSeg.getNoSegments() - 1) {
            firePower = 1.1;
        }
        if (!PulsarMax.melee && robot.getOthers() <= 1 && target.getCurrentTotalHitRate(this.getName()) >= 0.35) {
            firePower = 3;
        }
        double robotEnergy = robot.getEnergy();
        if (AvoidRamMovement.isTargetRamming(robot, target) && target.getDistanceTo(PulsarMax.robotStats, 0) < (double)150) {
            firePower = Math.min((double)3, robotEnergy);
        } else if (robotEnergy <= 0.3 && target.getValue(target.energy) > 0.0 && target.getDistanceTo(PulsarMax.robotStats, 0) > (double)150) {
            firePower = -1;
        } else {
            if (robotEnergy < (double)16) {
                firePower = 1.1;
            } else if (robotEnergy < (double)5) {
                firePower = 0.1;
            }
            firePower = Math.min(firePower, robot.getEnergy() - 0.3);
        }
        firePower = Math.min(Util.calcFirePowerNeeded(target.getValue(target.energy)), firePower);
        return firePower;
    }
}

