/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pedersen.debug.Debug;
import pedersen.debug.Debuggable;
import pedersen.tactics.bot.BearingOffsetRange;

public class WaveData
implements Debuggable {
    public final double originalBearingToTarget;
    public final double originalLateralVelocity;
    public final double originalHeadonVelocity;
    public final double originalCwDistanceToWall;
    public final double originalCcwDistanceToWall;
    private final List bearingOffsetRanges = new ArrayList();
    private boolean isLiveRound = false;

    public WaveData(double a, double b, double c, double d, double e) {
        this.originalLateralVelocity = a;
        this.originalHeadonVelocity = b;
        this.originalCwDistanceToWall = c;
        this.originalCcwDistanceToWall = d;
        this.originalBearingToTarget = e;
    }

    public void addBearingOffsetRange(BearingOffsetRange bearingOffsetRange) {
        this.bearingOffsetRanges.add(bearingOffsetRange);
    }

    public Iterator getBearingOffsetRangeIterator() {
        return this.bearingOffsetRanges.iterator();
    }

    public void setLiveRound() {
        this.isLiveRound = true;
    }

    public boolean isLiveRound() {
        return this.isLiveRound;
    }

    public void debug() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Wave Data: ");
        buffer.append("oBT: ").append(WaveData.formatDebug(this.originalBearingToTarget));
        buffer.append(", oLV: ").append(WaveData.formatDebug(this.originalLateralVelocity));
        buffer.append(", oHV: ").append(WaveData.formatDebug(this.originalHeadonVelocity));
        buffer.append(", oCwDW: ").append(WaveData.formatDebug(this.originalCwDistanceToWall));
        buffer.append(", oCcwDW: ").append(WaveData.formatDebug(this.originalCcwDistanceToWall));
        Debug.debug(buffer.toString());
    }

    private static String formatDebug(double value) {
        String formattedValue = null;
        formattedValue = value == 0.0 ? " 0.0000" : (value > 0.0 ? " " + Debug.trim(value) : Debug.trim(value));
        return formattedValue;
    }
}

