/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.targeting;

import pedersen.debug.Debug;
import pedersen.tactics.targeting.TargetingMethod;

public class TargetingStatistics {
    private final TargetingMethod targetingMethod;
    private long fired = 0L;
    private long hit = 0L;
    private long intercepted = 0L;
    private long cancelled = 0L;

    public TargetingStatistics(TargetingMethod newTargetingMethod) {
        this.targetingMethod = newTargetingMethod;
    }

    public TargetingMethod getTargetingMethod() {
        return this.targetingMethod;
    }

    public void incrementFired() {
        ++this.fired;
    }

    public void incrementHit() {
        ++this.hit;
    }

    public void incrementIntercepted() {
        ++this.intercepted;
    }

    public void incrementCancelled() {
        ++this.cancelled;
    }

    public double getSuccessRate() {
        double successRate = 0.0;
        long shotsTaken = this.fired - this.intercepted - this.cancelled;
        if (shotsTaken > 0L) {
            successRate = (double)this.hit / (double)shotsTaken;
        }
        return successRate;
    }

    public double getInterceptRate() {
        double successRate = 0.0;
        long shotsTaken = this.fired - this.hit - this.cancelled;
        if (shotsTaken > 0L) {
            successRate = (double)this.intercepted / (double)shotsTaken;
        }
        return successRate;
    }

    public String getSummary() {
        StringBuffer buffer = new StringBuffer();
        if (this.fired > 0L) {
            buffer.append("Success rate: " + Debug.trim(100.0 * this.getSuccessRate()) + "% of " + this.fired + " shots.");
        } else {
            buffer.append("No bullets fired.");
        }
        return buffer.toString();
    }
}

