/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import shrub.Bearing;
import shrub.BodyInstruction;
import shrub.Heading;
import shrub.Location;
import shrub.Navigator;

public class Body {
    private int mMode = 0;
    private Location mWaypointLocn = new Location();
    private Heading mRobotHdng = new Heading();
    private Location mRobotLocn = new Location();
    private long mTimeNow = 0L;
    private double mRobotRadius = 0.0;
    private boolean mAllowReversal = false;
    private double mMaxTurnRate = 10.0;
    private double mMaxMoveAmount = 25.0;
    private double mWaypointProximity = 10.0;
    private long mMaxWaypointDuration = 0L;
    private long mWaypointTimeoutTime = 999999L;
    private long mNumWaypointTimeouts = 0L;
    private long mNumTimesRammer = 0L;
    private long mNumTimesRammee = 0L;
    private long mNumTimesHitWall = 0L;
    private long mNumTimesHitByBullet = 0L;
    private Navigator mNavigatorRef = null;

    public void Initialise() {
        this.SetMode(0);
        this.mWaypointLocn.Initialise();
        this.mRobotLocn.Initialise();
        this.mRobotHdng.Initialise();
        this.mTimeNow = 0L;
        this.mRobotRadius = 20.0;
        this.mAllowReversal = false;
        this.mMaxTurnRate = 10.0;
        this.mWaypointProximity = 10.0;
        this.mMaxWaypointDuration = 0L;
        this.mWaypointTimeoutTime = 999999L;
        this.mNumWaypointTimeouts = 0L;
        this.mNumTimesRammer = 0L;
        this.mNumTimesRammee = 0L;
        this.mNumTimesHitWall = 0L;
        this.mNumTimesHitByBullet = 0L;
        this.mNavigatorRef = null;
    }

    public void SetNavigatorRef(Navigator navRef) {
        this.mNavigatorRef = navRef;
    }

    public void SetTimeNow(long timeNow) {
        this.mTimeNow = timeNow;
    }

    public void SetRobotRadius(double newValue) {
        this.mRobotRadius = newValue;
    }

    public void SetMaxTurnRate(double newValue) {
        this.mMaxTurnRate = newValue;
    }

    public void SetAllowReversal(boolean newValue) {
        this.mAllowReversal = newValue;
    }

    public void SetMaxWaypointDuration(long newValue) {
        this.mMaxWaypointDuration = newValue;
    }

    public void SetWaypointTimeoutTime(long newValue) {
        this.mWaypointTimeoutTime = newValue;
    }

    public void SetMode(int newMode) {
        this.mMode = newMode;
    }

    public void SetRobotLocn(double newX, double newY) {
        this.mRobotLocn.SetX(newX);
        this.mRobotLocn.SetY(newY);
    }

    public void SetRobotLocn(Location robotLocn) {
        this.mRobotLocn.Set(robotLocn);
    }

    public void SetRobotHdng(double newHdng) {
        this.mRobotHdng.Set(newHdng);
    }

    public void SetWaypointLocn(double newX, double newY) {
        Location newLocn = new Location();
        newLocn.Set(newX, newY);
        this.SetWaypointLocn(newLocn);
    }

    public void SetWaypointLocn(Location newLocn) {
        this.mWaypointLocn.Set(newLocn);
        this.mWaypointTimeoutTime = this.mMaxWaypointDuration > 0L ? this.mTimeNow + this.mMaxWaypointDuration : 999998L;
    }

    public final double GetRobotRadius() {
        return this.mRobotRadius;
    }

    public final Heading GetRobotHdng() {
        return this.mRobotHdng;
    }

    public final Location GetRobotLocn() {
        return this.mRobotLocn;
    }

    public final long GetNumWaypointTimeouts() {
        return this.mNumWaypointTimeouts;
    }

    public final long GetNumTimesRammer() {
        return this.mNumTimesRammer;
    }

    public final long GetNumTimesRammee() {
        return this.mNumTimesRammee;
    }

    public final long GetNumTimesHitWall() {
        return this.mNumTimesHitWall;
    }

    public final long GetNumTimesHitByBullet() {
        return this.mNumTimesHitByBullet;
    }

    public BodyInstruction[] Process() {
        boolean waypointReached = false;
        BodyInstruction[] instructArray = new BodyInstruction[]{new BodyInstruction(), new BodyInstruction(), new BodyInstruction()};
        instructArray[0].SetNothing();
        instructArray[1].SetNothing();
        instructArray[2].SetNothing();
        if (this.mMode != 0) {
            if (this.mMode == 1) {
                this.ProcessWaypointMove(instructArray);
            } else if (this.mMode == 2) {
                waypointReached = this.ProcessWaypointMove(instructArray);
                if (waypointReached) {
                    Location newWp = this.mNavigatorRef.RandomWaypointAbs();
                    this.SetWaypointLocn(newWp);
                }
            } else if (this.mMode == 3) {
                waypointReached = this.ProcessWaypointMove(instructArray);
                if (waypointReached) {
                    Location newWp = this.mNavigatorRef.RandomWaypointRel(this.mRobotLocn);
                    this.SetWaypointLocn(newWp);
                }
            } else if (this.mMode == 4) {
                waypointReached = this.ProcessWaypointMove(instructArray);
                if (waypointReached) {
                    Location newWp = this.mNavigatorRef.QuantumGravWaypoint(this.mRobotLocn);
                    this.SetWaypointLocn(newWp);
                }
            } else {
                System.out.println("*** ERROR: Body::Process, unexpected mode");
            }
        }
        return instructArray;
    }

    private final boolean ProcessWaypointMove(BodyInstruction[] instructArray) {
        boolean achieved = false;
        double targetDist = 0.0;
        int index = 0;
        Heading waypointHdng = new Heading();
        Bearing relBearing = new Bearing();
        boolean reversing = false;
        targetDist = this.mRobotLocn.DistanceTo(this.mWaypointLocn);
        waypointHdng.SetFromTo(this.mRobotLocn, this.mWaypointLocn);
        relBearing.SetFromTo(this.mRobotHdng, waypointHdng);
        index = 0;
        if (relBearing.IsAligned()) {
            reversing = false;
        } else if (relBearing.IsOpposed() && this.mAllowReversal) {
            reversing = true;
        } else if (relBearing.IsForward() || relBearing.IsBackward() && !this.mAllowReversal) {
            reversing = false;
            double turnAmount = this.mMaxTurnRate;
            if (relBearing.GetAbs() < turnAmount) {
                turnAmount = relBearing.GetAbs();
            }
            if (relBearing.IsLeft()) {
                instructArray[index].SetTurnLeft(turnAmount);
            } else {
                instructArray[index].SetTurnRight(turnAmount);
            }
            ++index;
        } else if (relBearing.IsBackward() && this.mAllowReversal) {
            reversing = true;
            Bearing flippedBearing = new Bearing();
            flippedBearing.Set(relBearing);
            flippedBearing.Flip();
            double turnAmount = this.mMaxTurnRate;
            if (flippedBearing.GetAbs() < turnAmount) {
                turnAmount = flippedBearing.GetAbs();
            }
            if (flippedBearing.IsLeft()) {
                instructArray[index].SetTurnLeft(turnAmount);
            } else {
                instructArray[index].SetTurnRight(turnAmount);
            }
            ++index;
        } else {
            System.out.println("ERROR: Body::ProcessWaypointMove, unexpected mode");
        }
        if (targetDist > this.mWaypointProximity && !this.WaypointTimeout()) {
            double moveAmount = this.mMaxMoveAmount;
            if (moveAmount > targetDist) {
                moveAmount = targetDist;
            }
            if (reversing) {
                instructArray[index].SetMoveBack(moveAmount);
            } else {
                instructArray[index].SetMoveAhead(moveAmount);
            }
        } else {
            achieved = true;
            instructArray[index].SetAchieved();
        }
        return achieved;
    }

    private final boolean WaypointTimeout() {
        boolean answer = false;
        if (this.mMaxWaypointDuration > 0L && this.mTimeNow >= this.mWaypointTimeoutTime) {
            answer = true;
            ++this.mNumWaypointTimeouts;
        }
        return answer;
    }

    public void ActOnRobotHitRobot(HitRobotEvent event) {
        if (event.isMyFault()) {
            ++this.mNumTimesRammer;
            if (this.mMode == 2 || this.mMode == 3 || this.mMode == 4) {
                Bearing brng = new Bearing();
                brng.Set(event.getBearing());
                brng.Flip();
                Heading hdng = new Heading();
                hdng.Set(this.mRobotHdng);
                hdng.Adjust(brng);
                Location newWp = new Location();
                newWp.SetRelative(this.mRobotLocn, hdng, 100.0);
                this.SetWaypointLocn(newWp);
            }
        } else {
            ++this.mNumTimesRammee;
        }
    }

    public void ActOnRobotHitWall(HitWallEvent event) {
        ++this.mNumTimesHitWall;
        if (this.mMode == 2) {
            Location newWp = this.mNavigatorRef.RandomWaypointAbs();
            this.SetWaypointLocn(newWp);
        } else if (this.mMode == 3) {
            Location newWp = this.mNavigatorRef.RandomWaypointRel(this.mRobotLocn);
            this.SetWaypointLocn(newWp);
        } else if (this.mMode == 4) {
            Location newWp = this.mNavigatorRef.QuantumGravWaypoint(this.mRobotLocn);
            this.SetWaypointLocn(newWp);
        }
    }

    public void ActOnHitByBullet(HitByBulletEvent event) {
        ++this.mNumTimesHitByBullet;
    }

    public void Print() {
        System.out.println("----- Body::Print() -----");
        System.out.println("mMode: " + this.mMode);
        System.out.print("mWaypoint:");
        this.mWaypointLocn.Print();
        System.out.println();
        System.out.print("mRobotLocn:");
        this.mRobotLocn.Print();
        System.out.println();
        System.out.println("-------------------------");
    }
}

