/*
 * Decompiled with CFR 0.152.
 */
package cuoq.targeting;

import cuoq.Component;
import cuoq.Utils;
import cuoq.targeting.DCGFFrame;
import cuoq.targeting.DCGFWave;
import cuoq.targeting.FrameMatch;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.Rules;
import robocode.ScannedRobotEvent;

public class DCGFGun
extends Component {
    private static final int NUM_FRAMES = 1000;
    private static final int NUM_SITUATIONS = 10;
    private static final int DENSITY_SIZE = 48;
    private static ArrayList<DCGFFrame> frames = new ArrayList(1250);
    private static ArrayList<FrameMatch> closestMatches = new ArrayList(1250);
    private ArrayList<Point2D.Double> targets = new ArrayList(25);
    private int timeSinceDirChange = 0;
    private int timeSinceLastStop = 0;
    private double lastHeading = 0.0;
    private double lastVelocity = 0.0;
    private int lateralDirection = 1;
    private ArrayList<Point2D.Double> pifTargets = new ArrayList();
    private Point2D.Double enemyLocation = new Point2D.Double();
    private Point2D.Double currentLocation = new Point2D.Double();
    private Point2D.Double bestLocation;
    private DCGFFrame currentFrame;
    private DCGFFrame matchFrame;
    private int densityCount = 0;

    public DCGFGun(AdvancedRobot robot) {
        super(robot);
        this.currentLocation = new Point2D.Double(robot.getX(), robot.getY());
    }

    @Override
    public void onPaint(Graphics2D g) {
        if (this.bestLocation != null) {
            Point2D.Double p;
            g.setColor(Color.CYAN);
            int i = 0;
            while (i < this.targets.size()) {
                p = this.targets.get(i);
                g.fillOval((int)p.x - 2, (int)p.y - 2, 4, 4);
                ++i;
            }
            i = 0;
            while (i < this.pifTargets.size()) {
                g.setColor(Color.MAGENTA);
                p = this.pifTargets.get(i);
                g.fillOval((int)p.x - 2, (int)p.y - 2, 4, 4);
                g.setColor(Color.WHITE);
                Point2D.Double patternToGF = Utils.project(this.currentLocation, Utils.angleBetweenPoints(this.currentLocation, p), this.currentLocation.distance(this.enemyLocation));
                g.drawLine((int)p.x, (int)p.y, (int)patternToGF.x, (int)patternToGF.y);
                ++i;
            }
            g.setColor(Color.RED);
            g.drawOval((int)this.bestLocation.x - 24, (int)this.bestLocation.y - 24, 48, 48);
            g.drawOval((int)this.bestLocation.x - 12, (int)this.bestLocation.y - 12, 24, 24);
            g.setColor(Color.WHITE);
            g.drawString(String.format("Dist Delta: %.1f (%.1f/%.1f)", this.currentFrame.distance - this.matchFrame.distance, this.currentFrame.distance, this.matchFrame.distance), 10, 10);
            g.drawString(String.format("Vel Delta: %.1f (%.1f/%.1f)", this.currentFrame.velocity - this.matchFrame.velocity, this.currentFrame.velocity, this.matchFrame.velocity), 10, 25);
            g.drawString(String.format("LatVel Delta: %.1f (%.1f/%.1f)", this.currentFrame.latVelocity - this.matchFrame.latVelocity, this.currentFrame.latVelocity, this.matchFrame.latVelocity), 10, 40);
            g.drawString(String.format("Acceleration Delta: %.1f (%.1f/%.1f)", this.currentFrame.acceleration - this.matchFrame.acceleration, this.currentFrame.acceleration, this.matchFrame.acceleration), 10, 55);
            g.drawString(String.format("TSLDC Delta: %.1f (%.1f/%.1f)", this.currentFrame.getTimeSinceDirChange() - this.matchFrame.getTimeSinceDirChange(), this.currentFrame.getTimeSinceDirChange(), this.matchFrame.getTimeSinceDirChange()), 10, 70);
            g.drawString(String.format("TSLS Delta: %.1f (%.1f/%.1f)", this.currentFrame.getTimeSinceLastStop() - this.matchFrame.getTimeSinceLastStop(), this.currentFrame.getTimeSinceLastStop(), this.matchFrame.getTimeSinceLastStop()), 10, 85);
            g.drawString(String.format("Heading Delta: %.1f (%.1f/%.1f)", this.currentFrame.headingChange - this.matchFrame.headingChange, this.currentFrame.headingChange, this.matchFrame.headingChange), 10, 100);
            g.drawString(String.format("Best Index: %d", frames.indexOf(this.matchFrame)), 10, 115);
            g.drawString(String.format("Log: %d Possible Matches: %d", frames.size(), closestMatches.size()), 10, 130);
            g.drawString(String.format("GF: %.2f Density: %d", this.matchFrame.getGuessFactor(), this.densityCount), 10, 145);
        }
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        double absoluteBearing = this.robot.getHeadingRadians() + e.getBearingRadians();
        double deltaHeading = e.getHeadingRadians() - this.lastHeading;
        double lateralVelocity = Math.sin(e.getHeadingRadians() - absoluteBearing) * e.getVelocity();
        double deltaVelocity = lateralVelocity - this.lastVelocity;
        if (lateralVelocity > 0.0) {
            this.lateralDirection = 1;
        } else if (lateralVelocity < 0.0) {
            this.lateralDirection = -1;
        }
        double direction = this.lastVelocity > 0.0 ? 1 : -1;
        this.lastVelocity = lateralVelocity;
        this.lastHeading = e.getHeadingRadians();
        boolean doNotShoot = false;
        this.currentLocation.setLocation(this.robot.getX(), this.robot.getY());
        this.enemyLocation.setLocation(Math.sin(absoluteBearing) * e.getDistance() + this.robot.getX(), Math.cos(absoluteBearing) * e.getDistance() + this.robot.getY());
        this.timeSinceLastStop = lateralVelocity < 0.1 && lateralVelocity > -0.1 ? 0 : ++this.timeSinceLastStop;
        this.timeSinceDirChange = lateralVelocity * direction < 0.0 ? 0 : ++this.timeSinceDirChange;
        DCGFFrame frame = new DCGFFrame(deltaHeading, e.getHeadingRadians(), e.getVelocity(), lateralVelocity, deltaVelocity, e.getDistance(), this.timeSinceLastStop, this.timeSinceDirChange);
        double bulletPower = Utils.limit(1.0, 750.0 / e.getDistance(), 3.0);
        if (bulletPower > e.getEnergy() / 3.0) {
            bulletPower = e.getEnergy() / 3.0;
        }
        if (this.robot.getEnergy() < 15.0) {
            bulletPower = this.robot.getEnergy() / 15.0;
        }
        if (e.getDistance() < 100.0) {
            bulletPower = 3.0;
        }
        if (this.robot.getEnergy() < 5.0 && e.getEnergy() > 0.5) {
            doNotShoot = true;
        }
        bulletPower = Utils.limit(0.1, bulletPower, 3.0);
        DCGFWave w = new DCGFWave(this, frame, (Point2D.Double)this.currentLocation.clone(), absoluteBearing, bulletPower, this.lateralDirection);
        this.robot.addCustomEvent((Condition)w);
        if (!doNotShoot) {
            closestMatches.clear();
            this.targets.clear();
            this.pifTargets.clear();
            this.bestLocation = (Point2D.Double)this.enemyLocation.clone();
            double mea = Utils.getMaximumEscapeArea(Rules.getBulletSpeed((double)bulletPower));
            int i = 0;
            while (i < frames.size()) {
                DCGFFrame f = frames.get(i);
                if (f.getGuessFactor() != null) {
                    closestMatches.add(new FrameMatch(f, i, frame.calculateEuclidean(f)));
                }
                ++i;
            }
            Collections.sort(closestMatches);
            this.matchFrame = closestMatches.size() > 0 ? DCGFGun.closestMatches.get((int)0).frame : frame;
            this.densityCount = 0;
            i = 0;
            while (i < 10 && i < closestMatches.size()) {
                FrameMatch match = closestMatches.get(i);
                if (match.frame.getGuessFactor() != null) {
                    Point2D.Double targetLocation = Utils.project(this.currentLocation, absoluteBearing + mea * match.frame.getGuessFactor() * (double)this.lateralDirection, e.getDistance());
                    targetLocation.x = Utils.limit(18.0, targetLocation.x, this.robot.getBattleFieldWidth() - 36.0);
                    targetLocation.y = Utils.limit(18.0, targetLocation.y, this.robot.getBattleFieldHeight() - 36.0);
                    this.targets.add(targetLocation);
                }
                Point2D.Double patternTarget = this.predictPosition(this.currentLocation, (Point2D.Double)this.enemyLocation.clone(), e.getHeadingRadians(), match.frameIndex, Rules.getBulletSpeed((double)bulletPower), e.getVelocity());
                Point2D.Double patternToGF = Utils.project(this.currentLocation, Utils.angleBetweenPoints(this.currentLocation, patternTarget), e.getDistance());
                this.targets.add(patternToGF);
                this.pifTargets.add(patternTarget);
                ++i;
            }
            i = 0;
            while (i < this.targets.size()) {
                Point2D.Double targetLocation = this.targets.get(i);
                Rectangle2D.Double densityArea = new Rectangle2D.Double(targetLocation.x - 24.0, targetLocation.y - 24.0, 48.0, 48.0);
                int numNear = 0;
                int j = 0;
                while (j < this.targets.size()) {
                    Point2D.Double comparingLocation = this.targets.get(j);
                    if (densityArea.contains(comparingLocation)) {
                        ++numNear;
                    }
                    ++j;
                }
                if (numNear >= this.densityCount) {
                    this.bestLocation = targetLocation;
                    this.densityCount = numNear;
                }
                ++i;
            }
            this.robot.setTurnGunRightRadians(Utils.normalRelativeAngle(Utils.angleBetweenPoints(this.currentLocation, this.bestLocation) - this.robot.getGunHeadingRadians()));
            this.robot.setFire(bulletPower);
        } else {
            this.robot.setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - this.robot.getGunHeadingRadians()));
        }
        if (frames.size() + 5 > 1000) {
            frames.subList(0, 100).clear();
        }
        if (this.robot.getEnergy() > 0.0) {
            frames.add(frame);
        }
        this.currentFrame = frame;
    }

    public Point2D.Double getEnemyLocation() {
        return this.enemyLocation;
    }

    public void removeGFWave(DCGFWave wave) {
        this.robot.removeCustomEvent((Condition)wave);
    }

    public Point2D.Double predictPosition(Point2D.Double currentPosition, Point2D.Double enemyPosition, double heading, int matchIndex, double bulletVelocity, double currVelocity) {
        boolean targetHit = false;
        int count = 0;
        double bulletDistance = 0.0 - bulletVelocity * 2.0;
        double velocity = currVelocity;
        DCGFFrame lastFrame = frames.size() == 0 ? new DCGFFrame(0.0, heading, currVelocity, currVelocity, 0.0, 0.0, 0, 0) : (frames.size() < matchIndex ? frames.get(frames.size() - 1) : frames.get(matchIndex));
        velocity = lastFrame.getVelocity();
        do {
            if (frames.size() > matchIndex + count && matchIndex != -1) {
                lastFrame = frames.get(matchIndex + count);
            }
            heading = Utils.normalAbsoluteAngle(lastFrame.headingChange + heading);
            velocity += lastFrame.getVelocity() - velocity;
            double enemyX = Math.max(18.0, Math.min(Math.sin(heading) * velocity + enemyPosition.x, this.robot.getBattleFieldWidth() - 36.0));
            double enemyY = Math.max(18.0, Math.min(Math.cos(heading) * velocity + enemyPosition.y, this.robot.getBattleFieldHeight() - 36.0));
            enemyPosition.setLocation(enemyX, enemyY);
            ++count;
            bulletDistance += bulletVelocity;
            if (!(bulletDistance >= currentPosition.distance(enemyPosition) + 36.0)) continue;
            targetHit = true;
        } while (!targetHit && count < 250);
        return enemyPosition;
    }
}

