/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rGun;

import dsekercioglu.mega.core.wiki.FastMath;
import dsekercioglu.mega.rGun.GunUtils;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class BattleInfo
implements Cloneable {
    final AdvancedRobot BOT;
    final double BATTLE_FIELD_WIDTH;
    final double BATTLE_FIELD_HEIGHT;
    final double GUN_COOLING_RATE;
    Point2D.Double botLocation = new Point2D.Double();
    Point2D.Double enemyLocation = new Point2D.Double();
    double botVelocity;
    double botLateralVelocity;
    double botEnergy;
    double botBearing;
    double botHeading;
    double botDistance;
    double absoluteBearing;
    double enemyEnergy;
    double enemyLastFirePower;
    double enemyVel;
    double enemyLatVel;
    double enemyHeading;
    double enemyRelativeHeading;
    int enemyLateralDirection = 1;
    double enemyLateralAcceleration;
    double enemyAdvVel;
    double enemyTimeSinceDeceleration;
    boolean enemyFired = false;
    double lastFirePower;
    ArrayList<Double> enemyLateralVelocityList;
    int fired;

    public BattleInfo(AdvancedRobot advBot) {
        this.BOT = advBot;
        this.BATTLE_FIELD_WIDTH = advBot.getBattleFieldWidth();
        this.BATTLE_FIELD_HEIGHT = advBot.getBattleFieldHeight();
        this.GUN_COOLING_RATE = advBot.getGunCoolingRate();
    }

    public void run() {
        this.enemyLateralVelocityList = new ArrayList();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.botLocation.setLocation(this.BOT.getX(), this.BOT.getY());
        this.botEnergy = this.BOT.getEnergy();
        double oldEnemyEnergy = this.enemyEnergy;
        this.enemyEnergy = e.getEnergy();
        double deltaEnergy = oldEnemyEnergy - this.enemyEnergy;
        if (deltaEnergy > 0.099 && deltaEnergy < 3.01) {
            this.enemyFired = true;
            this.enemyLastFirePower = deltaEnergy;
        } else {
            this.enemyFired = false;
        }
        this.enemyVel = e.getVelocity();
        this.botHeading = this.BOT.getHeadingRadians();
        this.botBearing = e.getBearingRadians();
        this.botVelocity = this.BOT.getVelocity();
        this.botLateralVelocity = FastMath.sin(this.botBearing) * this.botVelocity;
        this.absoluteBearing = this.botHeading + this.botBearing;
        this.enemyHeading = e.getHeadingRadians();
        this.enemyRelativeHeading = this.enemyHeading - this.absoluteBearing;
        this.enemyLateralAcceleration = Math.abs(this.enemyLatVel);
        this.enemyLatVel = FastMath.sin(this.enemyRelativeHeading) * this.enemyVel;
        this.enemyLateralAcceleration -= Math.abs(this.enemyLatVel);
        this.enemyLateralAcceleration = -this.enemyLateralAcceleration;
        this.enemyLateralVelocityList.add(this.enemyLatVel);
        this.enemyLateralDirection = this.enemyLatVel > 0.0 ? 1 : (this.enemyLatVel == 0.0 ? this.enemyLateralDirection : -1);
        this.enemyAdvVel = FastMath.cos(this.enemyRelativeHeading) * -this.enemyVel;
        this.botDistance = e.getDistance();
        this.enemyLocation.setLocation(GunUtils.project(this.botLocation, this.absoluteBearing, this.botDistance));
        this.enemyTimeSinceDeceleration = this.enemyLateralAcceleration < 0.0 ? 0.0 : this.enemyTimeSinceDeceleration + 1.0;
    }

    public void onFire() {
        ++this.fired;
    }

    public double getFired() {
        return this.fired;
    }

    public BattleInfo clone() {
        try {
            BattleInfo clone = (BattleInfo)super.clone();
            clone.enemyLocation = (Point2D.Double)this.enemyLocation.clone();
            clone.botLocation = (Point2D.Double)this.botLocation.clone();
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(BattleInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public double getBotEnergy() {
        return this.botEnergy;
    }

    public double getBotLateralVelocity() {
        return this.botLateralVelocity;
    }

    public double getEnemyEnergy() {
        return this.enemyEnergy;
    }

    public double getEnemyVelocity() {
        return this.enemyVel;
    }

    public double getEnemyLateralVelocity() {
        return this.enemyLatVel;
    }

    public double getEnemyAdvancingVelocity() {
        return this.enemyAdvVel;
    }

    public int getEnemyLateralDirection() {
        return this.enemyLateralDirection;
    }

    public double getBotDistance() {
        return this.botDistance;
    }

    public double getEnemyHeading() {
        return this.enemyHeading;
    }

    public double getEnemyLateralAcceleration() {
        return this.enemyLateralAcceleration;
    }

    public double getEnemyTimeSinceDeceleration() {
        return this.enemyTimeSinceDeceleration;
    }

    public double getLastFirePower() {
        return this.lastFirePower;
    }

    public double getEnemyLastFirePower() {
        return this.enemyLastFirePower;
    }

    public boolean enemyFired() {
        return this.enemyFired;
    }

    public void setLastFirePower(double firePower) {
        this.lastFirePower = firePower;
    }

    public double getEnemyMeanLateralVelocityLastX(int x) {
        int startIndex;
        double sumVelocity = 0.0;
        int clippedX = Math.min(this.enemyLateralVelocityList.size(), x);
        for (int i = startIndex = Math.max(this.enemyLateralVelocityList.size() - clippedX, 0); i < this.enemyLateralVelocityList.size(); ++i) {
            sumVelocity += this.enemyLateralVelocityList.get(i).doubleValue();
        }
        return clippedX == 0 ? 0.0 : sumVelocity / (double)clippedX;
    }

    public double getMEA(int direction) {
        double turnPerTick = 8.0 / this.botDistance;
        double maxIteration = Math.PI * 2 / turnPerTick;
        double angle = this.absoluteBearing;
        double mea = 0.0;
        Point2D.Double predictedPosition = GunUtils.project(this.botLocation, angle, this.botDistance);
        int iteration = 0;
        while (GunUtils.distanceToWall(predictedPosition.x, predictedPosition.y, this.BATTLE_FIELD_WIDTH, this.BATTLE_FIELD_HEIGHT) >= 18.0) {
            mea += turnPerTick;
            predictedPosition = GunUtils.project(this.botLocation, angle += turnPerTick * (double)this.enemyLateralDirection * (double)direction, this.botDistance);
            if (!((double)(++iteration) > maxIteration)) continue;
            break;
        }
        return mea;
    }
}

