/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.movetree.formula.knnformula;

import dsekercioglu.mega.rMove.info.WaveData;
import dsekercioglu.mega.rMove.movetree.formula.knnformula.ContinuousFormula;

public class NormalFormula
extends ContinuousFormula {
    private static final double[] WEIGHTS = new double[]{5.0, 1.0, 3.0, 4.0, 3.0, 3.0};
    private static final double MAX_DISTANCE;

    @Override
    public double[] getWeights() {
        return WEIGHTS;
    }

    @Override
    public double getMaxDistance() {
        return MAX_DISTANCE;
    }

    @Override
    public double[] getDataPoint(WaveData battleInfo) {
        double firePower = battleInfo.getFirePower();
        double circularMEA = 8.0 / (20.0 - 3.0 * firePower);
        double accel = battleInfo.getBotLateralAcceleration();
        double[] normalized = new double[]{Math.abs(battleInfo.getBotLateralVelocity()) / 8.0, (battleInfo.getBotAdvancingVelocity() + 8.0) / 16.0, battleInfo.getBulletFloatTime() / 91.0, Math.min(battleInfo.getForwardWallMEA() / circularMEA, 1.0), (Math.max(accel * 2.0, accel) + 2.0) / 4.0, firePower / 3.0};
        for (int i = 0; i < normalized.length; ++i) {
            int n = i;
            normalized[n] = normalized[n] * WEIGHTS[i];
        }
        return normalized;
    }

    static {
        double maxDistance = 0.0;
        for (double d : WEIGHTS) {
            maxDistance += Math.abs(d);
        }
        MAX_DISTANCE = maxDistance;
    }
}

