/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rMove.sim;

import dsekercioglu.mega.core.GuessFactor;
import dsekercioglu.mega.core.wiki.FastMath;
import dsekercioglu.mega.rMove.MoveUtils;
import dsekercioglu.mega.rMove.info.EnemyTargetingInfo;
import dsekercioglu.mega.rMove.info.WaveData;
import dsekercioglu.mega.rMove.info.battle.BattleSummary;
import dsekercioglu.mega.rMove.mea.MEA;
import dsekercioglu.mega.rMove.sim.Range;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import robocode.Rules;
import robocode.util.Utils;

public class Wave {
    private final double MAX_BOT_WIDTH = 18.0 * Math.sqrt(2.0);
    private final WaveData WAVE_DATA;
    final Point2D.Double SOURCE;
    final double WAVE_POWER;
    final double WAVE_DAMAGE;
    final double WAVE_VELOCITY;
    final double ABS_BEARING;
    final double LATERAL_DIRECTION;
    final double MEA;
    final double MEA_CLOCKWISE;
    final Point2D.Double POS_CLOCKWISE;
    final double MEA_COUNTER_CLOCKWISE;
    final Point2D.Double POS_COUNTER_CLOCKWISE;
    final double CLOCKWISE_MEA_RATIO;
    final double COUNTER_CLOCKWISE_MEA_RATIO;
    double distanceTraveled;
    List<GuessFactor> guessFactors = new ArrayList<GuessFactor>();
    List<Range> bulletShadows = new ArrayList<Range>();
    private boolean botVisited = false;

    public Wave(EnemyTargetingInfo enemyTargetingInfo, WaveData waveData, BattleSummary battleSummary, int deltaTime) {
        this.WAVE_DATA = waveData;
        this.WAVE_POWER = this.WAVE_DATA.getFirePower();
        this.WAVE_DAMAGE = Rules.getBulletDamage((double)this.WAVE_POWER);
        this.WAVE_VELOCITY = Rules.getBulletSpeed((double)this.WAVE_POWER);
        this.ABS_BEARING = enemyTargetingInfo.getAbsoluteBearing();
        this.LATERAL_DIRECTION = battleSummary.getBotLateralDirection();
        this.SOURCE = (Point2D.Double)enemyTargetingInfo.getSource().clone();
        this.distanceTraveled = this.WAVE_VELOCITY * (double)deltaTime;
        MEA mea = new MEA(battleSummary.getBattleFieldWidth(), battleSummary.getBattleFieldHeight());
        mea.calculateEscapeAngle(battleSummary.getBotLocation(), enemyTargetingInfo.getSource(), this.WAVE_VELOCITY);
        this.MEA_CLOCKWISE = Math.abs(Utils.normalRelativeAngle((double)(mea.getEscapeAngle(1) - this.ABS_BEARING)));
        this.POS_CLOCKWISE = mea.getEscapePosition(1);
        this.MEA_COUNTER_CLOCKWISE = Math.abs(Utils.normalRelativeAngle((double)(mea.getEscapeAngle(-1) - this.ABS_BEARING)));
        this.POS_COUNTER_CLOCKWISE = mea.getEscapePosition(-1);
        this.MEA = FastMath.asin(8.0 / this.WAVE_VELOCITY);
        this.CLOCKWISE_MEA_RATIO = this.MEA_CLOCKWISE / this.MEA;
        this.COUNTER_CLOCKWISE_MEA_RATIO = this.MEA_COUNTER_CLOCKWISE / this.MEA;
    }

    public void setGuessFactors(List<GuessFactor> guessFactors) {
        this.guessFactors = new ArrayList<GuessFactor>();
        for (GuessFactor guessFactor : guessFactors) {
            GuessFactor scaledGuessFactor = new GuessFactor(this.scaleGuessFactor(guessFactor.GUESS_FACTOR * this.LATERAL_DIRECTION) * this.LATERAL_DIRECTION, guessFactor.getWeight(), guessFactor.SCAN);
            this.guessFactors.add(scaledGuessFactor);
        }
    }

    public List<GuessFactor> getGuessFactors() {
        return this.guessFactors;
    }

    public boolean update(Point2D.Double targetLocation) {
        this.distanceTraveled += this.WAVE_VELOCITY;
        this.botVisited = this.distanceTraveled > this.SOURCE.distance(targetLocation);
        return this.distanceTraveled > this.SOURCE.distance(targetLocation) + this.MAX_BOT_WIDTH * 3.0;
    }

    public boolean botVisited() {
        return this.botVisited;
    }

    public double getGuessFactor(double x, double y) {
        double deltaAngle = Utils.normalRelativeAngle((double)(MoveUtils.absoluteBearing(this.SOURCE, new Point2D.Double(x, y)) - this.ABS_BEARING));
        return deltaAngle / this.MEA * this.LATERAL_DIRECTION;
    }

    public double getPreciseGuessFactor(double x, double y) {
        double deltaAngle = Utils.normalRelativeAngle((double)(MoveUtils.absoluteBearing(this.SOURCE, new Point2D.Double(x, y)) - this.ABS_BEARING));
        return this.descaleGuessFactor(deltaAngle / this.MEA) * this.LATERAL_DIRECTION;
    }

    public double getDanger(double startGuessFactor, double endGuessFactor, double smoothFactor) {
        return this.getGuessFactorDanger(startGuessFactor, endGuessFactor, smoothFactor) - this.getShadowedDanger(startGuessFactor, endGuessFactor, smoothFactor);
    }

    private double getGuessFactorDanger(double startGuessFactor, double endGuessFactor, double smoothFactor) {
        double totalDanger = 0.0;
        for (GuessFactor guessFactor : this.guessFactors) {
            totalDanger += this.getDangerForOneGuessFactor(startGuessFactor, endGuessFactor, guessFactor, smoothFactor);
        }
        return totalDanger;
    }

    private double getDangerForOneGuessFactor(double startGuessFactor, double endGuessFactor, GuessFactor guessFactor, double smoothFactor) {
        double checkGuessFactor = guessFactor.GUESS_FACTOR;
        return this.integrateDanger(endGuessFactor - checkGuessFactor, guessFactor.getWeight(), smoothFactor) - this.integrateDanger(startGuessFactor - checkGuessFactor, guessFactor.getWeight(), smoothFactor);
    }

    private double scaleGuessFactor(double guessFactor) {
        return guessFactor * (guessFactor < 0.0 ? this.COUNTER_CLOCKWISE_MEA_RATIO : this.CLOCKWISE_MEA_RATIO);
    }

    private double descaleGuessFactor(double guessFactor) {
        return guessFactor * (guessFactor < 0.0 ? 1.0 / this.COUNTER_CLOCKWISE_MEA_RATIO : 1.0 / this.CLOCKWISE_MEA_RATIO);
    }

    private double getShadowedDanger(double startGuessFactor, double endGuessFactor, double smoothFactor) {
        Range range = new Range(startGuessFactor, endGuessFactor);
        List<Range> intersections = Range.getIntersection(range, this.bulletShadows);
        double shadowedDanger = 0.0;
        for (Range currentRange : intersections) {
            for (GuessFactor guessFactor : this.guessFactors) {
                shadowedDanger += this.getDangerForOneGuessFactor(currentRange.getMin(), currentRange.getMax(), guessFactor, smoothFactor);
            }
        }
        return shadowedDanger;
    }

    private double integrateDanger(double value, double weight, double smoothFactor) {
        return smoothFactor * weight * FastMath.atan(value / smoothFactor);
    }

    public void addShadow(Point2D.Double bulletLocation, double bulletSpeed, double bulletAngle) {
        Point2D.Double previousBulletLocation = MoveUtils.project(bulletLocation, bulletAngle, -bulletSpeed);
        Line2D.Double bulletSegment = new Line2D.Double(previousBulletLocation, bulletLocation);
        double r0 = this.distanceTraveled;
        double r1 = this.distanceTraveled + this.WAVE_VELOCITY;
        double newR0 = Math.max(r0, this.SOURCE.distance(bulletSegment.x1, bulletSegment.y1));
        double newR1 = Math.min(r1, this.SOURCE.distance(bulletSegment.x2, bulletSegment.y2));
        Point2D.Double intersection0 = r0 != newR0 ? previousBulletLocation : this.getIntersection(this.SOURCE, bulletSegment, r0);
        Point2D.Double intersection1 = r1 != newR1 ? bulletLocation : this.getIntersection(this.SOURCE, bulletSegment, r1);
        if (intersection0 != null && intersection1 != null) {
            double gf0 = this.getGuessFactor(intersection0.x, intersection0.y);
            double gf1 = this.getGuessFactor(intersection1.x, intersection1.y);
            Range range = new Range(gf0, gf1);
            for (int i = 0; i < this.bulletShadows.size(); ++i) {
                Range currentRange = this.bulletShadows.get(i);
                Range[] ranges = Range.merge(range, currentRange);
                if (ranges.length != 1) continue;
                this.bulletShadows.remove(i);
                --i;
                range = ranges[0];
            }
            this.bulletShadows.add(range);
        }
    }

    public Point2D.Double getIntersection(Point2D.Double center, Line2D.Double segment, double radius) {
        Line2D.Double tranlatedSegment = new Line2D.Double(segment.x1 - center.x, segment.y1 - center.y, segment.x2 - center.x, segment.y2 - center.y);
        double m = (tranlatedSegment.y1 - tranlatedSegment.y2) / (tranlatedSegment.x1 - tranlatedSegment.x2);
        double n = tranlatedSegment.y1 - m * tranlatedSegment.x1;
        double mSqP1 = m * m + 1.0;
        double radSq = radius * radius;
        double nSq = n * n;
        double mn = m * n;
        double squareRoot = Math.sqrt(mSqP1 * radSq - nSq);
        double x1 = -(squareRoot + mn) / mSqP1;
        double y1 = (n - m * squareRoot) / mSqP1;
        if (MoveUtils.limitMinMax(tranlatedSegment.x1, x1, tranlatedSegment.x2) == x1 && MoveUtils.limitMinMax(tranlatedSegment.y1, y1, tranlatedSegment.y2) == y1) {
            return new Point2D.Double(center.x + x1, center.y + y1);
        }
        double x2 = (squareRoot - mn) / mSqP1;
        double y2 = (m * squareRoot + n) / mSqP1;
        if (MoveUtils.limitMinMax(tranlatedSegment.x1, x2, tranlatedSegment.x2) == x2 && MoveUtils.limitMinMax(tranlatedSegment.y1, y2, tranlatedSegment.y2) == y2) {
            return new Point2D.Double(center.x + x2, center.y + y2);
        }
        return null;
    }

    public WaveData getWaveData() {
        return this.WAVE_DATA;
    }

    public Point2D.Double getSource() {
        return this.SOURCE;
    }

    public double getDistanceTraveled() {
        return this.distanceTraveled;
    }

    public double getWaveVelocity() {
        return this.WAVE_VELOCITY;
    }

    public double getAbsoluteBearing() {
        return this.ABS_BEARING;
    }

    public double getLateralDirection() {
        return this.LATERAL_DIRECTION;
    }

    public double getMEAClockwise() {
        return this.MEA_CLOCKWISE;
    }

    public double getMEACounterClowise() {
        return this.MEA_COUNTER_CLOCKWISE;
    }

    public double getMEA() {
        return this.MEA;
    }

    public double getWavePower() {
        return this.WAVE_POWER;
    }

    public double getWaveDamage() {
        return this.WAVE_DAMAGE;
    }

    public Point2D.Double getPositionClockwise() {
        return this.POS_CLOCKWISE;
    }

    public Point2D.Double getPositionCounterClockwise() {
        return this.POS_COUNTER_CLOCKWISE;
    }
}

