/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.predict.TargetPrediction;
import agd.predict.Trackable;
import agd.util.Aim;
import agd.util.AimStrategy;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.Enemy;
import agd.util.RobotInformation;
import agd.util.World;
import robocode.AdvancedRobot;

public class BestThreeSpread
implements AimStrategy {
    RobotInformation ri = null;
    AdvancedRobot ar = null;
    int predictionIndex = 0;

    public BestThreeSpread(RobotInformation ri) {
        this.ri = ri;
        this.ar = ri.getAdvancedRobot();
    }

    public static Coord iterate(double power, Coord shooterpos, Trackable target, long shotTime, TargetPrediction alg) {
        double bvel = 20.0 - 3.0 * power;
        double distance = 0.0;
        long timeToTarget = 0L;
        Coord estimatedPosition = null;
        Coord previousEstimate = null;
        int i = 0;
        while (i < 10) {
            previousEstimate = estimatedPosition;
            estimatedPosition = alg.predictTarget(target, shotTime + timeToTarget);
            distance = shooterpos.distanceTo(estimatedPosition);
            timeToTarget = (long)(distance / bvel);
            if (previousEstimate != null && estimatedPosition.distanceTo(previousEstimate) < 1.0) break;
            ++i;
        }
        return estimatedPosition;
    }

    public Aim aimAtTarget(Enemy e) {
        if (e == null) {
            return new Aim(new Double(0.0), 0.0);
        }
        if (e.getLastSighting() == null) {
            return new Aim(new Double(0.0), 0.0);
        }
        TargetPrediction prediction = TargetPrediction.CIRCULAR;
        Coord ourpos = this.ri.getPosition();
        long timeToTarget = 0L;
        Coord estPos = prediction.predictTarget(e, World.getTime() + 1L);
        double distance = ourpos.distanceTo(estPos);
        double power = this.firePower(distance, e);
        int roughFlightTime = (int)(distance / World.calcBulletVelocity(power));
        prediction = e.isDisabled() ? TargetPrediction.STATIONARY : e.getStats().getBestPrediction(roughFlightTime, this.predictionIndex);
        estPos = BestThreeSpread.iterate(power, ourpos, e, World.getTime() + 1L, prediction);
        double bfWidth = World.getBattleFieldSize().getX();
        double bfHeight = World.getBattleFieldSize().getY();
        estPos = new Coord(Math.max(estPos.getX(), 0.0), Math.max(estPos.getY(), 0.0));
        estPos = new Coord(Math.min(estPos.getX(), bfWidth), Math.min(estPos.getY(), bfHeight));
        Compass shotHeading = ourpos.headingTo(estPos);
        Compass gunHeading = new Compass(this.ar.getGunHeading());
        double gunBearing = gunHeading.bearingTo(shotHeading);
        if (!this.decideToShoot(this.ar.getGunHeat(), gunBearing, power, distance)) {
            power = 0.0;
        } else if (World.isDebug()) {
            System.out.println("Shooting at " + e + " power " + World.twodp.format(power) + " using " + prediction + ", index " + this.predictionIndex);
        }
        if (power != 0.0) {
            this.predictionIndex = (this.predictionIndex + 1) % 3;
        }
        return new Aim(new Double(gunBearing), power);
    }

    boolean decideToShoot(double gunHeat, double gunBearing, double power, double distance) {
        double allowedGunDrift = Math.toDegrees(Math.atan(20.0 / distance) / 2.0);
        boolean shoot = true;
        if (gunHeat > 0.0 || Math.abs(gunBearing) > allowedGunDrift || power < 0.1 || power > 4.0) {
            shoot = false;
        }
        return shoot;
    }

    double firePower(double distance, Enemy e) {
        return 2.0;
    }
}

