/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.util.AdvancedRobotAdapter;
import agd.util.AdvancedRobotListener;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.Enemy;
import agd.util.RobotSighting;
import agd.util.World;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.Map;
import robocode.DeathEvent;
import robocode.RobocodeFileWriter;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class RobotLogger
extends AdvancedRobotAdapter
implements AdvancedRobotListener {
    RobocodeFileWriter writer = null;
    Map watchList = null;
    boolean logRobots = false;

    public RobotLogger(File directory, int roundNum) throws IOException {
        this.logRobots = this.readControlFile(directory);
        if (this.logRobots) {
            File file = new File(directory.getPath() + File.separator + "robotlog." + roundNum);
            this.writer = new RobocodeFileWriter(file);
        }
    }

    boolean readControlFile(File directory) {
        boolean loggingOn = false;
        File controlFile = new File(directory.getPath() + File.separator + "robotlog.control");
        if (controlFile.exists() && controlFile.isFile()) {
            try {
                LineNumberReader controlReader = new LineNumberReader(new FileReader(controlFile));
                this.watchList = new HashMap();
                while (controlReader.ready()) {
                    String robot = controlReader.readLine();
                    if (robot == null) break;
                    if (robot.length() <= 0) continue;
                    this.watchList.put(robot, robot);
                }
                if (this.watchList.size() == 0) {
                    this.watchList = null;
                }
                loggingOn = true;
            }
            catch (IOException ioe) {
                System.out.println("Error reading robotlog.control file (no robots will be logged): " + ioe);
            }
        } else {
            this.watchList = null;
        }
        return loggingOn;
    }

    public void onWin(WinEvent we) {
        this.closeFile();
    }

    public void onDeath(DeathEvent de) {
        this.closeFile();
    }

    void closeFile() {
        try {
            if (this.logRobots) {
                this.writer.close();
            }
        }
        catch (IOException ioe) {
            System.out.println("Unable to close file " + this.writer + ", error: " + ioe);
        }
    }

    public void onEnemySighted(Enemy enemy) {
        if (this.logRobots && (this.watchList == null || this.watchList.containsKey(enemy.getName()))) {
            RobotSighting sighting = enemy.getLastSighting();
            double power = 0.0;
            ScannedRobotEvent sre = sighting.getScannedRobotEvent();
            Coord pos = sighting.getTheirPosition();
            Compass heading = sighting.getHeading();
            double velocity = sighting.getVelocity();
            try {
                this.writer.write("ROBOT_LOG," + enemy.getName() + "," + sre.getTime() + "," + World.twodp.format(pos.getX()) + "," + World.twodp.format(pos.getY()) + "," + World.twodp.format(heading.getDegrees()) + "," + velocity + "," + power + "\n");
            }
            catch (IOException ioe) {
                System.out.println("Caught the following error while trying to append to the robot log file: " + ioe);
            }
        }
    }
}

