/*
 * Decompiled with CFR 0.152.
 */
package execution;

import execution.GunListener$$Lambda$1;
import execution.INotifiable;
import execution.Message;
import execution.MessageRouter;
import execution.Painter;
import execution.Sequencer;
import gun.GunSelector;
import gun.IGun;
import gun.SequencerPredictor;
import java.awt.geom.Point2D;
import robocode.util.Utils;
import sim.Bot;
import sim.Data;
import sim.Stat;

public class GunListener
implements INotifiable {
    private Sequencer _sequencer;
    private double _previousHeat;
    private GunSelector _selector;
    private Painter _painter;

    public GunListener(Sequencer sequencer, Painter debug) {
        this._sequencer = sequencer;
        this._painter = debug;
        this._selector = new GunSelector(this._sequencer, this._painter);
    }

    @Override
    public void Initialize(MessageRouter router) {
        router.Subscribe(Message.Kind.Update, GunListener$$Lambda$1.lambdaFactory$(this));
    }

    private final void Update(Message message) {
        Bot target;
        Bot robot = Data.Robots.Self;
        if (Data.Robots.Enemies().size() > 0 && (target = this._selector.GetTarget()) != null && target.Alive) {
            double bulletPower = this._selector.GetBulletPower(target);
            IGun gun = this._selector.GetGun(robot, message.time, target, bulletPower);
            double absoluteBearing = target.Get(Stat.ABSOLUTEBEARING);
            double heat = robot.Get(Stat.GUN_HEAT);
            Bot self = Data.Robots.Self;
            SequencerPredictor selfPredictor = new SequencerPredictor(self.Get(Stat.VELOCITY), self.Get(Stat.HEADING), this._sequencer);
            Point2D.Double myPos = new Point2D.Double();
            myPos.setLocation(self.Position);
            selfPredictor.Step(myPos);
            double bearingDelta = gun.GetDeltaBearing(self, myPos, message.time, target, bulletPower);
            double bearingFromGun = Utils.normalRelativeAngle((double)(absoluteBearing - robot.Get(Stat.GUN_HEADING) + bearingDelta));
            if (this._previousHeat <= 0.0 && heat <= 0.0 && (Double)this._sequencer.aim.remaining <= 0.0 && robot.Get(Stat.ENERGY) > bulletPower && target.IsThreat()) {
                this._sequencer.bulletColor.set(gun.GetBulletColor());
                this._sequencer.Fire(target, bulletPower, message);
            }
            this._previousHeat = heat;
            this._sequencer.Aim(bearingFromGun);
        }
    }

    static /* synthetic */ void access$lambda$0(GunListener gunListener, Message message) {
        gunListener.Update(message);
    }
}

