/*
 * Decompiled with CFR 0.152.
 */
package grav;

import grav.GravPoint;
import grav.GravRobot;
import grav.GravityCollection;
import java.awt.geom.Point2D;
import java.util.HashSet;
import math.Vect2d;
import sim.Bot;
import sim.Data;

public class RobotCollection
extends GravityCollection {
    private HashSet<String> _robots = new HashSet();
    private GravPoint _centroid = new GravPoint(2500.0, 1.5, new Point2D.Double());
    private final double _pointStrength = 2500.0;

    public RobotCollection() {
        this.Add(this._centroid);
    }

    @Override
    public Vect2d GetEffectiveGravity(long time) {
        int total = this._robots.size();
        double xCentroid = 0.0;
        double yCentroid = 0.0;
        for (Bot robot : Data.Robots.Enemies()) {
            if (!robot.Alive) continue;
            xCentroid += robot.Position.getX();
            yCentroid += robot.Position.getY();
            if (this._robots.contains(robot.Name)) continue;
            this._robots.add(robot.Name);
            this.Add(new GravRobot(robot));
        }
        if (total > 0) {
            this._centroid.Location.setLocation(xCentroid / (double)total, yCentroid / (double)total);
        } else {
            this.Remove(this._centroid);
        }
        return super.GetEffectiveGravity(time);
    }
}

