/*
 * Decompiled with CFR 0.152.
 */
package gun;

import execution.Painter;
import execution.Sequencer;
import gun.CircularGun;
import gun.HeadOnGun;
import gun.IGun;
import gun.LinearGun;
import sim.Bot;
import sim.Data;
import sim.Stat;

public class GunSelector {
    private IGun[] _guns = new IGun[3];

    public GunSelector(Sequencer sequencer, Painter debug) {
        this._guns[0] = new HeadOnGun();
        this._guns[1] = new LinearGun(sequencer, debug);
        this._guns[2] = new CircularGun(sequencer, debug);
    }

    public Bot GetTarget() {
        for (Bot enemy : Data.Robots.Enemies()) {
            if (!enemy.Alive) continue;
            return enemy;
        }
        return null;
    }

    public double GetBulletPower(Bot target) {
        double hitRate = target.Get(Stat.SHOTS_PERCENT_LANDED);
        double distance = target.Get(Stat.DISTANCE);
        double baseDamage = 1.0 + hitRate + Math.min(250.0, distance) / distance;
        baseDamage = target.Get(Stat.APPROACH_VELOCITY) > 4.0 ? (target.Get(Stat.DISTANCE) < 108.0 ? 3.0 : Math.max(baseDamage, 3.0 * Math.min(4.0, Math.abs(target.Get(Stat.APPROACH_VELOCITY))) / 4.0)) : (baseDamage *= Math.max(Data.Robots.Self.Get(Stat.ENERGY), 100.0) / 100.0);
        return baseDamage;
    }

    public IGun GetGun(Bot self, long time, Bot target, double bulletPower) {
        if (Math.abs(target.Get(Stat.LATERAL_ACCELERATION)) < 0.01 && Math.abs(target.Get(Stat.LATERAL_VELOCITY)) < 0.01) {
            return this._guns[0];
        }
        if (Math.abs(target.Get(Stat.HEADING_OMEGA)) > 0.0 && Math.abs(target.Get(Stat.HEADING_ALPHA)) < 0.01 && Math.abs(target.Get(Stat.VELOCITY)) > 0.0) {
            return this._guns[2];
        }
        return this._guns[1];
    }
}

